import { NgModule, InjectionToken } from '@angular/core';
import { WrappedSocket } from './socket-io.service';
/** Socket factory */
export function SocketFactory(config) {
    return new WrappedSocket(config);
}
export const SOCKET_CONFIG_TOKEN = new InjectionToken('__SOCKET_IO_CONFIG__');
export class SocketIoModule {
    static forRoot(config) {
        return {
            ngModule: SocketIoModule,
            providers: [
                { provide: SOCKET_CONFIG_TOKEN, useValue: config },
                {
                    provide: WrappedSocket,
                    useFactory: SocketFactory,
                    deps: [SOCKET_CONFIG_TOKEN]
                }
            ]
        };
    }
}
SocketIoModule.decorators = [
    { type: NgModule, args: [{},] }
];
//# sourceMappingURL=data:application/json;base64,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