import { __decorate, __read, __spread } from "tslib";
import { UIROUTER_MODULE_TOKEN, UIROUTER_ROOT_MODULE } from './injectionTokens';
import { NgModule, ANALYZE_FOR_ENTRY_COMPONENTS, APP_INITIALIZER, } from '@angular/core';
import { CommonModule, LocationStrategy, HashLocationStrategy, PathLocationStrategy } from '@angular/common';
import { _UIROUTER_DIRECTIVES } from './directives/directives';
import { UIView } from './directives/uiView';
import { TransitionService } from '@uirouter/core';
import { _UIROUTER_INSTANCE_PROVIDERS, _UIROUTER_SERVICE_PROVIDERS } from './providers';
// Delay angular bootstrap until first transition is successful, for SSR.
// See https://github.com/ui-router/angular/pull/127
export function onTransitionReady(transitionService, root) {
    var mod = root[0];
    if (!mod || !mod.deferInitialRender) {
        return function () { return Promise.resolve(); };
    }
    return function () {
        return new Promise(function (resolve) {
            var hook = function (trans) {
                trans.promise.then(resolve, resolve);
            };
            transitionService.onStart({}, hook, { invokeLimit: 1 });
        });
    };
}
export function makeRootProviders(module) {
    return [
        { provide: UIROUTER_ROOT_MODULE, useValue: module, multi: true },
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
        {
            provide: APP_INITIALIZER,
            useFactory: onTransitionReady,
            deps: [TransitionService, UIROUTER_ROOT_MODULE],
            multi: true,
        },
    ];
}
export function makeChildProviders(module) {
    return [
        { provide: UIROUTER_MODULE_TOKEN, useValue: module, multi: true },
        { provide: ANALYZE_FOR_ENTRY_COMPONENTS, useValue: module.states || [], multi: true },
    ];
}
export function locationStrategy(useHash) {
    return { provide: LocationStrategy, useClass: useHash ? HashLocationStrategy : PathLocationStrategy };
}
/**
 * Creates UI-Router Modules
 *
 * This class has two static factory methods which create UIRouter Modules.
 * A UI-Router Module is an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
 * with support for UI-Router.
 *
 * ### UIRouter Directives
 *
 * When a UI-Router Module is imported into a `NgModule`, that module's components
 * can use the UIRouter Directives such as [[UIView]], [[UISref]], [[UISrefActive]].
 *
 * ### State Definitions
 *
 * State definitions found in the `states:` property are provided to the Dependency Injector.
 * This enables UI-Router to automatically register the states with the [[StateRegistry]] at bootstrap (and during lazy load).
 *
 * ### Entry Components
 *
 * Any routed components are added as `entryComponents:` so they will get compiled.
 */
var UIRouterModule = /** @class */ (function () {
    function UIRouterModule() {
    }
    UIRouterModule_1 = UIRouterModule;
    /**
     * Creates a UI-Router Module for the root (bootstrapped) application module to import
     *
     * This factory function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * The `forRoot` module should be added to the `imports:` of the `NgModule` being bootstrapped.
     * An application should only create and import a single `NgModule` using `forRoot()`.
     * All other modules should be created using [[UIRouterModule.forChild]].
     *
     * Unlike `forChild`, an `NgModule` returned by this factory provides the [[UIRouter]] singleton object.
     * This factory also accepts root-level router configuration.
     * These are the only differences between `forRoot` and `forChild`.
     *
     * Example:
     * ```js
     * let routerConfig = {
     *   otherwise: '/home',
     *   states: [homeState, aboutState]
     * };
     *
     * @ NgModule({
     *   imports: [
     *     BrowserModule,
     *     UIRouterModule.forRoot(routerConfig),
     *     FeatureModule1
     *   ]
     * })
     * class MyRootAppModule {}
     *
     * browserPlatformDynamic.bootstrapModule(MyRootAppModule);
     * ```
     *
     * @param config declarative UI-Router configuration
     * @returns an `NgModule` which provides the [[UIRouter]] singleton instance
     */
    UIRouterModule.forRoot = function (config) {
        if (config === void 0) { config = {}; }
        return {
            ngModule: UIRouterModule_1,
            providers: __spread([
                _UIROUTER_INSTANCE_PROVIDERS,
                _UIROUTER_SERVICE_PROVIDERS,
                locationStrategy(config.useHash)
            ], makeRootProviders(config)),
        };
    };
    /**
     * Creates an `NgModule` for a UIRouter module
     *
     * This function creates an [Angular NgModule](https://angular.io/docs/ts/latest/guide/ngmodule.html)
     * with UI-Router support.
     *
     * #### Example:
     * ```js
     * var homeState = { name: 'home', url: '/home', component: Home };
     * var aboutState = { name: 'about', url: '/about', component: About };
     *
     * @ NgModule({
     *   imports: [
     *     UIRouterModule.forChild({ states: [ homeState, aboutState ] }),
     *     SharedModule,
     *   ],
     *   declarations: [ Home, About ],
     * })
     * export class AppModule {};
     * ```
     *
     * @param module UI-Router module options
     * @returns an `NgModule`
     */
    UIRouterModule.forChild = function (module) {
        if (module === void 0) { module = {}; }
        return {
            ngModule: UIRouterModule_1,
            providers: makeChildProviders(module),
        };
    };
    var UIRouterModule_1;
    UIRouterModule = UIRouterModule_1 = __decorate([
        NgModule({
            imports: [CommonModule],
            declarations: [_UIROUTER_DIRECTIVES],
            exports: [_UIROUTER_DIRECTIVES],
            entryComponents: [UIView],
        })
    ], UIRouterModule);
    return UIRouterModule;
}());
export { UIRouterModule };
//# sourceMappingURL=data:application/json;base64,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