import { __extends } from "tslib";
import { BaseLocationServices, parseUrl } from '@uirouter/core';
/** A `LocationServices` that delegates to the Angular LocationStrategy */
var Ng2LocationServices = /** @class */ (function (_super) {
    __extends(Ng2LocationServices, _super);
    function Ng2LocationServices(router, _locationStrategy, isBrowser) {
        var _this = _super.call(this, router, isBrowser) || this;
        _this._locationStrategy = _locationStrategy;
        _this._locationStrategy.onPopState(function (evt) {
            if (evt.type !== 'hashchange') {
                _this._listener(evt);
            }
        });
        return _this;
    }
    Ng2LocationServices.prototype._get = function () {
        return this._locationStrategy.path(true).replace(this._locationStrategy.getBaseHref().replace(/\/$/, ''), '');
    };
    Ng2LocationServices.prototype._set = function (state, title, url, replace) {
        var _a = parseUrl(url), path = _a.path, search = _a.search, hash = _a.hash;
        var urlPart = search ? path : path + (hash ? '#' + hash : '');
        var searchPart = search + (hash ? '#' + hash : '');
        if (replace) {
            this._locationStrategy.replaceState(state, title, urlPart, searchPart);
        }
        else {
            this._locationStrategy.pushState(state, title, urlPart, searchPart);
        }
    };
    Ng2LocationServices.prototype.dispose = function (router) {
        _super.prototype.dispose.call(this, router);
    };
    return Ng2LocationServices;
}(BaseLocationServices));
export { Ng2LocationServices };
//# sourceMappingURL=data:application/json;base64,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