import { __decorate, __param } from "tslib";
import { UIRouter, extend, Obj, TransitionOptions, TargetState, isNumber, isNullOrUndefined } from '@uirouter/core';
import { Directive, Inject, Input, Optional, ElementRef, Renderer2, OnChanges, SimpleChanges, HostListener, } from '@angular/core';
import { UIView } from './uiView';
import { ReplaySubject } from 'rxjs';
/**
 * @internal
 * # blah blah blah
 */
var AnchorUISref = /** @class */ (function () {
    function AnchorUISref(_el, _renderer) {
        this._el = _el;
        this._renderer = _renderer;
    }
    AnchorUISref.prototype.openInNewTab = function () {
        return this._el.nativeElement.target === '_blank';
    };
    AnchorUISref.prototype.update = function (href) {
        if (!isNullOrUndefined(href)) {
            this._renderer.setProperty(this._el.nativeElement, 'href', href);
        }
        else {
            this._renderer.removeAttribute(this._el.nativeElement, 'href');
        }
    };
    AnchorUISref.ctorParameters = function () { return [
        { type: ElementRef },
        { type: Renderer2 }
    ]; };
    AnchorUISref = __decorate([
        Directive({ selector: 'a[uiSref]' })
    ], AnchorUISref);
    return AnchorUISref;
}());
export { AnchorUISref };
/**
 * A directive when clicked, initiates a [[Transition]] to a [[TargetState]].
 *
 * ### Purpose
 *
 * This directive is applied to anchor tags (`<a>`) or any other clickable element.  It is a state reference (or sref --
 * similar to an href).  When clicked, the directive will transition to that state by calling [[StateService.go]],
 * and optionally supply state parameter values and transition options.
 *
 * When this directive is on an anchor tag, it will also add an `href` attribute to the anchor.
 *
 * ### Selector
 *
 * - `[uiSref]`: The directive is created as an attribute on an element, e.g., `<a uiSref></a>`
 *
 * ### Inputs
 *
 * - `uiSref`: the target state's name, e.g., `uiSref="foostate"`.  If a component template uses a relative `uiSref`,
 * e.g., `uiSref=".child"`, the reference is relative to that component's state.
 *
 * - `uiParams`: any target state parameter values, as an object, e.g., `[uiParams]="{ fooId: bar.fooId }"`
 *
 * - `uiOptions`: [[TransitionOptions]], e.g., `[uiOptions]="{ inherit: false }"`
 *
 * @example
 * ```html
 *
 * <!-- Targets bar state' -->
 * <a uiSref="bar">Bar</a>
 *
 * <!-- Assume this component's state is "foo".
 *      Relatively targets "foo.child" -->
 * <a uiSref=".child">Foo Child</a>
 *
 * <!-- Targets "bar" state and supplies parameter value -->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }">Bar {{foo.barId}}</a>
 *
 * <!-- Targets "bar" state and parameter, doesn't inherit existing parameters-->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }" [uiOptions]="{ inherit: false }">Bar {{foo.barId}}</a>
 * ```
 */
var UISref = /** @class */ (function () {
    function UISref(_router, _anchorUISref, parent) {
        var _this = this;
        /**
         * An observable (ReplaySubject) of the state this UISref is targeting.
         * When the UISref is clicked, it will transition to this [[TargetState]].
         */
        this.targetState$ = new ReplaySubject(1);
        /** @internal */ this._emit = false;
        this._router = _router;
        this._anchorUISref = _anchorUISref;
        this._parent = parent;
        this._statesSub = _router.globals.states$.subscribe(function () { return _this.update(); });
    }
    Object.defineProperty(UISref.prototype, "uiSref", {
        /** @internal */
        set: function (val) {
            this.state = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UISref.prototype, "uiParams", {
        /** @internal */
        set: function (val) {
            this.params = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(UISref.prototype, "uiOptions", {
        /** @internal */
        set: function (val) {
            this.options = val;
            this.update();
        },
        enumerable: true,
        configurable: true
    });
    UISref.prototype.ngOnInit = function () {
        this._emit = true;
        this.update();
    };
    UISref.prototype.ngOnChanges = function (changes) {
        this.update();
    };
    UISref.prototype.ngOnDestroy = function () {
        this._emit = false;
        this._statesSub.unsubscribe();
        this.targetState$.unsubscribe();
    };
    UISref.prototype.update = function () {
        var $state = this._router.stateService;
        if (this._emit) {
            var newTarget = $state.target(this.state, this.params, this.getOptions());
            this.targetState$.next(newTarget);
        }
        if (this._anchorUISref) {
            if (!this.state) {
                this._anchorUISref.update(null);
            }
            else {
                var href = $state.href(this.state, this.params, this.getOptions()) || '';
                this._anchorUISref.update(href);
            }
        }
    };
    UISref.prototype.getOptions = function () {
        var defaultOpts = {
            relative: this._parent && this._parent.context && this._parent.context.name,
            inherit: true,
            source: 'sref',
        };
        return extend(defaultOpts, this.options || {});
    };
    /** When triggered by a (click) event, this function transitions to the UISref's target state */
    UISref.prototype.go = function (button, ctrlKey, metaKey) {
        if ((this._anchorUISref &&
            (this._anchorUISref.openInNewTab() || button || !isNumber(button) || ctrlKey || metaKey)) ||
            !this.state) {
            return;
        }
        this._router.stateService.go(this.state, this.params, this.getOptions());
        return false;
    };
    UISref.ctorParameters = function () { return [
        { type: UIRouter },
        { type: AnchorUISref, decorators: [{ type: Optional }] },
        { type: undefined, decorators: [{ type: Inject, args: [UIView.PARENT_INJECT,] }] }
    ]; };
    __decorate([
        Input('uiSref')
    ], UISref.prototype, "state", void 0);
    __decorate([
        Input('uiParams')
    ], UISref.prototype, "params", void 0);
    __decorate([
        Input('uiOptions')
    ], UISref.prototype, "options", void 0);
    __decorate([
        HostListener('click', ['$event.button', '$event.ctrlKey', '$event.metaKey'])
    ], UISref.prototype, "go", null);
    UISref = __decorate([
        Directive({
            selector: '[uiSref]',
            exportAs: 'uiSref',
        }),
        __param(1, Optional()),
        __param(2, Inject(UIView.PARENT_INJECT))
    ], UISref);
    return UISref;
}());
export { UISref };
//# sourceMappingURL=data:application/json;base64,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