import { isFunction } from '@uirouter/core';
import { pick, forEach } from '@uirouter/core';
import { services } from '@uirouter/core';
import { ViewService } from '@uirouter/core';
/**
 * This is a [[StateBuilder.builder]] function for Angular `views`.
 *
 * When the [[StateBuilder]] builds a [[State]] object from a raw [[StateDeclaration]], this builder
 * handles the `views` property with logic specific to @uirouter/angular.
 *
 * If no `views: {}` property exists on the [[StateDeclaration]], then it creates the `views` object and
 * applies the state-level configuration to a view named `$default`.
 */
export function ng2ViewsBuilder(state) {
    const views = {}, viewsObject = state.views || { $default: pick(state, ['component', 'bindings']) };
    forEach(viewsObject, function (config, name) {
        name = name || '$default'; // Account for views: { "": { template... } }
        if (isFunction(config))
            config = { component: config };
        if (Object.keys(config).length === 0)
            return;
        config.$type = 'ng2';
        config.$context = state;
        config.$name = name;
        const normalized = ViewService.normalizeUIViewTarget(config.$context, config.$name);
        config.$uiViewName = normalized.uiViewName;
        config.$uiViewContextAnchor = normalized.uiViewContextAnchor;
        views[name] = config;
    });
    return views;
}
let id = 0;
export class Ng2ViewConfig {
    constructor(path, viewDecl) {
        this.path = path;
        this.viewDecl = viewDecl;
        this.$id = id++;
        this.loaded = true;
    }
    load() {
        return services.$q.when(this);
    }
}
//# sourceMappingURL=data:application/json;base64,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