import { BaseLocationServices, parseUrl } from '@uirouter/core';
/** A `LocationServices` that delegates to the Angular LocationStrategy */
export class Ng2LocationServices extends BaseLocationServices {
    constructor(router, _locationStrategy, isBrowser) {
        super(router, isBrowser);
        this._locationStrategy = _locationStrategy;
        this._locationStrategy.onPopState((evt) => {
            if (evt.type !== 'hashchange') {
                this._listener(evt);
            }
        });
    }
    _get() {
        return this._locationStrategy.path(true).replace(this._locationStrategy.getBaseHref().replace(/\/$/, ''), '');
    }
    _set(state, title, url, replace) {
        const { path, search, hash } = parseUrl(url);
        const urlPart = search ? path : path + (hash ? '#' + hash : '');
        const searchPart = search + (hash ? '#' + hash : '');
        if (replace) {
            this._locationStrategy.replaceState(state, title, urlPart, searchPart);
        }
        else {
            this._locationStrategy.pushState(state, title, urlPart, searchPart);
        }
    }
    dispose(router) {
        super.dispose(router);
    }
}
//# sourceMappingURL=data:application/json;base64,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