var UIView_1;
import { __decorate, __param } from "tslib";
import { Component, ComponentFactory, ComponentFactoryResolver, ComponentRef, Inject, Injector, Input, OnDestroy, OnInit, ReflectiveInjector, ViewChild, ViewContainerRef, } from '@angular/core';
import { ActiveUIView, filter, inArray, isFunction, NATIVE_INJECTOR_TOKEN, Param, parse, PathNode, ResolveContext, StateDeclaration, trace, Transition, TransitionHookFn, UIRouter, unnestR, ViewConfig, ViewContext, } from '@uirouter/core';
import { Ng2ViewConfig } from '../statebuilders/views';
import { MergeInjector } from '../mergeInjector';
/** @hidden */
let id = 0;
/**
 * Given a component class, gets the inputs of styles:
 *
 * - @Input('foo') _foo
 * - `inputs: ['foo']`
 *
 * @internal
 */
const ng2ComponentInputs = (factory) => {
    return factory.inputs.map((input) => ({ prop: input.propName, token: input.templateName }));
};
const ɵ0 = ng2ComponentInputs;
/**
 * A UI-Router viewport directive, which is filled in by a view (component) on a state.
 *
 * ### Selector
 *
 * A `ui-view` directive can be created as an element: `<ui-view></ui-view>` or as an attribute: `<div ui-view></div>`.
 *
 * ### Purpose
 *
 * This directive is used in a Component template (or as the root component) to create a viewport.  The viewport
 * is filled in by a view (as defined by a [[Ng2ViewDeclaration]] inside a [[Ng2StateDeclaration]]) when the view's
 * state has been activated.
 *
 * #### Example:
 * ```js
 * // This app has two states, 'foo' and 'bar'
 * stateRegistry.register({ name: 'foo', url: '/foo', component: FooComponent });
 * stateRegistry.register({ name: 'bar', url: '/bar', component: BarComponent });
 * ```
 * ```html
 * <!-- This ui-view will be filled in by the foo state's component or
 *      the bar state's component when the foo or bar state is activated -->
 * <ui-view></ui-view>
 * ```
 *
 * ### Named ui-views
 *
 * A `ui-view` may optionally be given a name via the attribute value: `<div ui-view='header'></div>`.  *Note:
 * an unnamed `ui-view` is internally named `$default`*.   When a `ui-view` has a name, it will be filled in
 * by a matching named view.
 *
 * #### Example:
 * ```js
 * stateRegistry.register({
 *   name: 'foo',
 *   url: '/foo',
 *   views: { header: HeaderComponent, $default: FooComponent });
 * ```
 * ```html
 * <!-- When 'foo' state is active, filled by HeaderComponent -->
 * <div ui-view="header"></div>
 *
 * <!-- When 'foo' state is active, filled by FooComponent -->
 * <ui-view></ui-view>
 * ```
 */
let UIView = UIView_1 = class UIView {
    constructor(router, parent, viewContainerRef) {
        this.router = router;
        this.viewContainerRef = viewContainerRef;
        /** Data about the this UIView */
        this._uiViewData = {};
        this._parent = parent;
    }
    set _name(val) {
        this.name = val;
    }
    /**
     * @returns the UI-Router `state` that is filling this uiView, or `undefined`.
     */
    get state() {
        return parse('_uiViewData.config.viewDecl.$context.self')(this);
    }
    ngOnInit() {
        const router = this.router;
        const parentFqn = this._parent.fqn;
        const name = this.name || '$default';
        this._uiViewData = {
            $type: 'ng2',
            id: id++,
            name: name,
            fqn: parentFqn ? parentFqn + '.' + name : name,
            creationContext: this._parent.context,
            configUpdated: this._viewConfigUpdated.bind(this),
            config: undefined,
        };
        this._deregisterUiCanExitHook = router.transitionService.onBefore({}, (trans) => {
            return this._invokeUiCanExitHook(trans);
        });
        this._deregisterUiOnParamsChangedHook = router.transitionService.onSuccess({}, (trans) => this._invokeUiOnParamsChangedHook(trans));
        this._deregisterUIView = router.viewService.registerUIView(this._uiViewData);
    }
    /**
     * For each transition, checks the component loaded in the ui-view for:
     *
     * - has a uiCanExit() component hook
     * - is being exited
     *
     * If both are true, adds the uiCanExit component function as a hook to that singular Transition.
     */
    _invokeUiCanExitHook(trans) {
        const instance = this._componentRef && this._componentRef.instance;
        const uiCanExitFn = instance && instance.uiCanExit;
        if (isFunction(uiCanExitFn)) {
            const state = this.state;
            if (trans.exiting().indexOf(state) !== -1) {
                trans.onStart({}, function () {
                    return uiCanExitFn.call(instance, trans);
                });
            }
        }
    }
    /**
     * For each transition, checks if any param values changed and notify component
     */
    _invokeUiOnParamsChangedHook($transition$) {
        const instance = this._componentRef && this._componentRef.instance;
        const uiOnParamsChanged = instance && instance.uiOnParamsChanged;
        if (isFunction(uiOnParamsChanged)) {
            const viewState = this.state;
            const resolveContext = new ResolveContext(this._uiViewData.config.path);
            const viewCreationTrans = resolveContext.getResolvable('$transition$').data;
            // Exit early if the $transition$ is the same as the view was created within.
            // Exit early if the $transition$ will exit the state the view is for.
            if ($transition$ === viewCreationTrans || $transition$.exiting().indexOf(viewState) !== -1)
                return;
            const toParams = $transition$.params('to');
            const fromParams = $transition$.params('from');
            const getNodeSchema = (node) => node.paramSchema;
            const toSchema = $transition$.treeChanges('to').map(getNodeSchema).reduce(unnestR, []);
            const fromSchema = $transition$.treeChanges('from').map(getNodeSchema).reduce(unnestR, []);
            // Find the to params that have different values than the from params
            const changedToParams = toSchema.filter((param) => {
                const idx = fromSchema.indexOf(param);
                return idx === -1 || !fromSchema[idx].type.equals(toParams[param.id], fromParams[param.id]);
            });
            // Only trigger callback if a to param has changed or is new
            if (changedToParams.length) {
                const changedKeys = changedToParams.map((x) => x.id);
                // Filter the params to only changed/new to params.  `$transition$.params()` may be used to get all params.
                const newValues = filter(toParams, (val, key) => changedKeys.indexOf(key) !== -1);
                instance.uiOnParamsChanged(newValues, $transition$);
            }
        }
    }
    _disposeLast() {
        if (this._componentRef)
            this._componentRef.destroy();
        this._componentRef = null;
    }
    ngOnDestroy() {
        if (this._deregisterUIView)
            this._deregisterUIView();
        if (this._deregisterUiCanExitHook)
            this._deregisterUiCanExitHook();
        if (this._deregisterUiOnParamsChangedHook)
            this._deregisterUiOnParamsChangedHook();
        this._deregisterUIView = this._deregisterUiCanExitHook = this._deregisterUiOnParamsChangedHook = null;
        this._disposeLast();
    }
    /**
     * The view service is informing us of an updated ViewConfig
     * (usually because a transition activated some state and its views)
     */
    _viewConfigUpdated(config) {
        // The config may be undefined if there is nothing currently targeting this UIView.
        // Dispose the current component, if there is one
        if (!config)
            return this._disposeLast();
        // Only care about Ng2 configs
        if (!(config instanceof Ng2ViewConfig))
            return;
        // The "new" viewconfig is already applied, so exit early
        if (this._uiViewData.config === config)
            return;
        // This is a new ViewConfig.  Dispose the previous component
        this._disposeLast();
        trace.traceUIViewConfigUpdated(this._uiViewData, config && config.viewDecl.$context);
        this._applyUpdatedConfig(config);
        // Initiate change detection for the newly created component
        this._componentRef.changeDetectorRef.markForCheck();
    }
    _applyUpdatedConfig(config) {
        this._uiViewData.config = config;
        // Create the Injector for the routed component
        const context = new ResolveContext(config.path);
        const componentInjector = this._getComponentInjector(context);
        // Get the component class from the view declaration. TODO: allow promises?
        const componentClass = config.viewDecl.component;
        // Create the component
        const compFactoryResolver = componentInjector.get(ComponentFactoryResolver);
        const compFactory = compFactoryResolver.resolveComponentFactory(componentClass);
        this._componentRef = this._componentTarget.createComponent(compFactory, undefined, componentInjector);
        // Wire resolves to @Input()s
        this._applyInputBindings(compFactory, this._componentRef.instance, context, componentClass);
    }
    /**
     * Creates a new Injector for a routed component.
     *
     * Adds resolve values to the Injector
     * Adds providers from the NgModule for the state
     * Adds providers from the parent Component in the component tree
     * Adds a PARENT_INJECT view context object
     *
     * @returns an Injector
     */
    _getComponentInjector(context) {
        // Map resolves to "useValue: providers"
        const resolvables = context
            .getTokens()
            .map((token) => context.getResolvable(token))
            .filter((r) => r.resolved);
        const newProviders = resolvables.map((r) => ({ provide: r.token, useValue: context.injector().get(r.token) }));
        const parentInject = { context: this._uiViewData.config.viewDecl.$context, fqn: this._uiViewData.fqn };
        newProviders.push({ provide: UIView_1.PARENT_INJECT, useValue: parentInject });
        const parentComponentInjector = this.viewContainerRef.injector;
        const moduleInjector = context.getResolvable(NATIVE_INJECTOR_TOKEN).data;
        const mergedParentInjector = new MergeInjector(moduleInjector, parentComponentInjector);
        return ReflectiveInjector.resolveAndCreate(newProviders, mergedParentInjector);
    }
    /**
     * Supplies component inputs with resolve data
     *
     * Finds component inputs which match resolves (by name) and sets the input value
     * to the resolve data.
     */
    _applyInputBindings(factory, component, context, componentClass) {
        const bindings = this._uiViewData.config.viewDecl['bindings'] || {};
        const explicitBoundProps = Object.keys(bindings);
        // Returns the actual component property for a renamed an input renamed using `@Input('foo') _foo`.
        // return the `_foo` property
        const renamedInputProp = (prop) => {
            const input = factory.inputs.find((i) => i.templateName === prop);
            return (input && input.propName) || prop;
        };
        // Supply resolve data to component as specified in the state's `bindings: {}`
        const explicitInputTuples = explicitBoundProps.reduce((acc, key) => acc.concat([{ prop: renamedInputProp(key), token: bindings[key] }]), []);
        // Supply resolve data to matching @Input('prop') or inputs: ['prop']
        const implicitInputTuples = ng2ComponentInputs(factory).filter((tuple) => !inArray(explicitBoundProps, tuple.prop));
        const addResolvable = (tuple) => ({
            prop: tuple.prop,
            resolvable: context.getResolvable(tuple.token),
        });
        const injector = context.injector();
        explicitInputTuples
            .concat(implicitInputTuples)
            .map(addResolvable)
            .filter((tuple) => tuple.resolvable && tuple.resolvable.resolved)
            .forEach((tuple) => {
            component[tuple.prop] = injector.get(tuple.resolvable.token);
        });
    }
};
UIView.PARENT_INJECT = 'UIView.PARENT_INJECT';
UIView.ctorParameters = () => [
    { type: UIRouter },
    { type: undefined, decorators: [{ type: Inject, args: [UIView_1.PARENT_INJECT,] }] },
    { type: ViewContainerRef }
];
__decorate([
    ViewChild('componentTarget', { read: ViewContainerRef, static: true })
], UIView.prototype, "_componentTarget", void 0);
__decorate([
    Input('name')
], UIView.prototype, "name", void 0);
__decorate([
    Input('ui-view')
], UIView.prototype, "_name", null);
UIView = UIView_1 = __decorate([
    Component({
        selector: 'ui-view, [ui-view]',
        exportAs: 'uiView',
        template: `
    <ng-template #componentTarget></ng-template>
    <ng-content *ngIf="!_componentRef"></ng-content>
  `
    }),
    __param(1, Inject(UIView_1.PARENT_INJECT))
], UIView);
export { UIView };
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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