import { __decorate, __param } from "tslib";
import { UIRouter, extend, Obj, TransitionOptions, TargetState, isNumber, isNullOrUndefined } from '@uirouter/core';
import { Directive, Inject, Input, Optional, ElementRef, Renderer2, OnChanges, SimpleChanges, HostListener, } from '@angular/core';
import { UIView } from './uiView';
import { ReplaySubject } from 'rxjs';
/**
 * @internal
 * # blah blah blah
 */
let AnchorUISref = class AnchorUISref {
    constructor(_el, _renderer) {
        this._el = _el;
        this._renderer = _renderer;
    }
    openInNewTab() {
        return this._el.nativeElement.target === '_blank';
    }
    update(href) {
        if (!isNullOrUndefined(href)) {
            this._renderer.setProperty(this._el.nativeElement, 'href', href);
        }
        else {
            this._renderer.removeAttribute(this._el.nativeElement, 'href');
        }
    }
};
AnchorUISref.ctorParameters = () => [
    { type: ElementRef },
    { type: Renderer2 }
];
AnchorUISref = __decorate([
    Directive({ selector: 'a[uiSref]' })
], AnchorUISref);
export { AnchorUISref };
/**
 * A directive when clicked, initiates a [[Transition]] to a [[TargetState]].
 *
 * ### Purpose
 *
 * This directive is applied to anchor tags (`<a>`) or any other clickable element.  It is a state reference (or sref --
 * similar to an href).  When clicked, the directive will transition to that state by calling [[StateService.go]],
 * and optionally supply state parameter values and transition options.
 *
 * When this directive is on an anchor tag, it will also add an `href` attribute to the anchor.
 *
 * ### Selector
 *
 * - `[uiSref]`: The directive is created as an attribute on an element, e.g., `<a uiSref></a>`
 *
 * ### Inputs
 *
 * - `uiSref`: the target state's name, e.g., `uiSref="foostate"`.  If a component template uses a relative `uiSref`,
 * e.g., `uiSref=".child"`, the reference is relative to that component's state.
 *
 * - `uiParams`: any target state parameter values, as an object, e.g., `[uiParams]="{ fooId: bar.fooId }"`
 *
 * - `uiOptions`: [[TransitionOptions]], e.g., `[uiOptions]="{ inherit: false }"`
 *
 * @example
 * ```html
 *
 * <!-- Targets bar state' -->
 * <a uiSref="bar">Bar</a>
 *
 * <!-- Assume this component's state is "foo".
 *      Relatively targets "foo.child" -->
 * <a uiSref=".child">Foo Child</a>
 *
 * <!-- Targets "bar" state and supplies parameter value -->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }">Bar {{foo.barId}}</a>
 *
 * <!-- Targets "bar" state and parameter, doesn't inherit existing parameters-->
 * <a uiSref="bar" [uiParams]="{ barId: foo.barId }" [uiOptions]="{ inherit: false }">Bar {{foo.barId}}</a>
 * ```
 */
let UISref = class UISref {
    constructor(_router, _anchorUISref, parent) {
        /**
         * An observable (ReplaySubject) of the state this UISref is targeting.
         * When the UISref is clicked, it will transition to this [[TargetState]].
         */
        this.targetState$ = new ReplaySubject(1);
        /** @internal */ this._emit = false;
        this._router = _router;
        this._anchorUISref = _anchorUISref;
        this._parent = parent;
        this._statesSub = _router.globals.states$.subscribe(() => this.update());
    }
    /** @internal */
    set uiSref(val) {
        this.state = val;
        this.update();
    }
    /** @internal */
    set uiParams(val) {
        this.params = val;
        this.update();
    }
    /** @internal */
    set uiOptions(val) {
        this.options = val;
        this.update();
    }
    ngOnInit() {
        this._emit = true;
        this.update();
    }
    ngOnChanges(changes) {
        this.update();
    }
    ngOnDestroy() {
        this._emit = false;
        this._statesSub.unsubscribe();
        this.targetState$.unsubscribe();
    }
    update() {
        const $state = this._router.stateService;
        if (this._emit) {
            const newTarget = $state.target(this.state, this.params, this.getOptions());
            this.targetState$.next(newTarget);
        }
        if (this._anchorUISref) {
            if (!this.state) {
                this._anchorUISref.update(null);
            }
            else {
                const href = $state.href(this.state, this.params, this.getOptions()) || '';
                this._anchorUISref.update(href);
            }
        }
    }
    getOptions() {
        const defaultOpts = {
            relative: this._parent && this._parent.context && this._parent.context.name,
            inherit: true,
            source: 'sref',
        };
        return extend(defaultOpts, this.options || {});
    }
    /** When triggered by a (click) event, this function transitions to the UISref's target state */
    go(button, ctrlKey, metaKey) {
        if ((this._anchorUISref &&
            (this._anchorUISref.openInNewTab() || button || !isNumber(button) || ctrlKey || metaKey)) ||
            !this.state) {
            return;
        }
        this._router.stateService.go(this.state, this.params, this.getOptions());
        return false;
    }
};
UISref.ctorParameters = () => [
    { type: UIRouter },
    { type: AnchorUISref, decorators: [{ type: Optional }] },
    { type: undefined, decorators: [{ type: Inject, args: [UIView.PARENT_INJECT,] }] }
];
__decorate([
    Input('uiSref')
], UISref.prototype, "state", void 0);
__decorate([
    Input('uiParams')
], UISref.prototype, "params", void 0);
__decorate([
    Input('uiOptions')
], UISref.prototype, "options", void 0);
__decorate([
    HostListener('click', ['$event.button', '$event.ctrlKey', '$event.metaKey'])
], UISref.prototype, "go", null);
UISref = __decorate([
    Directive({
        selector: '[uiSref]',
        exportAs: 'uiSref',
    }),
    __param(1, Optional()),
    __param(2, Inject(UIView.PARENT_INJECT))
], UISref);
export { UISref };
//# sourceMappingURL=data:application/json;base64,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