var UIRouterUpgradeModule_1;
import { __decorate, __param } from "tslib";
import { Component, ElementRef, Inject, Injector, Input, ModuleWithProviders, NgModule } from '@angular/core';
import { downgradeComponent, UpgradeModule, getAngularJSGlobal, getAngularLib } from '@angular/upgrade/static';
import { StateObject, forEach, PathNode, Resolvable, StateRegistry, UIRouter, ViewConfig, ViewService, } from '@uirouter/core';
import { applyModuleConfig, NATIVE_INJECTOR_TOKEN, ng2LazyLoadBuilder, Ng2ViewConfig, UIView, _UIROUTER_SERVICE_PROVIDERS, UIROUTER_MODULE_TOKEN, UIROUTER_ROOT_MODULE, UIRouterModule, makeChildProviders, } from '@uirouter/angular';
import { Ng1ViewConfig } from '@uirouter/angularjs';
import { UIRouterRx } from '@uirouter/rx';
const getAngularJS = getAngularJSGlobal || getAngularLib;
const angular = getAngularJS();
if (!angular) {
    throw new Error('AngularJS not found on window.  https://github.com/ui-router/angular-hybrid/wiki/AngularJS-not-found-on-window');
}
/**
 * Create a ng1 module for the ng1 half of the hybrid application to depend on.
 *
 * Example:
 * const myApp = angular.module('myApp', ['ui.router.upgrade']);
 */
export const upgradeModule = angular.module('ui.router.upgrade', ['ui.router']);
export function objectFactory() {
    return {};
}
/**
 * UIViewNgUpgrade is a component bridge from ng1 ui-view to ng2 ui-view
 *
 * When a ui-router for ng1 is registering a state it checks if a view's
 * `component:` is an ng2 Component class. If so, it creates a special ng1 template
 * which references this component, i.e., <ui-view-ng-upgrade></ui-view-ng-upgrade>
 *
 * See that code by searching ng1-to-ng2 source for: "$stateProvider.decorator"
 *
 * ---
 *
 * ng1-to-ng2 component bridge process:
 *
 * 1)
 * When an ng1 template creates a ui-view which is targeted by a ng2 Component,
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- ui-view created in ng1 template -->
 * </div> <!-- targeted with { component: Ng2RoutedComponent } -->
 * ```
 *
 * the state decorator spits out a custom template.  That template loads this
 * ng2 Component adapter as a downgraded-to-ng1 directive.
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- decorated template references the downgraded component -->
 *   <ui-view-ng-upgrade> <!-- downgraded adapter component -->
 *   </ui-view-ng-upgrade>
 * </div>
 * ```
 *
 * This downgraded ng2 Component then creates a child UIView (ng2 component)
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- custom template references the downgraded component -->
 *   <ui-view-ng-upgrade> <!-- ng2 component adapter downgraded to ng1-->
 *     <ui-view> <!-- pure ng2 ui-view -->
 *      </ui-view>
 *   </ui-view-ng-upgrade>
 * </div>
 * ```
 *
 * which in turn is filled with the routed ng2 component.
 *
 * ```
 * <a ui-sref="foo">Go to foo</a>
 * <div ui-view> <!-- ng1 ui-view -->
 *   <ui-view-ng-upgrade> <!-- ng2 component adapter (downgraded to ng1)-->
 *     <ui-view> <!-- pure ng2 ui-view -->
 *       <ng2-routed-component> <!-- ng2 component hosted in ng2 ui-view -->
 *         <h1>ng2 routed component contents</h1>
 *       </ng2-routed-component>
 *     </ui-view>
 *   </ui-view-ng-upgrade>
 * </div>
 * ```
 *
 * This adapter exposes exposes the parent view context (ParentUIViewInject)
 * as an ng2 DI Provider, which the nested ng2 UIView requires.
 *
 * It gets the ParentUIViewContext information (from the parent ng1 ui-view) by walking
 * up the DOM and grabbing the .data('$uiView') which the ng1 ui-view directive exposes.
 */
let UIViewNgUpgrade = class UIViewNgUpgrade {
    constructor(ref, parent, registry // access the root state
    ) {
        // From the ui-view-ng-upgrade component's element ref, walk up the DOM two elements...
        // There will first be an ng1 ui-view which hosts this element, and then that ui-view's parent element.
        // That (parent) element has access to the proper "parent viewcontext"
        // The ng2 ui-view component is inside this ui-view-ng-upgrade directive, which is inside the ng1 "host" ui-view.
        // Both ui-views share the same "view context" information (the view's fqn and created-by-state context information)
        const ng1elem = angular.element(ref.nativeElement).parent().parent();
        // Expose getters on PARENT_INJECT for context (creation state) and fqn (view address)
        // These will be used by further nested UIView
        Object.defineProperty(parent, 'context', {
            get: function () {
                const data = ng1elem['inheritedData']('$uiView');
                return data && data.$cfg ? data.$cfg.viewDecl.$context : registry.root();
            },
            enumerable: true,
        });
        Object.defineProperty(parent, 'fqn', {
            get: function () {
                const data = ng1elem['inheritedData']('$uiView');
                return data && data.$uiView ? data.$uiView.fqn : null;
            },
            enumerable: true,
        });
    }
};
UIViewNgUpgrade.ctorParameters = () => [
    { type: ElementRef },
    { type: undefined, decorators: [{ type: Inject, args: [UIView.PARENT_INJECT,] }] },
    { type: StateRegistry // access the root state
     }
];
__decorate([
    Input()
], UIViewNgUpgrade.prototype, "name", void 0);
UIViewNgUpgrade = __decorate([
    Component({
        selector: 'ui-view-ng-upgrade',
        template: ` <ui-view [name]="name"></ui-view> `,
        // provide a blank object as PARENT_INJECT.
        // The component will add property getters when it is constructed.
        viewProviders: [{ provide: UIView.PARENT_INJECT, useFactory: objectFactory }]
    }),
    __param(1, Inject(UIView.PARENT_INJECT))
], UIViewNgUpgrade);
export { UIViewNgUpgrade };
/**********************************
 * Ng2 @NgModule and bootstrap code
 **********************************/
// Register the ng1 DI '$uiRouter' object as an ng2 Provider.
export function uiRouterUpgradeFactory(router, injector) {
    const modules = injector.get(UIROUTER_MODULE_TOKEN, []);
    modules.forEach((module) => applyModuleConfig(router, injector, module));
    return router;
}
export function getUIRouter($injector) {
    return $injector.get('$uiRouter');
}
export function getParentUIViewInject(r) {
    return { fqn: null, context: r.root() };
}
const ɵ0 = {};
/**
 * This NgModule should be added to the root module of the hybrid app.
 */
let UIRouterUpgradeModule = UIRouterUpgradeModule_1 = class UIRouterUpgradeModule {
    static forRoot(module = {}) {
        return {
            ngModule: UIRouterUpgradeModule_1,
            providers: makeChildProviders(module),
        };
    }
    static forChild(module = {}) {
        return {
            ngModule: UIRouterModule,
            providers: makeChildProviders(module),
        };
    }
};
UIRouterUpgradeModule = UIRouterUpgradeModule_1 = __decorate([
    NgModule({
        imports: [UIRouterModule, UpgradeModule],
        declarations: [UIViewNgUpgrade],
        providers: [
            // @uirouter/angular code will use the ng1 $uiRouter instance instead of creating its own.
            { provide: '$uiRouter', useFactory: getUIRouter, deps: ['$injector'] },
            { provide: UIRouter, useFactory: uiRouterUpgradeFactory, deps: ['$uiRouter', Injector] },
            { provide: UIROUTER_ROOT_MODULE, useValue: ɵ0, multi: true },
            { provide: UIView.PARENT_INJECT, useFactory: getParentUIViewInject, deps: [StateRegistry] },
            ..._UIROUTER_SERVICE_PROVIDERS,
        ],
        entryComponents: [UIViewNgUpgrade],
        exports: [UIViewNgUpgrade, UIRouterModule],
    })
], UIRouterUpgradeModule);
export { UIRouterUpgradeModule };
// Downgrade the UIViewNgUpgrade ng2 Component to an ng1 directive.
// The directive is used in a (generated) view template by the (host) ng1 ui-router,
// whenever it finds a view configured with a `component: <Ng2ComponentClass>`
upgradeModule.directive('uiViewNgUpgrade', downgradeComponent({
    component: UIViewNgUpgrade,
    inputs: ['name'],
}));
upgradeModule.run([
    '$injector',
    (ng1Injector) => {
        const $uiRouter = ng1Injector.get('$uiRouter');
        /** Add support for observable state and param changes */
        $uiRouter.plugin(UIRouterRx);
        // Expose a merged ng1/ng2 injector as a Resolvable (on the root state).
        // This mimics how ui-router-ng2 exposes the root ng2 Injector, but
        // it retrieves from ng1 injector first, then ng2 injector if the token isn't found.
        const mergedInjector = {
            get: function (token, ng2NotFoundValue) {
                if (ng1Injector.has(token)) {
                    return ng1Injector.get(token);
                }
                const ng2Injector = ng1Injector.get('$$angularInjector');
                return ng2Injector.get(token, ng2NotFoundValue);
            },
        };
        const ng2InjectorResolvable = Resolvable.fromData(NATIVE_INJECTOR_TOKEN, mergedInjector);
        $uiRouter.stateRegistry.root().resolvables.push(ng2InjectorResolvable);
    },
]);
/** Adds support for `loadChildren`: Angular NgModule lazy loading via @gntools/webpack */
upgradeModule.config([
    '$stateRegistryProvider',
    ($stateRegistry) => {
        $stateRegistry.decorator('lazyLoad', ng2LazyLoadBuilder);
    },
]);
/**
 * Define a stateProvider `views` builder decorator.
 * The decorator first applies the standard views builder function.
 * Then it finds any view components which are **actually** a Ng2 Component Class.
 * It overwrites that view's config with a ng1-to-ng2 hybrid config.
 *
 * In place of the template provider, it simply puts a <ui-view-ng-upgrade/> component
 * which that provides a ng1 -> ng2 boundary in the component tree.
 */
upgradeModule.config([
    '$stateRegistryProvider',
    ($stateRegistry) => {
        $stateRegistry.decorator('views', function (state, parentFn) {
            const views = parentFn(state);
            forEach(views, (viewDecl, viewName) => {
                if (viewDecl.$type === 'ng1-to-ng2' || typeof viewDecl.component === 'function') {
                    // Update the view config.
                    // Override default ng1 `component:` behavior (of defining a templateProvider)
                    // with a <ui-view-ng-upgrade> adapter directive template
                    viewDecl.$type = 'ng1-to-ng2';
                    viewDecl.templateProvider = null;
                    viewDecl.template = `<ui-view-ng-upgrade name='${viewDecl.$uiViewName}'></ui-view-ng-upgrade>`;
                }
            });
            return views;
        });
    },
]);
// UI-Router ViewConfig factories take a view declaration object from a state.views: { foo: <ViewDeclaration> }
// and return a runtime config object (a ViewConfig)
upgradeModule.run([
    '$view',
    '$templateFactory',
    ($view, $templateFactory) => {
        // Register a ViewConfig factory for views of type `ng2`
        $view._pluginapi._viewConfigFactory('ng2', (path, config) => new Ng2ViewConfig(path, config));
        // Register a ViewConfig factory for views of type `ng1-to-ng2`.
        // Returns both an ng1 config and an ng2 config allowing either ng1 or ng2 ui-view components to be targeted.
        $view._pluginapi._viewConfigFactory('ng1-to-ng2', (path, config) => {
            const ng1ViewConfig = (new Ng1ViewConfig(path, Object.assign({}, config, { $type: 'ng1' }), $templateFactory));
            const ng2ViewConfig = (new Ng2ViewConfig(path, Object.assign({}, config, { $type: 'ng2' })));
            return [ng2ViewConfig, ng1ViewConfig];
        });
    },
]);
export { ɵ0 };
//# sourceMappingURL=data:application/json;base64,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