import { reflow } from '../util';
function measureCollapsingElementHeightPx(element) {
    // SSR fix for without injecting the PlatformId
    if (typeof navigator === 'undefined') {
        return '0px';
    }
    const { classList } = element;
    const hasShownClass = classList.contains('show');
    if (!hasShownClass) {
        classList.add('show');
    }
    element.style.height = '';
    const height = element.getBoundingClientRect().height + 'px';
    if (!hasShownClass) {
        classList.remove('show');
    }
    return height;
}
export const ngbCollapsingTransition = (element, animation, context) => {
    let { direction, maxHeight } = context;
    const { classList } = element;
    function setInitialClasses() {
        classList.add('collapse');
        if (direction === 'show') {
            classList.add('show');
        }
        else {
            classList.remove('show');
        }
    }
    // without animations we just need to set initial classes
    if (!animation) {
        setInitialClasses();
        return;
    }
    // No maxHeight -> running the transition for the first time
    if (!maxHeight) {
        maxHeight = measureCollapsingElementHeightPx(element);
        context.maxHeight = maxHeight;
        // Fix the height before starting the animation
        element.style.height = direction !== 'show' ? maxHeight : '0px';
        classList.remove('collapse');
        classList.remove('collapsing');
        classList.remove('show');
        reflow(element);
        // Start the animation
        classList.add('collapsing');
    }
    // Start or revert the animation
    element.style.height = direction === 'show' ? maxHeight : '0px';
    return () => {
        setInitialClasses();
        classList.remove('collapsing');
        element.style.height = '';
    };
};
//# sourceMappingURL=data:application/json;base64,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