import { reflow } from '../util/util';
/**
 * Defines the carousel slide transition direction.
 */
export var NgbSlideEventDirection;
(function (NgbSlideEventDirection) {
    NgbSlideEventDirection["LEFT"] = "left";
    NgbSlideEventDirection["RIGHT"] = "right";
})(NgbSlideEventDirection || (NgbSlideEventDirection = {}));
const isBeingAnimated = ({ classList }) => {
    return classList.contains('carousel-item-left') || classList.contains('carousel-item-right');
};
const ɵ0 = isBeingAnimated;
const removeDirectionClasses = (classList) => {
    classList.remove('carousel-item-left');
    classList.remove('carousel-item-right');
};
const ɵ1 = removeDirectionClasses;
const removeClasses = (classList) => {
    removeDirectionClasses(classList);
    classList.remove('carousel-item-prev');
    classList.remove('carousel-item-next');
};
const ɵ2 = removeClasses;
export const ngbCarouselTransitionIn = (element, animation, { direction }) => {
    const { classList } = element;
    if (!animation) {
        removeDirectionClasses(classList);
        removeClasses(classList);
        classList.add('active');
        return;
    }
    if (isBeingAnimated(element)) {
        // Revert the transition
        removeDirectionClasses(classList);
    }
    else {
        // For the 'in' transition, a 'pre-class' is applied to the element to ensure its visibility
        classList.add('carousel-item-' + (direction === NgbSlideEventDirection.LEFT ? 'next' : 'prev'));
        reflow(element);
        classList.add('carousel-item-' + direction);
    }
    return () => {
        removeClasses(classList);
        classList.add('active');
    };
};
export const ngbCarouselTransitionOut = (element, animation, { direction }) => {
    const { classList } = element;
    if (!animation) {
        removeDirectionClasses(classList);
        removeClasses(classList);
        classList.remove('active');
        return;
    }
    //  direction is left or right, depending on the way the slide goes out.
    if (isBeingAnimated(element)) {
        // Revert the transition
        removeDirectionClasses(classList);
    }
    else {
        classList.add('carousel-item-' + direction);
    }
    return () => {
        removeClasses(classList);
        classList.remove('active');
    };
};
export { ɵ0, ɵ1, ɵ2 };
//# sourceMappingURL=data:application/json;base64,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