import { HttpClient } from '@angular/common/http';
export declare class CNSI18nService {
    private http;
    data: {};
    resolvedFileNames: string[];
    constructor(http: HttpClient);
    /**
     * Fetches All Locale File (except the ones that are already added) and update data
     * @param fileNames URLs of locale Files
     * @returns Promise that resolves after fetching the locale
     */
    addLocales(fileNames: string[]): Promise<any>;
    /**
     * Fetches Locale File and update data
     * @param fileName URL for locale file
     * @returns Promise which is fulfilled after APi calls
     */
    addLocale(fileName: string): Promise<any>;
    /**
     * Update the locale data for translation.
     * @param data JSON object to update locale keys
     */
    addData(data: any): void;
}
