import { ElementRef, OnInit } from '@angular/core';
import { ControlValueAccessor, FormControl } from '@angular/forms';
import { BaseFieldComponent } from '../base-field/base-field.component';
export interface DropdownOption {
    label: string;
    value: string;
    [key: string]: any;
}
export declare const enum ListType {
    object = "object",
    string = "string"
}
export declare class SelectComponent extends BaseFieldComponent implements OnInit, ControlValueAccessor {
    searchEnabled: boolean;
    divClass: string;
    btnClass: string;
    inputSearchClass: string;
    listClass: string;
    clearIconClass: string;
    caretClass: string;
    searchHostClass: string;
    compareKey: string;
    valueKey: string;
    labelKey: string;
    label: string;
    searchPlaceholder: string;
    private _options;
    set options(value: DropdownOption[] | string[]);
    get options(): DropdownOption[] | string[];
    optionFormatter: (options: DropdownOption[] | string[], listType: any, value: any, compareKey: any, valueKey: any) => any;
    valueFormatter(selectedOption: DropdownOption, listType: ListType, valueKey: string): string | DropdownOption;
    private _val;
    set value(val: any);
    get value(): any;
    searchControl: FormControl;
    displayOptions: any[];
    disabled: boolean;
    selectedOption: DropdownOption;
    private listType;
    inputField: ElementRef;
    ngOnInit(): void;
    clearSearch(): void;
    onChange: (value: any) => void;
    onTouch: (value: any) => void;
    registerOnChange(fn: any): void;
    registerOnTouched(fn: any): void;
    setDisabledState(value: boolean): void;
    writeValue(value: any): void;
    toggleDropdown(): void;
    clearSearchData(): void;
    updateDisplayOptions(options: DropdownOption[], filterText?: string): void;
    setSelection(event: MouseEvent, option: DropdownOption): void;
    onBlur(): void;
}
