import { ElementRef, EventEmitter } from '@angular/core';
export declare enum FileInputErrors {
    invalidExtension = 0,
    invalidFileName = 1
}
export interface FileChangeEvent {
    file: File;
}
export declare class FileInputComponent {
    selectedFile: File;
    fileChange: EventEmitter<any>;
    error: EventEmitter<any>;
    id: string;
    fileNameRegex: any;
    extensions: string[];
    buttonLabel: string;
    label: string;
    containerClass: string;
    labelClass: string;
    fileNameClass: string;
    fieldClass: string;
    btnWrapperClass: string;
    btnClass: string;
    fileInput: ElementRef<HTMLInputElement>;
    constructor();
    onFileChange(event: Event): void;
    emitError(error: FileInputErrors): void;
    resetSelectedFile(): void;
}
