import { Component, Self, Optional, Input, ContentChild, ɵɵdefineInjectable, ɵɵinject, Injectable, Directive, ElementRef, Pipe, NgModule, ViewChild, EventEmitter, Output } from '@angular/core';
import { NgControl, FormsModule, ReactiveFormsModule, FormControl } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { HttpClient, HttpClientModule } from '@angular/common/http';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { asyncScheduler, asapScheduler } from 'rxjs';

class BaseFieldComponent {
    constructor(ngControl) {
        this.ngControl = ngControl;
        this._value = '';
        this.disabled = false;
        this.subscriptions = [];
        this.readonly = false;
        // Classes
        this.labelClass = 'control-label';
        this.containerClass = 'form-group';
        this.fieldClass = 'col-md-12 no-padder';
        this.inputClass = 'form-control';
        this.helpTextClass = 'helpText';
        this.readOnlyClass = 'read-form-control';
        this.errorClass = 'error';
        this.labelHelpClass = 'label-help';
        this.labelContainerClass = 'label-container';
        if (this.ngControl) {
            this.ngControl.valueAccessor = this;
        }
    }
    set value(value) {
        if (value) {
            this._value = value;
        }
    }
    ;
    get value() {
        return this._value;
    }
    writeValue(value) {
        this.value = value;
    }
    setDisabledState(isDisabled) {
        this.disabled = isDisabled;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnDestroy() {
        this.subscriptions.forEach(subscription => {
            subscription.unsubscribe();
        });
    }
}
BaseFieldComponent.decorators = [
    { type: Component, args: [{
                selector: 'lib-base-field',
                template: "<p>base-field works!</p>\n",
                styles: [""]
            },] }
];
BaseFieldComponent.ctorParameters = () => [
    { type: NgControl, decorators: [{ type: Self }, { type: Optional }] }
];
BaseFieldComponent.propDecorators = {
    value: [{ type: Input }],
    container: [{ type: Input }],
    id: [{ type: Input }],
    label: [{ type: Input }],
    description: [{ type: Input }],
    name: [{ type: Input }],
    translateValues: [{ type: Input }],
    readonly: [{ type: Input }],
    placeholder: [{ type: Input }],
    labelClass: [{ type: Input }],
    containerClass: [{ type: Input }],
    fieldClass: [{ type: Input }],
    inputClass: [{ type: Input }],
    helpTextClass: [{ type: Input }],
    descriptionClass: [{ type: Input }],
    readOnlyClass: [{ type: Input }],
    errorClass: [{ type: Input }],
    iconClass: [{ type: Input }],
    labelHelpClass: [{ type: Input }],
    labelContainerClass: [{ type: Input }],
    helpTextContent: [{ type: ContentChild, args: ['helpTextContent', { static: true },] }]
};

const get = (obj, path, defaultVal = undefined, isNullFalsy = false) => {
    const pathList = path === null || path === void 0 ? void 0 : path.toString().split('.').reverse();
    while (pathList.length && obj) {
        obj = obj[pathList.pop()];
    }
    return obj === undefined || (obj === null && isNullFalsy) ? defaultVal : obj;
};
/**
 * updates destination object in-place
 * @param dest Destination Object
 * @param source data to update
 * @returns destination object with updated data from source
 */
const merge = (dest = {}, source) => {
    for (const key in source) {
        if (key in dest) {
            if (typeof dest[key] === 'object' && typeof source[key] === 'object') {
                dest[key] = merge(dest[key], source[key]);
            }
            else {
                dest[key] = source[key];
            }
        }
        else {
            dest[key] = source[key];
        }
    }
    return dest;
};
/**
 * Checks whether value is defined
 * @param obj object to check
 * @returns boolean
 */
const isDefined = (obj) => {
    return obj !== undefined || obj !== null;
};

class CNSI18nService {
    constructor(http) {
        this.http = http;
        this.data = {};
        this.resolvedFileNames = [];
    }
    /**
     * Fetches All Locale File (except the ones that are already added) and update data
     * @param fileNames URLs of locale Files
     * @returns Promise that resolves after fetching the locale
     */
    addLocales(fileNames) {
        const parts = fileNames.filter(file => this.resolvedFileNames.indexOf(file) === -1);
        return Promise.all(parts.map(file => this.addLocale(file)));
    }
    /**
     * Fetches Locale File and update data
     * @param fileName URL for locale file
     * @returns Promise which is fulfilled after APi calls
     */
    addLocale(fileName) {
        return new Promise((resolve, reject) => {
            if (this.resolvedFileNames.indexOf(fileName) > -1) {
                resolve(this.data);
            }
            else {
                this.http.get(fileName).subscribe((response) => {
                    merge(this.data, response);
                    this.resolvedFileNames.push(fileName);
                    resolve(this.data);
                }, (error) => {
                    reject(error);
                });
            }
        });
    }
    /**
     * Update the locale data for translation.
     * @param data JSON object to update locale keys
     */
    addData(data) {
        this.data = merge(this.data, data);
    }
}
CNSI18nService.ɵprov = ɵɵdefineInjectable({ factory: function CNSI18nService_Factory() { return new CNSI18nService(ɵɵinject(HttpClient)); }, token: CNSI18nService, providedIn: "root" });
CNSI18nService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root'
            },] }
];
CNSI18nService.ctorParameters = () => [
    { type: HttpClient }
];

class CNSTranslateService {
    constructor(i18nService) {
        this.i18nService = i18nService;
    }
    translate(key) {
        return get(this.i18nService.data, key, key);
    }
    translateObj(key, localeObject) {
        if (localeObject) {
            return this.translate(key).replace(/{{(.*?)}}/g, (matchedSubstr) => {
                const replacementKey = matchedSubstr.substring(2, matchedSubstr.length - 2);
                return localeObject[replacementKey] !== undefined ? localeObject[replacementKey] : '';
            });
        }
        else {
            return this.translate(key);
        }
    }
}
CNSTranslateService.ɵprov = ɵɵdefineInjectable({ factory: function CNSTranslateService_Factory() { return new CNSTranslateService(ɵɵinject(CNSI18nService)); }, token: CNSTranslateService, providedIn: "root" });
CNSTranslateService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root'
            },] }
];
CNSTranslateService.ctorParameters = () => [
    { type: CNSI18nService }
];

class CNSTranslateDirective {
    constructor(translateService, el) {
        this.translateService = translateService;
        this.el = el;
    }
    ngOnChanges(changes) {
        this.updateHTML();
    }
    updateHTML() {
        if (this.translateKey) {
            this.el.nativeElement.innerHTML = this.translateService.translateObj(this.translateKey, this.translateValues);
        }
        else {
            this.el.nativeElement.innerHTML = this.translateService.translateObj(this.el.nativeElement.innerText, this.translateValues);
        }
    }
}
CNSTranslateDirective.decorators = [
    { type: Directive, args: [{
                selector: '[translate]'
            },] }
];
CNSTranslateDirective.ctorParameters = () => [
    { type: CNSTranslateService },
    { type: ElementRef }
];
CNSTranslateDirective.propDecorators = {
    translateKey: [{ type: Input, args: ['translate',] }],
    translateValues: [{ type: Input }]
};

class CNSDisplayValuePipe {
    transform(value, args) {
        let displayValue;
        if (args) {
            // value is object, should pass keys
            if (args.keys) {
                const keys = Array.isArray(args.keys) ? args.keys.join('.') : args.keys;
                displayValue = get(value, keys);
            }
            else {
                // No keys passed -- consider it as string/number
                displayValue = value;
            }
        }
        else {
            displayValue = value;
        }
        if (!isDefined(displayValue) && args && isDefined(args.default)) {
            displayValue = args.default;
        }
        else if (displayValue !== undefined && args && args.unit) {
            displayValue += ' ' + args.unit;
        }
        return displayValue;
    }
}
CNSDisplayValuePipe.decorators = [
    { type: Pipe, args: [{
                name: 'displayValue'
            },] }
];

class CNSRegexService {
    constructor() {
        this.regex = {};
    }
    addRegex(obj) {
        this.regex = merge(this.regex, obj);
    }
    addRegexObjects(key, obj) {
        this.regex[key] = obj;
    }
    getRegex(key) {
        return this.regex[key];
    }
    getAll() {
        return this.regex;
    }
}
CNSRegexService.ɵprov = ɵɵdefineInjectable({ factory: function CNSRegexService_Factory() { return new CNSRegexService(); }, token: CNSRegexService, providedIn: "root" });
CNSRegexService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root'
            },] }
];
CNSRegexService.ctorParameters = () => [];

class CNSFormControlErrorPipe {
    constructor(regexService) {
        this.regexService = regexService;
    }
    transform(errorObj, ...args) {
        const customErrors = args ? args[0] : {};
        if (errorObj) {
            const keys = Object.keys(errorObj);
            // If custom error: Error object should have a 'msg' property
            for (let i = 0; i < keys.length; i++) {
                if (errorObj[keys[i]].msg) {
                    return errorObj[keys[i]].msg;
                }
            }
            if ('pattern' in errorObj) {
                const regexConstants = this.regexService.getAll();
                const pattern = Object.keys(regexConstants).find(key => {
                    if (regexConstants[key].exp && regexConstants[key].exp.toString() === errorObj.pattern.requiredPattern) {
                        return regexConstants[key].msg;
                    }
                });
                return pattern ? regexConstants[pattern].msg : '';
            }
            if ('required' in errorObj) {
                return 'This field is required';
            }
            if ('maxlength' in errorObj) {
                return `Please enter no more than ${errorObj.maxlength.requiredLength} characters.`;
            }
            if ('minlength' in errorObj) {
                return `Please enter at least ${errorObj.minlength.requiredLength} characters.`;
            }
            if ('min' in errorObj) {
                return `Minimum value allowed is ${errorObj.min.min}`;
            }
            if ('max' in errorObj) {
                return `Maximum value allowed is ${errorObj.max.max}`;
            }
        }
        return null;
    }
}
CNSFormControlErrorPipe.decorators = [
    { type: Pipe, args: [{
                name: 'formControlError'
            },] }
];
CNSFormControlErrorPipe.ctorParameters = () => [
    { type: CNSRegexService }
];

class CNSTranslatePipe {
    constructor(translateService) {
        this.translateService = translateService;
    }
    transform(key, args) {
        return key ? this.translateService.translateObj(key, args) : '';
    }
}
CNSTranslatePipe.decorators = [
    { type: Pipe, args: [{
                name: 'translate'
            },] }
];
CNSTranslatePipe.ctorParameters = () => [
    { type: CNSTranslateService }
];

const AngularModules = [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    HttpClientModule
];
const ThirdPartyModules = [
    NgbModule
];
const Components = [];
const Pipes = [
    CNSTranslatePipe,
    CNSFormControlErrorPipe,
    CNSDisplayValuePipe
];
const Directives = [
    CNSTranslateDirective
];
class CnsUiLibSharedModule {
}
CnsUiLibSharedModule.decorators = [
    { type: NgModule, args: [{
                declarations: [
                    ...Components,
                    ...Directives,
                    ...Pipes
                ],
                imports: [
                    ...AngularModules,
                    ...ThirdPartyModules
                ],
                providers: [
                    ...Pipes
                ],
                exports: [
                    ...AngularModules,
                    ...ThirdPartyModules,
                    ...Components,
                    ...Pipes,
                    ...Directives
                ]
            },] }
];

class TextareaComponent {
    constructor(ngControl) {
        this.ngControl = ngControl;
        this.labelClass = '';
        this.captionClass = '';
        this.containerClass = 'col-md-12 form-group';
        this.rows = 10;
        this.errorClass = 'error';
        this.inputClass = 'form-control';
        if (!ngControl) {
            console.error('Invalid FormControl instance provided for cnsText');
        }
        else {
            this.ngControl.valueAccessor = this;
        }
    }
    set value(val) {
        if (val !== this.value) {
            this._value = val;
            if (this.onChange) {
                this.onChange(val);
            }
            if (this.onTouch) {
                this.onTouch(val);
            }
        }
    }
    get value() {
        return this._value;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouch = fn;
    }
    setDisabledState(value) {
        this.disabled = value;
    }
    writeValue(value) {
        this.value = value;
    }
}
TextareaComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-textarea',
                template: "<div [ngClass]=\"containerClass\">\n    <span *ngIf='label' [ngClass]='labelClass'>{{ label | translate}}</span>\n    <textarea [rows]=\"rows\"\n              [formControl]='ngControl.control'\n              [id]=\"id || name || ngControl.name\"\n              placeholder=\"{{placeholder | translate}}\"\n              [ngClass]='[((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"), inputClass]'></textarea>\n              <span *ngIf='caption' [ngClass]='captionClass'>{{ caption | translate}}</span>\n</div>",
                styles: [""]
            },] }
];
TextareaComponent.ctorParameters = () => [
    { type: NgControl, decorators: [{ type: Self }, { type: Optional }] }
];
TextareaComponent.propDecorators = {
    labelClass: [{ type: Input }],
    captionClass: [{ type: Input }],
    containerClass: [{ type: Input }],
    rows: [{ type: Input }],
    errorClass: [{ type: Input }],
    inputClass: [{ type: Input }],
    name: [{ type: Input }],
    id: [{ type: Input }],
    placeholder: [{ type: Input }],
    caption: [{ type: Input }],
    label: [{ type: Input }],
    value: [{ type: Input }]
};

class TextComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.autocomplete = 'off';
    }
    focus() {
        this.inputField.nativeElement.focus();
    }
}
TextComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-text',
                template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input #inputField [id]='id || name || ngControl.name'\n               [container]='container'\n               [autocomplete]='autocomplete'\n               [readonly]='readonly' type=\"text\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n               (readonly ? readOnlyClass: \"\"),\n                                   inputClass]'\n               (input)='onChange($event.target.value)'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <i class='inline-icon' [ngClass]='iconClass'></i>\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                exportAs: 'cnsText',
                styles: [".inline-icon{position:absolute;right:5px;top:6px}.label-container>span.label-help{float:right}"]
            },] }
];
TextComponent.propDecorators = {
    autocomplete: [{ type: Input }],
    inputField: [{ type: ViewChild, args: ['inputField', { static: true },] }]
};

class SelectComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.searchEnabled = false;
        this.divClass = 'btn-group w-100';
        this.btnClass = 'btn btn-plain btn-select dropdown-toggle textEllipse error';
        this.inputSearchClass = 'form-control';
        this.listClass = 'dropdown-menu h-down';
        this.clearIconClass = 'bi bi-x cursor-pointer';
        this.caretClass = 'caret';
        this.searchHostClass = 'search-host wrapper-xs';
        this.compareKey = 'name'; // field to use for comparison from search field.
        this.labelKey = 'name';
        this.searchPlaceholder = 'common.select.search';
        // tslint:disable-next-line: variable-name
        this._options = [];
        // value can be object or key in case of object list. Or a exact match in case of string list.
        this.optionFormatter = (options, listType, value, compareKey, valueKey) => {
            const obj = null;
            if (value) {
                if (listType === "object" /* object */) {
                    if (typeof value === 'string') {
                        const key = valueKey || compareKey;
                        return (options || []).find(opt => opt[key] === value);
                    }
                    else if (typeof value === 'object') {
                        return value;
                    }
                }
                else {
                    if (typeof value === 'object') {
                        return value;
                    }
                    else {
                        const key = valueKey || compareKey;
                        return (options || []).find(opt => opt[key] === value);
                    }
                }
            }
            return obj;
        };
        this.displayOptions = [];
        this.disabled = false;
        // validate(control: AbstractControl) {
        //   return null;
        // }
    }
    set options(value) {
        asyncScheduler.schedule(() => {
            if (value && Array.isArray(value)) {
                if (typeof value[0] === 'object') {
                    this.listType = "object" /* object */;
                    this._options = value;
                }
                else {
                    this.listType = "string" /* string */;
                    this._options = value.map(val => {
                        return { value: val, label: val };
                    });
                }
                this.updateDisplayOptions(this._options);
                if (this.value) {
                    // tslint:disable-next-line: max-line-length
                    this.selectedOption = this.selectedOption = this.optionFormatter(this.options, this.listType, this.value, this.compareKey, this.valueKey);
                }
            }
        }, 0);
    }
    ;
    get options() {
        return this._options;
    }
    valueFormatter(selectedOption, listType, valueKey) {
        return selectedOption ?
            listType === "string" /* string */ ? selectedOption.value :
                (valueKey && typeof selectedOption === 'object') ? selectedOption[valueKey] : selectedOption : null;
    }
    set value(val) {
        if (this.onChange) {
            this.onChange(val);
        }
        if (this.onTouch) {
            this.onTouch(val);
        }
        this._val = val;
    }
    get value() {
        return this._val;
    }
    ngOnInit() {
        if (this.searchEnabled) {
            this.searchControl = new FormControl('');
            this.searchControl.valueChanges.subscribe((value) => {
                this.updateDisplayOptions(this.options, value);
            });
        }
    }
    clearSearch() {
        this.searchControl.patchValue('');
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouch = fn;
    }
    setDisabledState(value) {
        this.disabled = value;
    }
    writeValue(value) {
        this.selectedOption = this.optionFormatter(this.options, this.listType, value, this.compareKey, this.valueKey);
        this.value = this.valueFormatter(this.selectedOption || value, this.listType, this.valueKey);
    }
    toggleDropdown() {
        if (this.searchEnabled) {
            this.clearSearchData();
        }
    }
    clearSearchData() {
        if (this.searchEnabled) {
            this.searchControl.patchValue('');
            if (this.inputField) {
                const scheduledFocus = asapScheduler.schedule(() => {
                    this.inputField.nativeElement.focus();
                    scheduledFocus.unsubscribe();
                });
            }
        }
    }
    updateDisplayOptions(options, filterText = '') {
        this.displayOptions = options.filter(opt => opt[this.compareKey].toLowerCase().indexOf(filterText.toLowerCase()) >= 0);
    }
    setSelection(event, option) {
        event.stopPropagation();
        this.writeValue(option);
    }
    onBlur() {
        this.ngControl.control.markAsTouched();
    }
}
SelectComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-select',
                template: "<div [ngClass]='containerClass'>\n  <label [ngClass]='labelClass'>\n    <span *ngIf='label'>{{ label | translate}}</span>\n  </label>\n  <div ngbDropdown [container]='container' [ngClass]='divClass' (openChange)=\"toggleDropdown()\">\n    <button [ngbTooltip]='ngControl.control?.errors | formControlError | translate' ngbDropdownToggle type='button'\n            [ngClass]='[((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n            (readonly ? readOnlyClass: \"\"), btnClass]' [disabled]='disabled' (blur)='onBlur()'>\n      {{ selectedOption | displayValue: {keys: labelKey} | translate}}\n      <span [ngClass]=\"caretClass\"></span>\n    </button>\n    <ul ngbDropdownMenu [ngClass]='listClass'>\n      <li *ngIf='searchEnabled' [ngClass]='searchHostClass'>\n        <input autocomplete=\"off\" #searchInput type=\"text\" [ngClass]=\"inputSearchClass\" [formControl]='searchControl' placeholder=\"{{searchPlaceholder | translate}}\" autofocus />\n        <i *ngIf=\"searchInput.value\" [ngClass]='clearIconClass' (click)=\"clearSearchData()\"></i>\n      </li>\n      <li *ngFor=\"let option of displayOptions\" [class.selected]='selectedOption && option[compareKey] === selectedOption[compareKey]'>\n        <a ngbDropdownItem (click)=\"setSelection($event,option)\">{{option | displayValue: {keys: labelKey} | translate}}</a>\n      </li>\n    </ul>\n  </div>\n</div>",
                exportAs: 'cnsSelect',
                styles: [""]
            },] }
];
SelectComponent.propDecorators = {
    searchEnabled: [{ type: Input }],
    divClass: [{ type: Input }],
    btnClass: [{ type: Input }],
    inputSearchClass: [{ type: Input }],
    listClass: [{ type: Input }],
    clearIconClass: [{ type: Input }],
    caretClass: [{ type: Input }],
    searchHostClass: [{ type: Input }],
    compareKey: [{ type: Input }],
    valueKey: [{ type: Input }],
    labelKey: [{ type: Input }],
    label: [{ type: Input }],
    searchPlaceholder: [{ type: Input }],
    options: [{ type: Input }],
    optionFormatter: [{ type: Input }],
    valueFormatter: [{ type: Input }],
    inputField: [{ type: ViewChild, args: ['searchInput', { static: false, read: ElementRef },] }]
};

class CheckboxComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.checked = false;
        this.containerClass = 'form-group checkbox';
        this.fieldClass = 'i-checks i-checks-sm';
        this.labelClass = '';
        this.ngTrueValue = true;
        this.ngFalseValue = false;
    }
    emitChange(event) {
        const value = event.currentTarget.checked ? this.ngTrueValue : this.ngFalseValue;
        this.onChange(value);
        this.writeValue(value);
    }
    writeValue(value) {
        this.subscriptions.push(asyncScheduler.schedule(() => {
            this.checked = (value === this.ngTrueValue);
            this.value = this.checked ? this.ngTrueValue : this.ngFalseValue;
        }));
    }
}
CheckboxComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-checkbox',
                template: "<div [ngClass]=\"containerClass\">\n  <label [ngClass]='fieldClass'>\n    <input [id]=\"id || name || ngControl.name\" type=\"checkbox\" [checked]='checked' (change)='emitChange($event)' [disabled]='disabled'/><i></i>\n    <span>\n      <span>\n        <span [ngClass]='labelClass'>{{ label | translate}}</span>\n        <ng-content select='[container=middle]'></ng-content>\n        <span class=\"helpText\">{{ description | translate}}</span>\n      </span>\n      <ng-content></ng-content>\n    </span>\n  </label>\n</div>",
                exportAs: 'cnsCheckbox',
                styles: [""]
            },] }
];
CheckboxComponent.propDecorators = {
    containerClass: [{ type: Input }],
    fieldClass: [{ type: Input }],
    labelClass: [{ type: Input }],
    ngTrueValue: [{ type: Input }],
    ngFalseValue: [{ type: Input }]
};

class RadioGroupComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.labelClass = 'col-md-12 no-padder';
        this.fieldLabelClass = 'i-checks i-checks-sm';
        this.fieldClass = 'radio inline';
    }
}
RadioGroupComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-radio-group',
                template: "<div [ngClass]='containerClass'>\n    <label [ngClass]='labelClass' *ngIf='label'>{{ label | translate}}</label>\n    <ng-container *ngFor='let option of options'>\n        <div [ngClass]='fieldClass'>\n            <label [ngClass]=\"fieldLabelClass\">\n                <input [name]='name || id || ngControl.name' type=\"radio\" [value]='option?.value' [formControl]='ngControl.control'>\n                <i></i>\n                <span>{{ option?.label | translate }}</span>\n            </label>\n        </div>\n    </ng-container>\n    <span [class]='helpTextClass'>{{description | translate}}</span>\n</div>",
                exportAs: 'cnsRadioGroup',
                styles: [""]
            },] }
];
RadioGroupComponent.propDecorators = {
    options: [{ type: Input }],
    labelClass: [{ type: Input }],
    fieldLabelClass: [{ type: Input }],
    fieldClass: [{ type: Input }]
};

class PasswordComponent extends BaseFieldComponent {
    focus() {
        this.inputField.nativeElement.focus();
    }
}
PasswordComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-password',
                template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input #inputField [id]='id || name || ngControl.name'\n               [container]='container'\n               type=\"password\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n                                   inputClass]'\n               (input)='onChange($event.target.value)'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                styles: [".label-container>span.label-help{float:right}"]
            },] }
];
PasswordComponent.propDecorators = {
    inputField: [{ type: ViewChild, args: ['inputField', { static: true },] }]
};

class InputPasswordComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.helpTextClass = 'helpText m-t-xs';
        this.inputClass = 'form-control p-r-50';
        this.hideClass = 'h-phrase';
        this.showClass = 's-phrase';
        this.hideIconClass = 'bi bi-eye-slash-fill';
        this.showIconClass = 'bi bi-eye-fill';
        this.showText = true;
        this.inlineButtonBgClass = 'pos-abt t-phrase text-center r';
        this.hideCharactersLabel = 'common.hide';
        this.showCharactersLabel = 'common.show';
        this.hideCharactersTitle = 'common.hideChars';
        this.showCharactersTitle = 'common.showChars';
    }
    toggle(input) {
        input.type = input.type === "password" ? "text" : "password";
    }
}
InputPasswordComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-input-password',
                template: "<div [ngClass]=\"containerClass\">\n  <label [ngClass]=\"labelClass\" *ngIf='label'>\n    <span> {{ label | translate:translateValues }}</span>\n  </label>\n  <ng-content></ng-content>\n  <div [ngClass]=\"fieldClass\">\n    <input #input type=\"password\" [formControl]=\"ngControl.control\"\n           [container]='container'\n           [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n           [class.error]='ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)'\n           [ngClass]=\"inputClass\" (input)='onChange($event.target.value)' [name]=\"name\">\n    <i *ngIf='!showText' class='inline-icon' [ngClass]=\"input.type === 'text' ? hideIconClass : showIconClass\" (click)='toggle(input)'></i>\n    <span *ngIf='showText' [ngClass]=\"inlineButtonBgClass\" title=\"{{(input.type === 'text' ? hideCharactersTitle : showCharactersTitle) | translate}}\"\n          (click)='toggle(input)'\n          [ngClass]=\"input.type === 'text' ? hideClass : showClass\">\n      {{(input.type === 'text' ? hideCharactersLabel : showCharactersLabel) | translate}}\n    </span>\n  </div>\n  <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n    <ng-content select='[helpTextContent]'></ng-content>\n    <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n  </div>\n</div>",
                styles: [".inline-icon{cursor:pointer;position:absolute;right:15px;top:6px}"]
            },] }
];
InputPasswordComponent.propDecorators = {
    helpTextClass: [{ type: Input }],
    inputClass: [{ type: Input }],
    hideClass: [{ type: Input }],
    showClass: [{ type: Input }],
    hideIconClass: [{ type: Input }],
    showIconClass: [{ type: Input }],
    showText: [{ type: Input }],
    inlineButtonBgClass: [{ type: Input }],
    hideCharactersLabel: [{ type: Input }],
    showCharactersLabel: [{ type: Input }],
    hideCharactersTitle: [{ type: Input }],
    showCharactersTitle: [{ type: Input }]
};

class NumberComponent extends BaseFieldComponent {
}
NumberComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-number',
                template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input [id]='id || name || ngControl.name'\n               [container]='container'\n               type=\"number\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n                                   inputClass]'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                styles: [".label-container>span.label-help{float:right}"]
            },] }
];

var FileInputErrors;
(function (FileInputErrors) {
    FileInputErrors[FileInputErrors["invalidExtension"] = 0] = "invalidExtension";
    FileInputErrors[FileInputErrors["invalidFileName"] = 1] = "invalidFileName";
})(FileInputErrors || (FileInputErrors = {}));
class FileInputComponent {
    constructor() {
        this.id = 'fileInputField';
        this.extensions = [];
        this.buttonLabel = 'common.SelectFile';
        this.label = 'common.File';
        this.containerClass = 'input-group';
        this.labelClass = 'control-label';
        this.fileNameClass = 'form-control';
        this.fieldClass = 'col-md-12 p-0';
        this.btnWrapperClass = 'input-group-append';
        this.btnClass = 'input-group-text';
        this.error = new EventEmitter();
        this.fileChange = new EventEmitter();
    }
    onFileChange(event) {
        const files = event.target.files;
        if (files && files.length) {
            this.selectedFile = files[0];
            const parts = this.selectedFile.name.split('.');
            const fileExtension = parts[parts.length - 1];
            if (this.extensions.length && this.extensions.indexOf(fileExtension) === -1) {
                this.emitError(FileInputErrors.invalidExtension);
            }
            else if (this.fileNameRegex && !this.fileNameRegex.test(this.selectedFile.name)) {
                this.emitError(FileInputErrors.invalidFileName);
            }
            else {
                this.fileChange.emit({
                    file: this.selectedFile
                });
            }
        }
        else {
            this.resetSelectedFile();
        }
    }
    emitError(error) {
        this.error.emit(error);
        this.resetSelectedFile();
    }
    resetSelectedFile() {
        this.selectedFile = undefined;
        this.fileInput.nativeElement.value = '';
    }
}
FileInputComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-file-input',
                template: "<div [ngClass]='containerClass'>\n    <label [ngClass]='labelClass'>{{ label | translate }}</label>\n    <div [ngClass]='fieldClass'>\n        <label [ngClass]=\"fileNameClass\" for=\"fileText\">{{selectedFile?.name}}</label>\n        <span [ngClass]=\"btnWrapperClass\" (click)='fileInput.click()'>\n            <span [ngClass]='btnClass'>{{buttonLabel | translate}}</span>\n            <input [id]='id' #fileInput type=\"file\" name=\"fileUpload\" [ngStyle]='{display:\"none\"}' (change)='onFileChange($event)' />\n        </span>\n    </div>\n</div>"
            },] }
];
FileInputComponent.ctorParameters = () => [];
FileInputComponent.propDecorators = {
    fileChange: [{ type: Output }],
    error: [{ type: Output }],
    id: [{ type: Input }],
    fileNameRegex: [{ type: Input }],
    extensions: [{ type: Input }],
    buttonLabel: [{ type: Input }],
    label: [{ type: Input }],
    containerClass: [{ type: Input }],
    labelClass: [{ type: Input }],
    fileNameClass: [{ type: Input }],
    fieldClass: [{ type: Input }],
    btnWrapperClass: [{ type: Input }],
    btnClass: [{ type: Input }],
    fileInput: [{ type: ViewChild, args: ['fileInput', { static: true },] }]
};

const Components$1 = [
    TextareaComponent,
    TextComponent,
    SelectComponent,
    CheckboxComponent,
    RadioGroupComponent,
    PasswordComponent,
    InputPasswordComponent,
    NumberComponent,
    FileInputComponent,
    BaseFieldComponent
];
class CnsFormFieldsModule {
}
CnsFormFieldsModule.decorators = [
    { type: NgModule, args: [{
                declarations: [
                    ...Components$1,
                ],
                imports: [
                    CnsUiLibSharedModule
                ],
                exports: [
                    CnsUiLibSharedModule,
                    ...Components$1
                ]
            },] }
];

const Modules = [
    CnsUiLibSharedModule,
    CnsFormFieldsModule
];
class CnsUiLibModule {
}
CnsUiLibModule.decorators = [
    { type: NgModule, args: [{
                imports: [
                    ...Modules
                ],
                exports: [
                    ...Modules
                ],
                declarations: []
            },] }
];

/**
 * Generated bundle index. Do not edit.
 */

export { BaseFieldComponent, CNSDisplayValuePipe, CNSFormControlErrorPipe, CNSI18nService, CNSRegexService, CNSTranslateDirective, CNSTranslatePipe, CNSTranslateService, CheckboxComponent, CnsFormFieldsModule, CnsUiLibModule, CnsUiLibSharedModule, FileInputComponent, FileInputErrors, InputPasswordComponent, NumberComponent, PasswordComponent, RadioGroupComponent, SelectComponent, TextComponent, TextareaComponent };
//# sourceMappingURL=cambium-cns-ui-lib.js.map
