export const get = (obj, path, defaultVal = undefined, isNullFalsy = false) => {
    const pathList = path === null || path === void 0 ? void 0 : path.toString().split('.').reverse();
    while (pathList.length && obj) {
        obj = obj[pathList.pop()];
    }
    return obj === undefined || (obj === null && isNullFalsy) ? defaultVal : obj;
};
/**
 * updates destination object in-place
 * @param dest Destination Object
 * @param source data to update
 * @returns destination object with updated data from source
 */
export const merge = (dest = {}, source) => {
    for (const key in source) {
        if (key in dest) {
            if (typeof dest[key] === 'object' && typeof source[key] === 'object') {
                dest[key] = merge(dest[key], source[key]);
            }
            else {
                dest[key] = source[key];
            }
        }
        else {
            dest[key] = source[key];
        }
    }
    return dest;
};
/**
 * Checks whether value is defined
 * @param obj object to check
 * @returns boolean
 */
export const isDefined = (obj) => {
    return obj !== undefined || obj !== null;
};
//# sourceMappingURL=data:application/json;base64,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