import { Injectable } from '@angular/core';
import * as CommonUtils from '../../utilities/common';
import { CNSI18nService } from './i18n.service';
import * as i0 from "@angular/core";
import * as i1 from "./i18n.service";
export class CNSTranslateService {
    constructor(i18nService) {
        this.i18nService = i18nService;
    }
    translate(key) {
        return CommonUtils.get(this.i18nService.data, key, key);
    }
    translateObj(key, localeObject) {
        if (localeObject) {
            return this.translate(key).replace(/{{(.*?)}}/g, (matchedSubstr) => {
                const replacementKey = matchedSubstr.substring(2, matchedSubstr.length - 2);
                return localeObject[replacementKey] !== undefined ? localeObject[replacementKey] : '';
            });
        }
        else {
            return this.translate(key);
        }
    }
}
CNSTranslateService.ɵprov = i0.ɵɵdefineInjectable({ factory: function CNSTranslateService_Factory() { return new CNSTranslateService(i0.ɵɵinject(i1.CNSI18nService)); }, token: CNSTranslateService, providedIn: "root" });
CNSTranslateService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root'
            },] }
];
CNSTranslateService.ctorParameters = () => [
    { type: CNSI18nService }
];
//# sourceMappingURL=data:application/json;base64,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