import { HttpClient } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { merge } from '../../utilities/common';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
export class CNSI18nService {
    constructor(http) {
        this.http = http;
        this.data = {};
        this.resolvedFileNames = [];
    }
    /**
     * Fetches All Locale File (except the ones that are already added) and update data
     * @param fileNames URLs of locale Files
     * @returns Promise that resolves after fetching the locale
     */
    addLocales(fileNames) {
        const parts = fileNames.filter(file => this.resolvedFileNames.indexOf(file) === -1);
        return Promise.all(parts.map(file => this.addLocale(file)));
    }
    /**
     * Fetches Locale File and update data
     * @param fileName URL for locale file
     * @returns Promise which is fulfilled after APi calls
     */
    addLocale(fileName) {
        return new Promise((resolve, reject) => {
            if (this.resolvedFileNames.indexOf(fileName) > -1) {
                resolve(this.data);
            }
            else {
                this.http.get(fileName).subscribe((response) => {
                    merge(this.data, response);
                    this.resolvedFileNames.push(fileName);
                    resolve(this.data);
                }, (error) => {
                    reject(error);
                });
            }
        });
    }
    /**
     * Update the locale data for translation.
     * @param data JSON object to update locale keys
     */
    addData(data) {
        this.data = merge(this.data, data);
    }
}
CNSI18nService.ɵprov = i0.ɵɵdefineInjectable({ factory: function CNSI18nService_Factory() { return new CNSI18nService(i0.ɵɵinject(i1.HttpClient)); }, token: CNSI18nService, providedIn: "root" });
CNSI18nService.decorators = [
    { type: Injectable, args: [{
                providedIn: 'root'
            },] }
];
CNSI18nService.ctorParameters = () => [
    { type: HttpClient }
];
//# sourceMappingURL=data:application/json;base64,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