import { Pipe } from '@angular/core';
import { CNSRegexService } from '../services/regex.service';
export class CNSFormControlErrorPipe {
    constructor(regexService) {
        this.regexService = regexService;
    }
    transform(errorObj, ...args) {
        const customErrors = args ? args[0] : {};
        if (errorObj) {
            const keys = Object.keys(errorObj);
            // If custom error: Error object should have a 'msg' property
            for (let i = 0; i < keys.length; i++) {
                if (errorObj[keys[i]].msg) {
                    return errorObj[keys[i]].msg;
                }
            }
            if ('pattern' in errorObj) {
                const regexConstants = this.regexService.getAll();
                const pattern = Object.keys(regexConstants).find(key => {
                    if (regexConstants[key].exp && regexConstants[key].exp.toString() === errorObj.pattern.requiredPattern) {
                        return regexConstants[key].msg;
                    }
                });
                return pattern ? regexConstants[pattern].msg : '';
            }
            if ('required' in errorObj) {
                return 'This field is required';
            }
            if ('maxlength' in errorObj) {
                return `Please enter no more than ${errorObj.maxlength.requiredLength} characters.`;
            }
            if ('minlength' in errorObj) {
                return `Please enter at least ${errorObj.minlength.requiredLength} characters.`;
            }
            if ('min' in errorObj) {
                return `Minimum value allowed is ${errorObj.min.min}`;
            }
            if ('max' in errorObj) {
                return `Maximum value allowed is ${errorObj.max.max}`;
            }
        }
        return null;
    }
}
CNSFormControlErrorPipe.decorators = [
    { type: Pipe, args: [{
                name: 'formControlError'
            },] }
];
CNSFormControlErrorPipe.ctorParameters = () => [
    { type: CNSRegexService }
];
//# sourceMappingURL=data:application/json;base64,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