import { Pipe } from '@angular/core';
import { get, isDefined } from '../../utilities/common';
export class CNSDisplayValuePipe {
    transform(value, args) {
        let displayValue;
        if (args) {
            // value is object, should pass keys
            if (args.keys) {
                const keys = Array.isArray(args.keys) ? args.keys.join('.') : args.keys;
                displayValue = get(value, keys);
            }
            else {
                // No keys passed -- consider it as string/number
                displayValue = value;
            }
        }
        else {
            displayValue = value;
        }
        if (!isDefined(displayValue) && args && isDefined(args.default)) {
            displayValue = args.default;
        }
        else if (displayValue !== undefined && args && args.unit) {
            displayValue += ' ' + args.unit;
        }
        return displayValue;
    }
}
CNSDisplayValuePipe.decorators = [
    { type: Pipe, args: [{
                name: 'displayValue'
            },] }
];
//# sourceMappingURL=data:application/json;base64,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