import { Directive, ElementRef, Input } from '@angular/core';
import { CNSTranslateService } from '../services/translate.service';
export class CNSTranslateDirective {
    constructor(translateService, el) {
        this.translateService = translateService;
        this.el = el;
    }
    ngOnChanges(changes) {
        this.updateHTML();
    }
    updateHTML() {
        if (this.translateKey) {
            this.el.nativeElement.innerHTML = this.translateService.translateObj(this.translateKey, this.translateValues);
        }
        else {
            this.el.nativeElement.innerHTML = this.translateService.translateObj(this.el.nativeElement.innerText, this.translateValues);
        }
    }
}
CNSTranslateDirective.decorators = [
    { type: Directive, args: [{
                selector: '[translate]'
            },] }
];
CNSTranslateDirective.ctorParameters = () => [
    { type: CNSTranslateService },
    { type: ElementRef }
];
CNSTranslateDirective.propDecorators = {
    translateKey: [{ type: Input, args: ['translate',] }],
    translateValues: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,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