import { CommonModule } from '@angular/common';
import { HttpClientModule } from '@angular/common/http';
import { NgModule } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { CNSTranslateDirective } from './directives/translate.directive';
import { CNSDisplayValuePipe } from './pipes/display-value.pipe';
import { CNSFormControlErrorPipe } from './pipes/form-control-error.pipe';
import { CNSTranslatePipe } from './pipes/translate.pipe';
const AngularModules = [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    HttpClientModule
];
const ThirdPartyModules = [
    NgbModule
];
const Components = [];
const Pipes = [
    CNSTranslatePipe,
    CNSFormControlErrorPipe,
    CNSDisplayValuePipe
];
const Directives = [
    CNSTranslateDirective
];
export class CnsUiLibSharedModule {
}
CnsUiLibSharedModule.decorators = [
    { type: NgModule, args: [{
                declarations: [
                    ...Components,
                    ...Directives,
                    ...Pipes
                ],
                imports: [
                    ...AngularModules,
                    ...ThirdPartyModules
                ],
                providers: [
                    ...Pipes
                ],
                exports: [
                    ...AngularModules,
                    ...ThirdPartyModules,
                    ...Components,
                    ...Pipes,
                    ...Directives
                ]
            },] }
];
//# sourceMappingURL=data:application/json;base64,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