import { NgModule } from '@angular/core';
import { CnsUiLibSharedModule } from '../shared/cns-ui-lib-shared.module';
import { TextareaComponent } from './components/textarea/textarea.component';
import { TextComponent } from './components/text/text.component';
import { SelectComponent } from './components/select/select.component';
import { CheckboxComponent } from './components/checkbox/checkbox.component';
import { RadioGroupComponent } from './components/radio-group/radio-group.component';
import { PasswordComponent } from './components/password/password.component';
import { InputPasswordComponent } from './components/input-password/input-password.component';
import { BaseFieldComponent } from './components/base-field/base-field.component';
import { NumberComponent } from './components/number/number.component';
import { FileInputComponent } from './components/file-input/file-input.component';
const Components = [
    TextareaComponent,
    TextComponent,
    SelectComponent,
    CheckboxComponent,
    RadioGroupComponent,
    PasswordComponent,
    InputPasswordComponent,
    NumberComponent,
    FileInputComponent,
    BaseFieldComponent
];
export class CnsFormFieldsModule {
}
CnsFormFieldsModule.decorators = [
    { type: NgModule, args: [{
                declarations: [
                    ...Components,
                ],
                imports: [
                    CnsUiLibSharedModule
                ],
                exports: [
                    CnsUiLibSharedModule,
                    ...Components
                ]
            },] }
];
//# sourceMappingURL=data:application/json;base64,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