import { Component, Input, Optional, Self } from '@angular/core';
import { NgControl } from '@angular/forms';
export class TextareaComponent {
    constructor(ngControl) {
        this.ngControl = ngControl;
        this.labelClass = '';
        this.captionClass = '';
        this.containerClass = 'col-md-12 form-group';
        this.rows = 10;
        this.errorClass = 'error';
        this.inputClass = 'form-control';
        if (!ngControl) {
            console.error('Invalid FormControl instance provided for cnsText');
        }
        else {
            this.ngControl.valueAccessor = this;
        }
    }
    set value(val) {
        if (val !== this.value) {
            this._value = val;
            if (this.onChange) {
                this.onChange(val);
            }
            if (this.onTouch) {
                this.onTouch(val);
            }
        }
    }
    get value() {
        return this._value;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouch = fn;
    }
    setDisabledState(value) {
        this.disabled = value;
    }
    writeValue(value) {
        this.value = value;
    }
}
TextareaComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-textarea',
                template: "<div [ngClass]=\"containerClass\">\n    <span *ngIf='label' [ngClass]='labelClass'>{{ label | translate}}</span>\n    <textarea [rows]=\"rows\"\n              [formControl]='ngControl.control'\n              [id]=\"id || name || ngControl.name\"\n              placeholder=\"{{placeholder | translate}}\"\n              [ngClass]='[((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"), inputClass]'></textarea>\n              <span *ngIf='caption' [ngClass]='captionClass'>{{ caption | translate}}</span>\n</div>",
                styles: [""]
            },] }
];
TextareaComponent.ctorParameters = () => [
    { type: NgControl, decorators: [{ type: Self }, { type: Optional }] }
];
TextareaComponent.propDecorators = {
    labelClass: [{ type: Input }],
    captionClass: [{ type: Input }],
    containerClass: [{ type: Input }],
    rows: [{ type: Input }],
    errorClass: [{ type: Input }],
    inputClass: [{ type: Input }],
    name: [{ type: Input }],
    id: [{ type: Input }],
    placeholder: [{ type: Input }],
    caption: [{ type: Input }],
    label: [{ type: Input }],
    value: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,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