import { Component, Input, ViewChild } from '@angular/core';
import { BaseFieldComponent } from '../base-field/base-field.component';
export class TextComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.autocomplete = 'off';
    }
    focus() {
        this.inputField.nativeElement.focus();
    }
}
TextComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-text',
                template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input #inputField [id]='id || name || ngControl.name'\n               [container]='container'\n               [autocomplete]='autocomplete'\n               [readonly]='readonly' type=\"text\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n               (readonly ? readOnlyClass: \"\"),\n                                   inputClass]'\n               (input)='onChange($event.target.value)'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <i class='inline-icon' [ngClass]='iconClass'></i>\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                exportAs: 'cnsText',
                styles: [".inline-icon{position:absolute;right:5px;top:6px}.label-container>span.label-help{float:right}"]
            },] }
];
TextComponent.propDecorators = {
    autocomplete: [{ type: Input }],
    inputField: [{ type: ViewChild, args: ['inputField', { static: true },] }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGV4dC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvamVua2lucy93b3Jrc3BhY2UvQXV0b19jbk1hZXN0cm9fQW5ndWxhcl9OUE1fUmVsZWFzZV9CdWlsZC9ucG0vY25zLXVpLWxpYi9wcm9qZWN0cy9jYW1iaXVtL2Nucy11aS1saWIvc3JjLyIsInNvdXJjZXMiOlsiZm9ybS1maWVsZHMvY29tcG9uZW50cy90ZXh0L3RleHQuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQTBDLEtBQUssRUFBMEIsU0FBUyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBRTVILE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxNQUFNLG9DQUFvQyxDQUFDO0FBUXhFLE1BQU0sT0FBTyxhQUFjLFNBQVEsa0JBQWtCO0lBTnJEOztRQU9XLGlCQUFZLEdBQUcsS0FBSyxDQUFDO0lBT2hDLENBQUM7SUFIQyxLQUFLO1FBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsS0FBSyxFQUFFLENBQUM7SUFDeEMsQ0FBQzs7O1lBYkYsU0FBUyxTQUFDO2dCQUNULFFBQVEsRUFBRSxVQUFVO2dCQUNwQiwrOENBQW9DO2dCQUVwQyxRQUFRLEVBQUUsU0FBUzs7YUFDcEI7OzsyQkFFRSxLQUFLO3lCQUVMLFNBQVMsU0FBQyxZQUFZLEVBQUUsRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBDb250ZW50Q2hpbGQsIEVsZW1lbnRSZWYsIEV2ZW50RW1pdHRlciwgSW5wdXQsIE9wdGlvbmFsLCBPdXRwdXQsIFNlbGYsIFZpZXdDaGlsZCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQ29udHJvbFZhbHVlQWNjZXNzb3IsIE5nQ29udHJvbCB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcbmltcG9ydCB7IEJhc2VGaWVsZENvbXBvbmVudCB9IGZyb20gJy4uL2Jhc2UtZmllbGQvYmFzZS1maWVsZC5jb21wb25lbnQnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdjbnMtdGV4dCcsXG4gIHRlbXBsYXRlVXJsOiAnLi90ZXh0LmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vdGV4dC5jb21wb25lbnQuY3NzJ10sXG4gIGV4cG9ydEFzOiAnY25zVGV4dCdcbn0pXG5leHBvcnQgY2xhc3MgVGV4dENvbXBvbmVudCBleHRlbmRzIEJhc2VGaWVsZENvbXBvbmVudCB7XG4gIEBJbnB1dCgpIGF1dG9jb21wbGV0ZSA9ICdvZmYnO1xuXG4gIEBWaWV3Q2hpbGQoJ2lucHV0RmllbGQnLCB7IHN0YXRpYzogdHJ1ZSB9KSBpbnB1dEZpZWxkOiBFbGVtZW50UmVmO1xuXG4gIGZvY3VzKCkge1xuICAgIHRoaXMuaW5wdXRGaWVsZC5uYXRpdmVFbGVtZW50LmZvY3VzKCk7XG4gIH1cbn1cbiJdfQ==