import { Component, ElementRef, Input, ViewChild } from '@angular/core';
import { FormControl } from '@angular/forms';
import { asapScheduler, asyncScheduler } from 'rxjs';
import { BaseFieldComponent } from '../base-field/base-field.component';
export class SelectComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.searchEnabled = false;
        this.divClass = 'btn-group w-100';
        this.btnClass = 'btn btn-plain btn-select dropdown-toggle textEllipse error';
        this.inputSearchClass = 'form-control';
        this.listClass = 'dropdown-menu h-down';
        this.clearIconClass = 'bi bi-x cursor-pointer';
        this.caretClass = 'caret';
        this.searchHostClass = 'search-host wrapper-xs';
        this.compareKey = 'name'; // field to use for comparison from search field.
        this.labelKey = 'name';
        this.searchPlaceholder = 'common.select.search';
        // tslint:disable-next-line: variable-name
        this._options = [];
        // value can be object or key in case of object list. Or a exact match in case of string list.
        this.optionFormatter = (options, listType, value, compareKey, valueKey) => {
            const obj = null;
            if (value) {
                if (listType === "object" /* object */) {
                    if (typeof value === 'string') {
                        const key = valueKey || compareKey;
                        return (options || []).find(opt => opt[key] === value);
                    }
                    else if (typeof value === 'object') {
                        return value;
                    }
                }
                else {
                    if (typeof value === 'object') {
                        return value;
                    }
                    else {
                        const key = valueKey || compareKey;
                        return (options || []).find(opt => opt[key] === value);
                    }
                }
            }
            return obj;
        };
        this.displayOptions = [];
        this.disabled = false;
        // validate(control: AbstractControl) {
        //   return null;
        // }
    }
    set options(value) {
        asyncScheduler.schedule(() => {
            if (value && Array.isArray(value)) {
                if (typeof value[0] === 'object') {
                    this.listType = "object" /* object */;
                    this._options = value;
                }
                else {
                    this.listType = "string" /* string */;
                    this._options = value.map(val => {
                        return { value: val, label: val };
                    });
                }
                this.updateDisplayOptions(this._options);
                if (this.value) {
                    // tslint:disable-next-line: max-line-length
                    this.selectedOption = this.selectedOption = this.optionFormatter(this.options, this.listType, this.value, this.compareKey, this.valueKey);
                }
            }
        }, 0);
    }
    ;
    get options() {
        return this._options;
    }
    valueFormatter(selectedOption, listType, valueKey) {
        return selectedOption ?
            listType === "string" /* string */ ? selectedOption.value :
                (valueKey && typeof selectedOption === 'object') ? selectedOption[valueKey] : selectedOption : null;
    }
    set value(val) {
        if (this.onChange) {
            this.onChange(val);
        }
        if (this.onTouch) {
            this.onTouch(val);
        }
        this._val = val;
    }
    get value() {
        return this._val;
    }
    ngOnInit() {
        if (this.searchEnabled) {
            this.searchControl = new FormControl('');
            this.searchControl.valueChanges.subscribe((value) => {
                this.updateDisplayOptions(this.options, value);
            });
        }
    }
    clearSearch() {
        this.searchControl.patchValue('');
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouch = fn;
    }
    setDisabledState(value) {
        this.disabled = value;
    }
    writeValue(value) {
        this.selectedOption = this.optionFormatter(this.options, this.listType, value, this.compareKey, this.valueKey);
        this.value = this.valueFormatter(this.selectedOption || value, this.listType, this.valueKey);
    }
    toggleDropdown() {
        if (this.searchEnabled) {
            this.clearSearchData();
        }
    }
    clearSearchData() {
        if (this.searchEnabled) {
            this.searchControl.patchValue('');
            if (this.inputField) {
                const scheduledFocus = asapScheduler.schedule(() => {
                    this.inputField.nativeElement.focus();
                    scheduledFocus.unsubscribe();
                });
            }
        }
    }
    updateDisplayOptions(options, filterText = '') {
        this.displayOptions = options.filter(opt => opt[this.compareKey].toLowerCase().indexOf(filterText.toLowerCase()) >= 0);
    }
    setSelection(event, option) {
        event.stopPropagation();
        this.writeValue(option);
    }
    onBlur() {
        this.ngControl.control.markAsTouched();
    }
}
SelectComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-select',
                template: "<div [ngClass]='containerClass'>\n  <label [ngClass]='labelClass'>\n    <span *ngIf='label'>{{ label | translate}}</span>\n  </label>\n  <div ngbDropdown [container]='container' [ngClass]='divClass' (openChange)=\"toggleDropdown()\">\n    <button [ngbTooltip]='ngControl.control?.errors | formControlError | translate' ngbDropdownToggle type='button'\n            [ngClass]='[((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n            (readonly ? readOnlyClass: \"\"), btnClass]' [disabled]='disabled' (blur)='onBlur()'>\n      {{ selectedOption | displayValue: {keys: labelKey} | translate}}\n      <span [ngClass]=\"caretClass\"></span>\n    </button>\n    <ul ngbDropdownMenu [ngClass]='listClass'>\n      <li *ngIf='searchEnabled' [ngClass]='searchHostClass'>\n        <input autocomplete=\"off\" #searchInput type=\"text\" [ngClass]=\"inputSearchClass\" [formControl]='searchControl' placeholder=\"{{searchPlaceholder | translate}}\" autofocus />\n        <i *ngIf=\"searchInput.value\" [ngClass]='clearIconClass' (click)=\"clearSearchData()\"></i>\n      </li>\n      <li *ngFor=\"let option of displayOptions\" [class.selected]='selectedOption && option[compareKey] === selectedOption[compareKey]'>\n        <a ngbDropdownItem (click)=\"setSelection($event,option)\">{{option | displayValue: {keys: labelKey} | translate}}</a>\n      </li>\n    </ul>\n  </div>\n</div>",
                exportAs: 'cnsSelect',
                styles: [""]
            },] }
];
SelectComponent.propDecorators = {
    searchEnabled: [{ type: Input }],
    divClass: [{ type: Input }],
    btnClass: [{ type: Input }],
    inputSearchClass: [{ type: Input }],
    listClass: [{ type: Input }],
    clearIconClass: [{ type: Input }],
    caretClass: [{ type: Input }],
    searchHostClass: [{ type: Input }],
    compareKey: [{ type: Input }],
    valueKey: [{ type: Input }],
    labelKey: [{ type: Input }],
    label: [{ type: Input }],
    searchPlaceholder: [{ type: Input }],
    options: [{ type: Input }],
    optionFormatter: [{ type: Input }],
    valueFormatter: [{ type: Input }],
    inputField: [{ type: ViewChild, args: ['searchInput', { static: false, read: ElementRef },] }]
};
//# sourceMappingURL=data:application/json;base64,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