import { Component, Input } from '@angular/core';
import { BaseFieldComponent } from '../base-field/base-field.component';
export class RadioGroupComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.labelClass = 'col-md-12 no-padder';
        this.fieldLabelClass = 'i-checks i-checks-sm';
        this.fieldClass = 'radio inline';
    }
}
RadioGroupComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-radio-group',
                template: "<div [ngClass]='containerClass'>\n    <label [ngClass]='labelClass' *ngIf='label'>{{ label | translate}}</label>\n    <ng-container *ngFor='let option of options'>\n        <div [ngClass]='fieldClass'>\n            <label [ngClass]=\"fieldLabelClass\">\n                <input [name]='name || id || ngControl.name' type=\"radio\" [value]='option?.value' [formControl]='ngControl.control'>\n                <i></i>\n                <span>{{ option?.label | translate }}</span>\n            </label>\n        </div>\n    </ng-container>\n    <span [class]='helpTextClass'>{{description | translate}}</span>\n</div>",
                exportAs: 'cnsRadioGroup',
                styles: [""]
            },] }
];
RadioGroupComponent.propDecorators = {
    options: [{ type: Input }],
    labelClass: [{ type: Input }],
    fieldLabelClass: [{ type: Input }],
    fieldClass: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmFkaW8tZ3JvdXAuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6Ii9ob21lL2plbmtpbnMvd29ya3NwYWNlL0F1dG9fY25NYWVzdHJvX0FuZ3VsYXJfTlBNX1JlbGVhc2VfQnVpbGQvbnBtL2Nucy11aS1saWIvcHJvamVjdHMvY2FtYml1bS9jbnMtdWktbGliL3NyYy8iLCJzb3VyY2VzIjpbImZvcm0tZmllbGRzL2NvbXBvbmVudHMvcmFkaW8tZ3JvdXAvcmFkaW8tZ3JvdXAuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBQ3pELE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxNQUFNLG9DQUFvQyxDQUFDO0FBYXhFLE1BQU0sT0FBTyxtQkFBb0IsU0FBUSxrQkFBa0I7SUFOM0Q7O1FBU1csZUFBVSxHQUFHLHFCQUFxQixDQUFDO1FBQ25DLG9CQUFlLEdBQUUsc0JBQXNCLENBQUM7UUFDeEMsZUFBVSxHQUFFLGNBQWMsQ0FBQztJQUV0QyxDQUFDOzs7WUFiQSxTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLGlCQUFpQjtnQkFDM0IsZ25CQUEyQztnQkFFM0MsUUFBUSxFQUFFLGVBQWU7O2FBQzFCOzs7c0JBR0UsS0FBSzt5QkFDTCxLQUFLOzhCQUNMLEtBQUs7eUJBQ0wsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbXBvbmVudCwgSW5wdXQsIE9uSW5pdCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQmFzZUZpZWxkQ29tcG9uZW50IH0gZnJvbSAnLi4vYmFzZS1maWVsZC9iYXNlLWZpZWxkLmNvbXBvbmVudCc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmFkaW9PcHRpb25zIHtcbiAgdmFsdWU6IG51bWJlciB8IHN0cmluZyB8IGJvb2xlYW47XG4gIGxhYmVsOiBzdHJpbmc7XG59XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ2Nucy1yYWRpby1ncm91cCcsXG4gIHRlbXBsYXRlVXJsOiAnLi9yYWRpby1ncm91cC5jb21wb25lbnQuaHRtbCcsXG4gIHN0eWxlVXJsczogWycuL3JhZGlvLWdyb3VwLmNvbXBvbmVudC5jc3MnXSxcbiAgZXhwb3J0QXM6ICdjbnNSYWRpb0dyb3VwJ1xufSlcbmV4cG9ydCBjbGFzcyBSYWRpb0dyb3VwQ29tcG9uZW50IGV4dGVuZHMgQmFzZUZpZWxkQ29tcG9uZW50IHtcblxuICBASW5wdXQoKSBvcHRpb25zOiBSYWRpb09wdGlvbnM7XG4gIEBJbnB1dCgpIGxhYmVsQ2xhc3MgPSAnY29sLW1kLTEyIG5vLXBhZGRlcic7XG4gIEBJbnB1dCgpIGZpZWxkTGFiZWxDbGFzcz0gJ2ktY2hlY2tzIGktY2hlY2tzLXNtJztcbiAgQElucHV0KCkgZmllbGRDbGFzcz0gJ3JhZGlvIGlubGluZSc7XG5cbn1cbiJdfQ==