import { Component, ViewChild } from '@angular/core';
import { BaseFieldComponent } from '../base-field/base-field.component';
export class PasswordComponent extends BaseFieldComponent {
    focus() {
        this.inputField.nativeElement.focus();
    }
}
PasswordComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-password',
                template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input #inputField [id]='id || name || ngControl.name'\n               [container]='container'\n               type=\"password\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n                                   inputClass]'\n               (input)='onChange($event.target.value)'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                styles: [".label-container>span.label-help{float:right}"]
            },] }
];
PasswordComponent.propDecorators = {
    inputField: [{ type: ViewChild, args: ['inputField', { static: true },] }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFzc3dvcmQuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6Ii9ob21lL2plbmtpbnMvd29ya3NwYWNlL0F1dG9fY25NYWVzdHJvX0FuZ3VsYXJfTlBNX1JlbGVhc2VfQnVpbGQvbnBtL2Nucy11aS1saWIvcHJvamVjdHMvY2FtYml1bS9jbnMtdWktbGliL3NyYy8iLCJzb3VyY2VzIjpbImZvcm0tZmllbGRzL2NvbXBvbmVudHMvcGFzc3dvcmQvcGFzc3dvcmQuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQXNCLFNBQVMsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUN6RSxPQUFPLEVBQUUsa0JBQWtCLEVBQUUsTUFBTSxvQ0FBb0MsQ0FBQztBQU94RSxNQUFNLE9BQU8saUJBQWtCLFNBQVEsa0JBQWtCO0lBS3ZELEtBQUs7UUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLGFBQWEsQ0FBQyxLQUFLLEVBQUUsQ0FBQztJQUN4QyxDQUFDOzs7WUFaRixTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLGNBQWM7Z0JBQ3hCLGt5Q0FBd0M7O2FBRXpDOzs7eUJBR0UsU0FBUyxTQUFDLFlBQVksRUFBRSxFQUFFLE1BQU0sRUFBRSxJQUFJLEVBQUUiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIEVsZW1lbnRSZWYsIE9uSW5pdCwgVmlld0NoaWxkIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBCYXNlRmllbGRDb21wb25lbnQgfSBmcm9tICcuLi9iYXNlLWZpZWxkL2Jhc2UtZmllbGQuY29tcG9uZW50JztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnY25zLXBhc3N3b3JkJyxcbiAgdGVtcGxhdGVVcmw6ICcuL3Bhc3N3b3JkLmNvbXBvbmVudC5odG1sJyxcbiAgc3R5bGVVcmxzOiBbJy4vcGFzc3dvcmQuY29tcG9uZW50LmNzcyddXG59KVxuZXhwb3J0IGNsYXNzIFBhc3N3b3JkQ29tcG9uZW50IGV4dGVuZHMgQmFzZUZpZWxkQ29tcG9uZW50IHtcbiAgXG4gIEBWaWV3Q2hpbGQoJ2lucHV0RmllbGQnLCB7IHN0YXRpYzogdHJ1ZSB9KSBpbnB1dEZpZWxkOiBFbGVtZW50UmVmO1xuXG4gIG9uVG91Y2g6ICh2YWx1ZTogYW55KSA9PiB2b2lkO1xuICBmb2N1cygpIHtcbiAgICB0aGlzLmlucHV0RmllbGQubmF0aXZlRWxlbWVudC5mb2N1cygpO1xuICB9XG59XG4iXX0=