import { Component } from '@angular/core';
import { BaseFieldComponent } from '../base-field/base-field.component';
export class NumberComponent extends BaseFieldComponent {
}
NumberComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-number',
                template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input [id]='id || name || ngControl.name'\n               [container]='container'\n               type=\"number\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n                                   inputClass]'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                styles: [".label-container>span.label-help{float:right}"]
            },] }
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibnVtYmVyLmNvbXBvbmVudC5qcyIsInNvdXJjZVJvb3QiOiIvaG9tZS9qZW5raW5zL3dvcmtzcGFjZS9BdXRvX2NuTWFlc3Ryb19Bbmd1bGFyX05QTV9SZWxlYXNlX0J1aWxkL25wbS9jbnMtdWktbGliL3Byb2plY3RzL2NhbWJpdW0vY25zLXVpLWxpYi9zcmMvIiwic291cmNlcyI6WyJmb3JtLWZpZWxkcy9jb21wb25lbnRzL251bWJlci9udW1iZXIuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBMkIsU0FBUyxFQUFVLE1BQU0sZUFBZSxDQUFDO0FBQzNFLE9BQU8sRUFBRSxrQkFBa0IsRUFBRSxNQUFNLG9DQUFvQyxDQUFDO0FBT3hFLE1BQU0sT0FBTyxlQUFnQixTQUFRLGtCQUFrQjs7O1lBTHRELFNBQVMsU0FBQztnQkFDVCxRQUFRLEVBQUUsWUFBWTtnQkFDdEIsNHRDQUFzQzs7YUFFdkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneSwgQ29tcG9uZW50LCBPbkluaXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IEJhc2VGaWVsZENvbXBvbmVudCB9IGZyb20gJy4uL2Jhc2UtZmllbGQvYmFzZS1maWVsZC5jb21wb25lbnQnO1xuXG5AQ29tcG9uZW50KHtcbiAgc2VsZWN0b3I6ICdjbnMtbnVtYmVyJyxcbiAgdGVtcGxhdGVVcmw6ICcuL251bWJlci5jb21wb25lbnQuaHRtbCcsXG4gIHN0eWxlVXJsczogWycuL251bWJlci5jb21wb25lbnQuY3NzJ11cbn0pXG5leHBvcnQgY2xhc3MgTnVtYmVyQ29tcG9uZW50IGV4dGVuZHMgQmFzZUZpZWxkQ29tcG9uZW50IHt9XG4iXX0=