import { Component, Input } from '@angular/core';
import { BaseFieldComponent } from '../base-field/base-field.component';
export class InputPasswordComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.helpTextClass = 'helpText m-t-xs';
        this.inputClass = 'form-control p-r-50';
        this.hideClass = 'h-phrase';
        this.showClass = 's-phrase';
        this.hideIconClass = 'bi bi-eye-slash-fill';
        this.showIconClass = 'bi bi-eye-fill';
        this.showText = true;
        this.inlineButtonBgClass = 'pos-abt t-phrase text-center r';
        this.hideCharactersLabel = 'common.hide';
        this.showCharactersLabel = 'common.show';
        this.hideCharactersTitle = 'common.hideChars';
        this.showCharactersTitle = 'common.showChars';
    }
    toggle(input) {
        input.type = input.type === "password" ? "text" : "password";
    }
}
InputPasswordComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-input-password',
                template: "<div [ngClass]=\"containerClass\">\n  <label [ngClass]=\"labelClass\" *ngIf='label'>\n    <span> {{ label | translate:translateValues }}</span>\n  </label>\n  <ng-content></ng-content>\n  <div [ngClass]=\"fieldClass\">\n    <input #input type=\"password\" [formControl]=\"ngControl.control\"\n           [container]='container'\n           [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n           [class.error]='ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)'\n           [ngClass]=\"inputClass\" (input)='onChange($event.target.value)' [name]=\"name\">\n    <i *ngIf='!showText' class='inline-icon' [ngClass]=\"input.type === 'text' ? hideIconClass : showIconClass\" (click)='toggle(input)'></i>\n    <span *ngIf='showText' [ngClass]=\"inlineButtonBgClass\" title=\"{{(input.type === 'text' ? hideCharactersTitle : showCharactersTitle) | translate}}\"\n          (click)='toggle(input)'\n          [ngClass]=\"input.type === 'text' ? hideClass : showClass\">\n      {{(input.type === 'text' ? hideCharactersLabel : showCharactersLabel) | translate}}\n    </span>\n  </div>\n  <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n    <ng-content select='[helpTextContent]'></ng-content>\n    <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n  </div>\n</div>",
                styles: [".inline-icon{cursor:pointer;position:absolute;right:15px;top:6px}"]
            },] }
];
InputPasswordComponent.propDecorators = {
    helpTextClass: [{ type: Input }],
    inputClass: [{ type: Input }],
    hideClass: [{ type: Input }],
    showClass: [{ type: Input }],
    hideIconClass: [{ type: Input }],
    showIconClass: [{ type: Input }],
    showText: [{ type: Input }],
    inlineButtonBgClass: [{ type: Input }],
    hideCharactersLabel: [{ type: Input }],
    showCharactersLabel: [{ type: Input }],
    hideCharactersTitle: [{ type: Input }],
    showCharactersTitle: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,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