import { Component, EventEmitter, Input, Output, ViewChild } from '@angular/core';
export var FileInputErrors;
(function (FileInputErrors) {
    FileInputErrors[FileInputErrors["invalidExtension"] = 0] = "invalidExtension";
    FileInputErrors[FileInputErrors["invalidFileName"] = 1] = "invalidFileName";
})(FileInputErrors || (FileInputErrors = {}));
export class FileInputComponent {
    constructor() {
        this.id = 'fileInputField';
        this.extensions = [];
        this.buttonLabel = 'common.SelectFile';
        this.label = 'common.File';
        this.containerClass = 'input-group';
        this.labelClass = 'control-label';
        this.fileNameClass = 'form-control';
        this.fieldClass = 'col-md-12 p-0';
        this.btnWrapperClass = 'input-group-append';
        this.btnClass = 'input-group-text';
        this.error = new EventEmitter();
        this.fileChange = new EventEmitter();
    }
    onFileChange(event) {
        const files = event.target.files;
        if (files && files.length) {
            this.selectedFile = files[0];
            const parts = this.selectedFile.name.split('.');
            const fileExtension = parts[parts.length - 1];
            if (this.extensions.length && this.extensions.indexOf(fileExtension) === -1) {
                this.emitError(FileInputErrors.invalidExtension);
            }
            else if (this.fileNameRegex && !this.fileNameRegex.test(this.selectedFile.name)) {
                this.emitError(FileInputErrors.invalidFileName);
            }
            else {
                this.fileChange.emit({
                    file: this.selectedFile
                });
            }
        }
        else {
            this.resetSelectedFile();
        }
    }
    emitError(error) {
        this.error.emit(error);
        this.resetSelectedFile();
    }
    resetSelectedFile() {
        this.selectedFile = undefined;
        this.fileInput.nativeElement.value = '';
    }
}
FileInputComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-file-input',
                template: "<div [ngClass]='containerClass'>\n    <label [ngClass]='labelClass'>{{ label | translate }}</label>\n    <div [ngClass]='fieldClass'>\n        <label [ngClass]=\"fileNameClass\" for=\"fileText\">{{selectedFile?.name}}</label>\n        <span [ngClass]=\"btnWrapperClass\" (click)='fileInput.click()'>\n            <span [ngClass]='btnClass'>{{buttonLabel | translate}}</span>\n            <input [id]='id' #fileInput type=\"file\" name=\"fileUpload\" [ngStyle]='{display:\"none\"}' (change)='onFileChange($event)' />\n        </span>\n    </div>\n</div>"
            },] }
];
FileInputComponent.ctorParameters = () => [];
FileInputComponent.propDecorators = {
    fileChange: [{ type: Output }],
    error: [{ type: Output }],
    id: [{ type: Input }],
    fileNameRegex: [{ type: Input }],
    extensions: [{ type: Input }],
    buttonLabel: [{ type: Input }],
    label: [{ type: Input }],
    containerClass: [{ type: Input }],
    labelClass: [{ type: Input }],
    fileNameClass: [{ type: Input }],
    fieldClass: [{ type: Input }],
    btnWrapperClass: [{ type: Input }],
    btnClass: [{ type: Input }],
    fileInput: [{ type: ViewChild, args: ['fileInput', { static: true },] }]
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZmlsZS1pbnB1dC5jb21wb25lbnQuanMiLCJzb3VyY2VSb290IjoiL2hvbWUvamVua2lucy93b3Jrc3BhY2UvQXV0b19jbk1hZXN0cm9fQW5ndWxhcl9OUE1fUmVsZWFzZV9CdWlsZC9ucG0vY25zLXVpLWxpYi9wcm9qZWN0cy9jYW1iaXVtL2Nucy11aS1saWIvc3JjLyIsInNvdXJjZXMiOlsiZm9ybS1maWVsZHMvY29tcG9uZW50cy9maWxlLWlucHV0L2ZpbGUtaW5wdXQuY29tcG9uZW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQWMsWUFBWSxFQUFFLEtBQUssRUFBRSxNQUFNLEVBQWUsU0FBUyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBRTNHLE1BQU0sQ0FBTixJQUFZLGVBR1g7QUFIRCxXQUFZLGVBQWU7SUFDekIsNkVBQWdCLENBQUE7SUFDaEIsMkVBQWUsQ0FBQTtBQUNqQixDQUFDLEVBSFcsZUFBZSxLQUFmLGVBQWUsUUFHMUI7QUFVRCxNQUFNLE9BQU8sa0JBQWtCO0lBcUI3QjtRQWZTLE9BQUUsR0FBVyxnQkFBZ0IsQ0FBQztRQUU5QixlQUFVLEdBQWEsRUFBRSxDQUFDO1FBQzFCLGdCQUFXLEdBQUcsbUJBQW1CLENBQUM7UUFDbEMsVUFBSyxHQUFHLGFBQWEsQ0FBQztRQUV0QixtQkFBYyxHQUFHLGFBQWEsQ0FBQztRQUMvQixlQUFVLEdBQUcsZUFBZSxDQUFDO1FBQzdCLGtCQUFhLEdBQUcsY0FBYyxDQUFDO1FBQy9CLGVBQVUsR0FBRyxlQUFlLENBQUE7UUFDNUIsb0JBQWUsR0FBRyxvQkFBb0IsQ0FBQztRQUN2QyxhQUFRLEdBQUcsa0JBQWtCLENBQUM7UUFLckMsSUFBSSxDQUFDLEtBQUssR0FBRyxJQUFJLFlBQVksRUFBRSxDQUFDO1FBQ2hDLElBQUksQ0FBQyxVQUFVLEdBQUcsSUFBSSxZQUFZLEVBQUUsQ0FBQztJQUN2QyxDQUFDO0lBRUQsWUFBWSxDQUFDLEtBQVk7UUFDdkIsTUFBTSxLQUFLLEdBQUksS0FBSyxDQUFDLE1BQTJCLENBQUMsS0FBSyxDQUFDO1FBQ3ZELElBQUksS0FBSyxJQUFJLEtBQUssQ0FBQyxNQUFNLEVBQUU7WUFDekIsSUFBSSxDQUFDLFlBQVksR0FBRyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDN0IsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ2hELE1BQU0sYUFBYSxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQzlDLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUU7Z0JBQzNFLElBQUksQ0FBQyxTQUFTLENBQUMsZUFBZSxDQUFDLGdCQUFnQixDQUFDLENBQUM7YUFDbEQ7aUJBQU0sSUFBSSxJQUFJLENBQUMsYUFBYSxJQUFJLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsRUFBRTtnQkFDakYsSUFBSSxDQUFDLFNBQVMsQ0FBQyxlQUFlLENBQUMsZUFBZSxDQUFDLENBQUM7YUFDakQ7aUJBQU07Z0JBQ0wsSUFBSSxDQUFDLFVBQVUsQ0FBQyxJQUFJLENBQUM7b0JBQ25CLElBQUksRUFBRSxJQUFJLENBQUMsWUFBWTtpQkFDeEIsQ0FBQyxDQUFDO2FBQ0o7U0FDRjthQUFNO1lBQ0wsSUFBSSxDQUFDLGlCQUFpQixFQUFFLENBQUM7U0FDMUI7SUFDSCxDQUFDO0lBRUQsU0FBUyxDQUFDLEtBQXNCO1FBQzlCLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDO0lBQzNCLENBQUM7SUFFRCxpQkFBaUI7UUFDZixJQUFJLENBQUMsWUFBWSxHQUFHLFNBQVMsQ0FBQztRQUM5QixJQUFJLENBQUMsU0FBUyxDQUFDLGFBQWEsQ0FBQyxLQUFLLEdBQUcsRUFBRSxDQUFDO0lBQzFDLENBQUM7OztZQTFERixTQUFTLFNBQUM7Z0JBQ1QsUUFBUSxFQUFFLGdCQUFnQjtnQkFDMUIsb2pCQUEwQzthQUMzQzs7Ozt5QkFJRSxNQUFNO29CQUNOLE1BQU07aUJBRU4sS0FBSzs0QkFDTCxLQUFLO3lCQUNMLEtBQUs7MEJBQ0wsS0FBSztvQkFDTCxLQUFLOzZCQUVMLEtBQUs7eUJBQ0wsS0FBSzs0QkFDTCxLQUFLO3lCQUNMLEtBQUs7OEJBQ0wsS0FBSzt1QkFDTCxLQUFLO3dCQUVMLFNBQVMsU0FBQyxXQUFXLEVBQUUsRUFBRSxNQUFNLEVBQUUsSUFBSSxFQUFFIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50LCBFbGVtZW50UmVmLCBFdmVudEVtaXR0ZXIsIElucHV0LCBPdXRwdXQsIFRlbXBsYXRlUmVmLCBWaWV3Q2hpbGQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcblxuZXhwb3J0IGVudW0gRmlsZUlucHV0RXJyb3JzIHtcbiAgaW52YWxpZEV4dGVuc2lvbixcbiAgaW52YWxpZEZpbGVOYW1lXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRmlsZUNoYW5nZUV2ZW50IHtcbiAgZmlsZTogRmlsZTtcbn1cblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnY25zLWZpbGUtaW5wdXQnLFxuICB0ZW1wbGF0ZVVybDogJy4vZmlsZS1pbnB1dC5jb21wb25lbnQuaHRtbCdcbn0pXG5leHBvcnQgY2xhc3MgRmlsZUlucHV0Q29tcG9uZW50IHtcbiAgc2VsZWN0ZWRGaWxlOiBGaWxlO1xuXG4gIEBPdXRwdXQoKSBmaWxlQ2hhbmdlOiBFdmVudEVtaXR0ZXI8YW55PjtcbiAgQE91dHB1dCgpIGVycm9yOiBFdmVudEVtaXR0ZXI8YW55PjtcblxuICBASW5wdXQoKSBpZDogc3RyaW5nID0gJ2ZpbGVJbnB1dEZpZWxkJztcbiAgQElucHV0KCkgZmlsZU5hbWVSZWdleDtcbiAgQElucHV0KCkgZXh0ZW5zaW9uczogc3RyaW5nW10gPSBbXTtcbiAgQElucHV0KCkgYnV0dG9uTGFiZWwgPSAnY29tbW9uLlNlbGVjdEZpbGUnO1xuICBASW5wdXQoKSBsYWJlbCA9ICdjb21tb24uRmlsZSc7XG4gIFxuICBASW5wdXQoKSBjb250YWluZXJDbGFzcyA9ICdpbnB1dC1ncm91cCc7XG4gIEBJbnB1dCgpIGxhYmVsQ2xhc3MgPSAnY29udHJvbC1sYWJlbCc7XG4gIEBJbnB1dCgpIGZpbGVOYW1lQ2xhc3MgPSAnZm9ybS1jb250cm9sJztcbiAgQElucHV0KCkgZmllbGRDbGFzcyA9ICdjb2wtbWQtMTIgcC0wJ1xuICBASW5wdXQoKSBidG5XcmFwcGVyQ2xhc3MgPSAnaW5wdXQtZ3JvdXAtYXBwZW5kJztcbiAgQElucHV0KCkgYnRuQ2xhc3MgPSAnaW5wdXQtZ3JvdXAtdGV4dCc7XG5cbiAgQFZpZXdDaGlsZCgnZmlsZUlucHV0JywgeyBzdGF0aWM6IHRydWUgfSkgZmlsZUlucHV0OiBFbGVtZW50UmVmPEhUTUxJbnB1dEVsZW1lbnQ+O1xuXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIHRoaXMuZXJyb3IgPSBuZXcgRXZlbnRFbWl0dGVyKCk7XG4gICAgdGhpcy5maWxlQ2hhbmdlID0gbmV3IEV2ZW50RW1pdHRlcigpO1xuICB9XG5cbiAgb25GaWxlQ2hhbmdlKGV2ZW50OiBFdmVudCkge1xuICAgIGNvbnN0IGZpbGVzID0gKGV2ZW50LnRhcmdldCBhcyBIVE1MSW5wdXRFbGVtZW50KS5maWxlcztcbiAgICBpZiAoZmlsZXMgJiYgZmlsZXMubGVuZ3RoKSB7XG4gICAgICB0aGlzLnNlbGVjdGVkRmlsZSA9IGZpbGVzWzBdO1xuICAgICAgY29uc3QgcGFydHMgPSB0aGlzLnNlbGVjdGVkRmlsZS5uYW1lLnNwbGl0KCcuJyk7XG4gICAgICBjb25zdCBmaWxlRXh0ZW5zaW9uID0gcGFydHNbcGFydHMubGVuZ3RoIC0gMV07XG4gICAgICBpZiAodGhpcy5leHRlbnNpb25zLmxlbmd0aCAmJiB0aGlzLmV4dGVuc2lvbnMuaW5kZXhPZihmaWxlRXh0ZW5zaW9uKSA9PT0gLTEpIHtcbiAgICAgICAgdGhpcy5lbWl0RXJyb3IoRmlsZUlucHV0RXJyb3JzLmludmFsaWRFeHRlbnNpb24pO1xuICAgICAgfSBlbHNlIGlmICh0aGlzLmZpbGVOYW1lUmVnZXggJiYgIXRoaXMuZmlsZU5hbWVSZWdleC50ZXN0KHRoaXMuc2VsZWN0ZWRGaWxlLm5hbWUpKSB7XG4gICAgICAgIHRoaXMuZW1pdEVycm9yKEZpbGVJbnB1dEVycm9ycy5pbnZhbGlkRmlsZU5hbWUpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdGhpcy5maWxlQ2hhbmdlLmVtaXQoe1xuICAgICAgICAgIGZpbGU6IHRoaXMuc2VsZWN0ZWRGaWxlXG4gICAgICAgIH0pO1xuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICB0aGlzLnJlc2V0U2VsZWN0ZWRGaWxlKCk7XG4gICAgfVxuICB9XG5cbiAgZW1pdEVycm9yKGVycm9yOiBGaWxlSW5wdXRFcnJvcnMpIHtcbiAgICB0aGlzLmVycm9yLmVtaXQoZXJyb3IpO1xuICAgIHRoaXMucmVzZXRTZWxlY3RlZEZpbGUoKTtcbiAgfVxuXG4gIHJlc2V0U2VsZWN0ZWRGaWxlKCkge1xuICAgIHRoaXMuc2VsZWN0ZWRGaWxlID0gdW5kZWZpbmVkO1xuICAgIHRoaXMuZmlsZUlucHV0Lm5hdGl2ZUVsZW1lbnQudmFsdWUgPSAnJztcbiAgfVxuXG59XG4iXX0=