import { Component, Input } from '@angular/core';
import { asyncScheduler } from 'rxjs';
import { BaseFieldComponent } from '../base-field/base-field.component';
export class CheckboxComponent extends BaseFieldComponent {
    constructor() {
        super(...arguments);
        this.checked = false;
        this.containerClass = 'form-group checkbox';
        this.fieldClass = 'i-checks i-checks-sm';
        this.labelClass = '';
        this.ngTrueValue = true;
        this.ngFalseValue = false;
    }
    emitChange(event) {
        const value = event.currentTarget.checked ? this.ngTrueValue : this.ngFalseValue;
        this.onChange(value);
        this.writeValue(value);
    }
    writeValue(value) {
        this.subscriptions.push(asyncScheduler.schedule(() => {
            this.checked = (value === this.ngTrueValue);
            this.value = this.checked ? this.ngTrueValue : this.ngFalseValue;
        }));
    }
}
CheckboxComponent.decorators = [
    { type: Component, args: [{
                selector: 'cns-checkbox',
                template: "<div [ngClass]=\"containerClass\">\n  <label [ngClass]='fieldClass'>\n    <input [id]=\"id || name || ngControl.name\" type=\"checkbox\" [checked]='checked' (change)='emitChange($event)' [disabled]='disabled'/><i></i>\n    <span>\n      <span>\n        <span [ngClass]='labelClass'>{{ label | translate}}</span>\n        <ng-content select='[container=middle]'></ng-content>\n        <span class=\"helpText\">{{ description | translate}}</span>\n      </span>\n      <ng-content></ng-content>\n    </span>\n  </label>\n</div>",
                exportAs: 'cnsCheckbox',
                styles: [""]
            },] }
];
CheckboxComponent.propDecorators = {
    containerClass: [{ type: Input }],
    fieldClass: [{ type: Input }],
    labelClass: [{ type: Input }],
    ngTrueValue: [{ type: Input }],
    ngFalseValue: [{ type: Input }]
};
//# sourceMappingURL=data:application/json;base64,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