import { Component, ContentChild, Input, Optional, Self } from '@angular/core';
import { NgControl } from '@angular/forms';
export class BaseFieldComponent {
    constructor(ngControl) {
        this.ngControl = ngControl;
        this._value = '';
        this.disabled = false;
        this.subscriptions = [];
        this.readonly = false;
        // Classes
        this.labelClass = 'control-label';
        this.containerClass = 'form-group';
        this.fieldClass = 'col-md-12 no-padder';
        this.inputClass = 'form-control';
        this.helpTextClass = 'helpText';
        this.readOnlyClass = 'read-form-control';
        this.errorClass = 'error';
        this.labelHelpClass = 'label-help';
        this.labelContainerClass = 'label-container';
        if (this.ngControl) {
            this.ngControl.valueAccessor = this;
        }
    }
    set value(value) {
        if (value) {
            this._value = value;
        }
    }
    ;
    get value() {
        return this._value;
    }
    writeValue(value) {
        this.value = value;
    }
    setDisabledState(isDisabled) {
        this.disabled = isDisabled;
    }
    registerOnChange(fn) {
        this.onChange = fn;
    }
    registerOnTouched(fn) {
        this.onTouched = fn;
    }
    ngOnDestroy() {
        this.subscriptions.forEach(subscription => {
            subscription.unsubscribe();
        });
    }
}
BaseFieldComponent.decorators = [
    { type: Component, args: [{
                selector: 'lib-base-field',
                template: "<p>base-field works!</p>\n",
                styles: [""]
            },] }
];
BaseFieldComponent.ctorParameters = () => [
    { type: NgControl, decorators: [{ type: Self }, { type: Optional }] }
];
BaseFieldComponent.propDecorators = {
    value: [{ type: Input }],
    container: [{ type: Input }],
    id: [{ type: Input }],
    label: [{ type: Input }],
    description: [{ type: Input }],
    name: [{ type: Input }],
    translateValues: [{ type: Input }],
    readonly: [{ type: Input }],
    placeholder: [{ type: Input }],
    labelClass: [{ type: Input }],
    containerClass: [{ type: Input }],
    fieldClass: [{ type: Input }],
    inputClass: [{ type: Input }],
    helpTextClass: [{ type: Input }],
    descriptionClass: [{ type: Input }],
    readOnlyClass: [{ type: Input }],
    errorClass: [{ type: Input }],
    iconClass: [{ type: Input }],
    labelHelpClass: [{ type: Input }],
    labelContainerClass: [{ type: Input }],
    helpTextContent: [{ type: ContentChild, args: ['helpTextContent', { static: true },] }]
};
//# sourceMappingURL=data:application/json;base64,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