(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('@angular/forms'), require('@angular/common'), require('@angular/common/http'), require('@ng-bootstrap/ng-bootstrap'), require('rxjs')) :
    typeof define === 'function' && define.amd ? define('@cambium/cns-ui-lib', ['exports', '@angular/core', '@angular/forms', '@angular/common', '@angular/common/http', '@ng-bootstrap/ng-bootstrap', 'rxjs'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory((global.cambium = global.cambium || {}, global.cambium['cns-ui-lib'] = {}), global.ng.core, global.ng.forms, global.ng.common, global.ng.common.http, global['ng-bootstrap'], global.rxjs));
}(this, (function (exports, i0, forms, common, i1, ngBootstrap, rxjs) { 'use strict';

    var BaseFieldComponent = /** @class */ (function () {
        function BaseFieldComponent(ngControl) {
            this.ngControl = ngControl;
            this._value = '';
            this.disabled = false;
            this.subscriptions = [];
            this.readonly = false;
            // Classes
            this.labelClass = 'control-label';
            this.containerClass = 'form-group';
            this.fieldClass = 'col-md-12 no-padder';
            this.inputClass = 'form-control';
            this.helpTextClass = 'helpText';
            this.readOnlyClass = 'read-form-control';
            this.errorClass = 'error';
            this.labelHelpClass = 'label-help';
            this.labelContainerClass = 'label-container';
            if (this.ngControl) {
                this.ngControl.valueAccessor = this;
            }
        }
        Object.defineProperty(BaseFieldComponent.prototype, "value", {
            get: function () {
                return this._value;
            },
            set: function (value) {
                if (value) {
                    this._value = value;
                }
            },
            enumerable: false,
            configurable: true
        });
        ;
        BaseFieldComponent.prototype.writeValue = function (value) {
            this.value = value;
        };
        BaseFieldComponent.prototype.setDisabledState = function (isDisabled) {
            this.disabled = isDisabled;
        };
        BaseFieldComponent.prototype.registerOnChange = function (fn) {
            this.onChange = fn;
        };
        BaseFieldComponent.prototype.registerOnTouched = function (fn) {
            this.onTouched = fn;
        };
        BaseFieldComponent.prototype.ngOnDestroy = function () {
            this.subscriptions.forEach(function (subscription) {
                subscription.unsubscribe();
            });
        };
        return BaseFieldComponent;
    }());
    BaseFieldComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'lib-base-field',
                    template: "<p>base-field works!</p>\n",
                    styles: [""]
                },] }
    ];
    BaseFieldComponent.ctorParameters = function () { return [
        { type: forms.NgControl, decorators: [{ type: i0.Self }, { type: i0.Optional }] }
    ]; };
    BaseFieldComponent.propDecorators = {
        value: [{ type: i0.Input }],
        container: [{ type: i0.Input }],
        id: [{ type: i0.Input }],
        label: [{ type: i0.Input }],
        description: [{ type: i0.Input }],
        name: [{ type: i0.Input }],
        translateValues: [{ type: i0.Input }],
        readonly: [{ type: i0.Input }],
        placeholder: [{ type: i0.Input }],
        labelClass: [{ type: i0.Input }],
        containerClass: [{ type: i0.Input }],
        fieldClass: [{ type: i0.Input }],
        inputClass: [{ type: i0.Input }],
        helpTextClass: [{ type: i0.Input }],
        descriptionClass: [{ type: i0.Input }],
        readOnlyClass: [{ type: i0.Input }],
        errorClass: [{ type: i0.Input }],
        iconClass: [{ type: i0.Input }],
        labelHelpClass: [{ type: i0.Input }],
        labelContainerClass: [{ type: i0.Input }],
        helpTextContent: [{ type: i0.ContentChild, args: ['helpTextContent', { static: true },] }]
    };

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise */
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b)
                if (Object.prototype.hasOwnProperty.call(b, p))
                    d[p] = b[p]; };
        return extendStatics(d, b);
    };
    function __extends(d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }
    var __assign = function () {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };
    function __rest(s, e) {
        var t = {};
        for (var p in s)
            if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
                t[p] = s[p];
        if (s != null && typeof Object.getOwnPropertySymbols === "function")
            for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
                if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                    t[p[i]] = s[p[i]];
            }
        return t;
    }
    function __decorate(decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function")
            r = Reflect.decorate(decorators, target, key, desc);
        else
            for (var i = decorators.length - 1; i >= 0; i--)
                if (d = decorators[i])
                    r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    }
    function __param(paramIndex, decorator) {
        return function (target, key) { decorator(target, key, paramIndex); };
    }
    function __metadata(metadataKey, metadataValue) {
        if (typeof Reflect === "object" && typeof Reflect.metadata === "function")
            return Reflect.metadata(metadataKey, metadataValue);
    }
    function __awaiter(thisArg, _arguments, P, generator) {
        function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try {
                step(generator.next(value));
            }
            catch (e) {
                reject(e);
            } }
            function rejected(value) { try {
                step(generator["throw"](value));
            }
            catch (e) {
                reject(e);
            } }
            function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments || [])).next());
        });
    }
    function __generator(thisArg, body) {
        var _ = { label: 0, sent: function () { if (t[0] & 1)
                throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
        return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function () { return this; }), g;
        function verb(n) { return function (v) { return step([n, v]); }; }
        function step(op) {
            if (f)
                throw new TypeError("Generator is already executing.");
            while (_)
                try {
                    if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done)
                        return t;
                    if (y = 0, t)
                        op = [op[0] & 2, t.value];
                    switch (op[0]) {
                        case 0:
                        case 1:
                            t = op;
                            break;
                        case 4:
                            _.label++;
                            return { value: op[1], done: false };
                        case 5:
                            _.label++;
                            y = op[1];
                            op = [0];
                            continue;
                        case 7:
                            op = _.ops.pop();
                            _.trys.pop();
                            continue;
                        default:
                            if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) {
                                _ = 0;
                                continue;
                            }
                            if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) {
                                _.label = op[1];
                                break;
                            }
                            if (op[0] === 6 && _.label < t[1]) {
                                _.label = t[1];
                                t = op;
                                break;
                            }
                            if (t && _.label < t[2]) {
                                _.label = t[2];
                                _.ops.push(op);
                                break;
                            }
                            if (t[2])
                                _.ops.pop();
                            _.trys.pop();
                            continue;
                    }
                    op = body.call(thisArg, _);
                }
                catch (e) {
                    op = [6, e];
                    y = 0;
                }
                finally {
                    f = t = 0;
                }
            if (op[0] & 5)
                throw op[1];
            return { value: op[0] ? op[1] : void 0, done: true };
        }
    }
    var __createBinding = Object.create ? (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        Object.defineProperty(o, k2, { enumerable: true, get: function () { return m[k]; } });
    }) : (function (o, m, k, k2) {
        if (k2 === undefined)
            k2 = k;
        o[k2] = m[k];
    });
    function __exportStar(m, o) {
        for (var p in m)
            if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p))
                __createBinding(o, m, p);
    }
    function __values(o) {
        var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
        if (m)
            return m.call(o);
        if (o && typeof o.length === "number")
            return {
                next: function () {
                    if (o && i >= o.length)
                        o = void 0;
                    return { value: o && o[i++], done: !o };
                }
            };
        throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
    }
    function __read(o, n) {
        var m = typeof Symbol === "function" && o[Symbol.iterator];
        if (!m)
            return o;
        var i = m.call(o), r, ar = [], e;
        try {
            while ((n === void 0 || n-- > 0) && !(r = i.next()).done)
                ar.push(r.value);
        }
        catch (error) {
            e = { error: error };
        }
        finally {
            try {
                if (r && !r.done && (m = i["return"]))
                    m.call(i);
            }
            finally {
                if (e)
                    throw e.error;
            }
        }
        return ar;
    }
    /** @deprecated */
    function __spread() {
        for (var ar = [], i = 0; i < arguments.length; i++)
            ar = ar.concat(__read(arguments[i]));
        return ar;
    }
    /** @deprecated */
    function __spreadArrays() {
        for (var s = 0, i = 0, il = arguments.length; i < il; i++)
            s += arguments[i].length;
        for (var r = Array(s), k = 0, i = 0; i < il; i++)
            for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
                r[k] = a[j];
        return r;
    }
    function __spreadArray(to, from, pack) {
        if (pack || arguments.length === 2)
            for (var i = 0, l = from.length, ar; i < l; i++) {
                if (ar || !(i in from)) {
                    if (!ar)
                        ar = Array.prototype.slice.call(from, 0, i);
                    ar[i] = from[i];
                }
            }
        return to.concat(ar || Array.prototype.slice.call(from));
    }
    function __await(v) {
        return this instanceof __await ? (this.v = v, this) : new __await(v);
    }
    function __asyncGenerator(thisArg, _arguments, generator) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var g = generator.apply(thisArg, _arguments || []), i, q = [];
        return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
        function verb(n) { if (g[n])
            i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
        function resume(n, v) { try {
            step(g[n](v));
        }
        catch (e) {
            settle(q[0][3], e);
        } }
        function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
        function fulfill(value) { resume("next", value); }
        function reject(value) { resume("throw", value); }
        function settle(f, v) { if (f(v), q.shift(), q.length)
            resume(q[0][0], q[0][1]); }
    }
    function __asyncDelegator(o) {
        var i, p;
        return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
        function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
    }
    function __asyncValues(o) {
        if (!Symbol.asyncIterator)
            throw new TypeError("Symbol.asyncIterator is not defined.");
        var m = o[Symbol.asyncIterator], i;
        return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
        function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
        function settle(resolve, reject, d, v) { Promise.resolve(v).then(function (v) { resolve({ value: v, done: d }); }, reject); }
    }
    function __makeTemplateObject(cooked, raw) {
        if (Object.defineProperty) {
            Object.defineProperty(cooked, "raw", { value: raw });
        }
        else {
            cooked.raw = raw;
        }
        return cooked;
    }
    ;
    var __setModuleDefault = Object.create ? (function (o, v) {
        Object.defineProperty(o, "default", { enumerable: true, value: v });
    }) : function (o, v) {
        o["default"] = v;
    };
    function __importStar(mod) {
        if (mod && mod.__esModule)
            return mod;
        var result = {};
        if (mod != null)
            for (var k in mod)
                if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k))
                    __createBinding(result, mod, k);
        __setModuleDefault(result, mod);
        return result;
    }
    function __importDefault(mod) {
        return (mod && mod.__esModule) ? mod : { default: mod };
    }
    function __classPrivateFieldGet(receiver, state, kind, f) {
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a getter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot read private member from an object whose class did not declare it");
        return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
    }
    function __classPrivateFieldSet(receiver, state, value, kind, f) {
        if (kind === "m")
            throw new TypeError("Private method is not writable");
        if (kind === "a" && !f)
            throw new TypeError("Private accessor was defined without a setter");
        if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver))
            throw new TypeError("Cannot write private member to an object whose class did not declare it");
        return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
    }

    var get = function (obj, path, defaultVal, isNullFalsy) {
        if (defaultVal === void 0) { defaultVal = undefined; }
        if (isNullFalsy === void 0) { isNullFalsy = false; }
        var pathList = path === null || path === void 0 ? void 0 : path.toString().split('.').reverse();
        while (pathList.length && obj) {
            obj = obj[pathList.pop()];
        }
        return obj === undefined || (obj === null && isNullFalsy) ? defaultVal : obj;
    };
    /**
     * updates destination object in-place
     * @param dest Destination Object
     * @param source data to update
     * @returns destination object with updated data from source
     */
    var merge = function (dest, source) {
        if (dest === void 0) { dest = {}; }
        for (var key in source) {
            if (key in dest) {
                if (typeof dest[key] === 'object' && typeof source[key] === 'object') {
                    dest[key] = merge(dest[key], source[key]);
                }
                else {
                    dest[key] = source[key];
                }
            }
            else {
                dest[key] = source[key];
            }
        }
        return dest;
    };
    /**
     * Checks whether value is defined
     * @param obj object to check
     * @returns boolean
     */
    var isDefined = function (obj) {
        return obj !== undefined || obj !== null;
    };

    var CNSI18nService = /** @class */ (function () {
        function CNSI18nService(http) {
            this.http = http;
            this.data = {};
            this.resolvedFileNames = [];
        }
        /**
         * Fetches All Locale File (except the ones that are already added) and update data
         * @param fileNames URLs of locale Files
         * @returns Promise that resolves after fetching the locale
         */
        CNSI18nService.prototype.addLocales = function (fileNames) {
            var _this = this;
            var parts = fileNames.filter(function (file) { return _this.resolvedFileNames.indexOf(file) === -1; });
            return Promise.all(parts.map(function (file) { return _this.addLocale(file); }));
        };
        /**
         * Fetches Locale File and update data
         * @param fileName URL for locale file
         * @returns Promise which is fulfilled after APi calls
         */
        CNSI18nService.prototype.addLocale = function (fileName) {
            var _this = this;
            return new Promise(function (resolve, reject) {
                if (_this.resolvedFileNames.indexOf(fileName) > -1) {
                    resolve(_this.data);
                }
                else {
                    _this.http.get(fileName).subscribe(function (response) {
                        merge(_this.data, response);
                        _this.resolvedFileNames.push(fileName);
                        resolve(_this.data);
                    }, function (error) {
                        reject(error);
                    });
                }
            });
        };
        /**
         * Update the locale data for translation.
         * @param data JSON object to update locale keys
         */
        CNSI18nService.prototype.addData = function (data) {
            this.data = merge(this.data, data);
        };
        return CNSI18nService;
    }());
    CNSI18nService.ɵprov = i0.ɵɵdefineInjectable({ factory: function CNSI18nService_Factory() { return new CNSI18nService(i0.ɵɵinject(i1.HttpClient)); }, token: CNSI18nService, providedIn: "root" });
    CNSI18nService.decorators = [
        { type: i0.Injectable, args: [{
                    providedIn: 'root'
                },] }
    ];
    CNSI18nService.ctorParameters = function () { return [
        { type: i1.HttpClient }
    ]; };

    var CNSTranslateService = /** @class */ (function () {
        function CNSTranslateService(i18nService) {
            this.i18nService = i18nService;
        }
        CNSTranslateService.prototype.translate = function (key) {
            return get(this.i18nService.data, key, key);
        };
        CNSTranslateService.prototype.translateObj = function (key, localeObject) {
            if (localeObject) {
                return this.translate(key).replace(/{{(.*?)}}/g, function (matchedSubstr) {
                    var replacementKey = matchedSubstr.substring(2, matchedSubstr.length - 2);
                    return localeObject[replacementKey] !== undefined ? localeObject[replacementKey] : '';
                });
            }
            else {
                return this.translate(key);
            }
        };
        return CNSTranslateService;
    }());
    CNSTranslateService.ɵprov = i0.ɵɵdefineInjectable({ factory: function CNSTranslateService_Factory() { return new CNSTranslateService(i0.ɵɵinject(CNSI18nService)); }, token: CNSTranslateService, providedIn: "root" });
    CNSTranslateService.decorators = [
        { type: i0.Injectable, args: [{
                    providedIn: 'root'
                },] }
    ];
    CNSTranslateService.ctorParameters = function () { return [
        { type: CNSI18nService }
    ]; };

    var CNSTranslateDirective = /** @class */ (function () {
        function CNSTranslateDirective(translateService, el) {
            this.translateService = translateService;
            this.el = el;
        }
        CNSTranslateDirective.prototype.ngOnChanges = function (changes) {
            this.updateHTML();
        };
        CNSTranslateDirective.prototype.updateHTML = function () {
            if (this.translateKey) {
                this.el.nativeElement.innerHTML = this.translateService.translateObj(this.translateKey, this.translateValues);
            }
            else {
                this.el.nativeElement.innerHTML = this.translateService.translateObj(this.el.nativeElement.innerText, this.translateValues);
            }
        };
        return CNSTranslateDirective;
    }());
    CNSTranslateDirective.decorators = [
        { type: i0.Directive, args: [{
                    selector: '[translate]'
                },] }
    ];
    CNSTranslateDirective.ctorParameters = function () { return [
        { type: CNSTranslateService },
        { type: i0.ElementRef }
    ]; };
    CNSTranslateDirective.propDecorators = {
        translateKey: [{ type: i0.Input, args: ['translate',] }],
        translateValues: [{ type: i0.Input }]
    };

    var CNSDisplayValuePipe = /** @class */ (function () {
        function CNSDisplayValuePipe() {
        }
        CNSDisplayValuePipe.prototype.transform = function (value, args) {
            var displayValue;
            if (args) {
                // value is object, should pass keys
                if (args.keys) {
                    var keys = Array.isArray(args.keys) ? args.keys.join('.') : args.keys;
                    displayValue = get(value, keys);
                }
                else {
                    // No keys passed -- consider it as string/number
                    displayValue = value;
                }
            }
            else {
                displayValue = value;
            }
            if (!isDefined(displayValue) && args && isDefined(args.default)) {
                displayValue = args.default;
            }
            else if (displayValue !== undefined && args && args.unit) {
                displayValue += ' ' + args.unit;
            }
            return displayValue;
        };
        return CNSDisplayValuePipe;
    }());
    CNSDisplayValuePipe.decorators = [
        { type: i0.Pipe, args: [{
                    name: 'displayValue'
                },] }
    ];

    var CNSRegexService = /** @class */ (function () {
        function CNSRegexService() {
            this.regex = {};
        }
        CNSRegexService.prototype.addRegex = function (obj) {
            this.regex = merge(this.regex, obj);
        };
        CNSRegexService.prototype.addRegexObjects = function (key, obj) {
            this.regex[key] = obj;
        };
        CNSRegexService.prototype.getRegex = function (key) {
            return this.regex[key];
        };
        CNSRegexService.prototype.getAll = function () {
            return this.regex;
        };
        return CNSRegexService;
    }());
    CNSRegexService.ɵprov = i0.ɵɵdefineInjectable({ factory: function CNSRegexService_Factory() { return new CNSRegexService(); }, token: CNSRegexService, providedIn: "root" });
    CNSRegexService.decorators = [
        { type: i0.Injectable, args: [{
                    providedIn: 'root'
                },] }
    ];
    CNSRegexService.ctorParameters = function () { return []; };

    var CNSFormControlErrorPipe = /** @class */ (function () {
        function CNSFormControlErrorPipe(regexService) {
            this.regexService = regexService;
        }
        CNSFormControlErrorPipe.prototype.transform = function (errorObj) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            var customErrors = args ? args[0] : {};
            if (errorObj) {
                var keys = Object.keys(errorObj);
                // If custom error: Error object should have a 'msg' property
                for (var i = 0; i < keys.length; i++) {
                    if (errorObj[keys[i]].msg) {
                        return errorObj[keys[i]].msg;
                    }
                }
                if ('pattern' in errorObj) {
                    var regexConstants_1 = this.regexService.getAll();
                    var pattern = Object.keys(regexConstants_1).find(function (key) {
                        if (regexConstants_1[key].exp && regexConstants_1[key].exp.toString() === errorObj.pattern.requiredPattern) {
                            return regexConstants_1[key].msg;
                        }
                    });
                    return pattern ? regexConstants_1[pattern].msg : '';
                }
                if ('required' in errorObj) {
                    return 'This field is required';
                }
                if ('maxlength' in errorObj) {
                    return "Please enter no more than " + errorObj.maxlength.requiredLength + " characters.";
                }
                if ('minlength' in errorObj) {
                    return "Please enter at least " + errorObj.minlength.requiredLength + " characters.";
                }
                if ('min' in errorObj) {
                    return "Minimum value allowed is " + errorObj.min.min;
                }
                if ('max' in errorObj) {
                    return "Maximum value allowed is " + errorObj.max.max;
                }
            }
            return null;
        };
        return CNSFormControlErrorPipe;
    }());
    CNSFormControlErrorPipe.decorators = [
        { type: i0.Pipe, args: [{
                    name: 'formControlError'
                },] }
    ];
    CNSFormControlErrorPipe.ctorParameters = function () { return [
        { type: CNSRegexService }
    ]; };

    var CNSTranslatePipe = /** @class */ (function () {
        function CNSTranslatePipe(translateService) {
            this.translateService = translateService;
        }
        CNSTranslatePipe.prototype.transform = function (key, args) {
            return key ? this.translateService.translateObj(key, args) : '';
        };
        return CNSTranslatePipe;
    }());
    CNSTranslatePipe.decorators = [
        { type: i0.Pipe, args: [{
                    name: 'translate'
                },] }
    ];
    CNSTranslatePipe.ctorParameters = function () { return [
        { type: CNSTranslateService }
    ]; };

    var AngularModules = [
        common.CommonModule,
        forms.FormsModule,
        forms.ReactiveFormsModule,
        i1.HttpClientModule
    ];
    var ThirdPartyModules = [
        ngBootstrap.NgbModule
    ];
    var Components = [];
    var Pipes = [
        CNSTranslatePipe,
        CNSFormControlErrorPipe,
        CNSDisplayValuePipe
    ];
    var Directives = [
        CNSTranslateDirective
    ];
    var CnsUiLibSharedModule = /** @class */ (function () {
        function CnsUiLibSharedModule() {
        }
        return CnsUiLibSharedModule;
    }());
    CnsUiLibSharedModule.decorators = [
        { type: i0.NgModule, args: [{
                    declarations: __spread(Components, Directives, Pipes),
                    imports: __spread(AngularModules, ThirdPartyModules),
                    providers: __spread(Pipes),
                    exports: __spread(AngularModules, ThirdPartyModules, Components, Pipes, Directives)
                },] }
    ];

    var TextareaComponent = /** @class */ (function () {
        function TextareaComponent(ngControl) {
            this.ngControl = ngControl;
            this.labelClass = '';
            this.captionClass = '';
            this.containerClass = 'col-md-12 form-group';
            this.rows = 10;
            this.errorClass = 'error';
            this.inputClass = 'form-control';
            if (!ngControl) {
                console.error('Invalid FormControl instance provided for cnsText');
            }
            else {
                this.ngControl.valueAccessor = this;
            }
        }
        Object.defineProperty(TextareaComponent.prototype, "value", {
            get: function () {
                return this._value;
            },
            set: function (val) {
                if (val !== this.value) {
                    this._value = val;
                    if (this.onChange) {
                        this.onChange(val);
                    }
                    if (this.onTouch) {
                        this.onTouch(val);
                    }
                }
            },
            enumerable: false,
            configurable: true
        });
        TextareaComponent.prototype.registerOnChange = function (fn) {
            this.onChange = fn;
        };
        TextareaComponent.prototype.registerOnTouched = function (fn) {
            this.onTouch = fn;
        };
        TextareaComponent.prototype.setDisabledState = function (value) {
            this.disabled = value;
        };
        TextareaComponent.prototype.writeValue = function (value) {
            this.value = value;
        };
        return TextareaComponent;
    }());
    TextareaComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-textarea',
                    template: "<div [ngClass]=\"containerClass\">\n    <span *ngIf='label' [ngClass]='labelClass'>{{ label | translate}}</span>\n    <textarea [rows]=\"rows\"\n              [formControl]='ngControl.control'\n              [id]=\"id || name || ngControl.name\"\n              placeholder=\"{{placeholder | translate}}\"\n              [ngClass]='[((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"), inputClass]'></textarea>\n              <span *ngIf='caption' [ngClass]='captionClass'>{{ caption | translate}}</span>\n</div>",
                    styles: [""]
                },] }
    ];
    TextareaComponent.ctorParameters = function () { return [
        { type: forms.NgControl, decorators: [{ type: i0.Self }, { type: i0.Optional }] }
    ]; };
    TextareaComponent.propDecorators = {
        labelClass: [{ type: i0.Input }],
        captionClass: [{ type: i0.Input }],
        containerClass: [{ type: i0.Input }],
        rows: [{ type: i0.Input }],
        errorClass: [{ type: i0.Input }],
        inputClass: [{ type: i0.Input }],
        name: [{ type: i0.Input }],
        id: [{ type: i0.Input }],
        placeholder: [{ type: i0.Input }],
        caption: [{ type: i0.Input }],
        label: [{ type: i0.Input }],
        value: [{ type: i0.Input }]
    };

    var TextComponent = /** @class */ (function (_super) {
        __extends(TextComponent, _super);
        function TextComponent() {
            var _this = _super.apply(this, __spread(arguments)) || this;
            _this.autocomplete = 'off';
            return _this;
        }
        TextComponent.prototype.focus = function () {
            this.inputField.nativeElement.focus();
        };
        return TextComponent;
    }(BaseFieldComponent));
    TextComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-text',
                    template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input #inputField [id]='id || name || ngControl.name'\n               [container]='container'\n               [autocomplete]='autocomplete'\n               [readonly]='readonly' type=\"text\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n               (readonly ? readOnlyClass: \"\"),\n                                   inputClass]'\n               (input)='onChange($event.target.value)'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <i class='inline-icon' [ngClass]='iconClass'></i>\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                    exportAs: 'cnsText',
                    styles: [".inline-icon{position:absolute;right:5px;top:6px}.label-container>span.label-help{float:right}"]
                },] }
    ];
    TextComponent.propDecorators = {
        autocomplete: [{ type: i0.Input }],
        inputField: [{ type: i0.ViewChild, args: ['inputField', { static: true },] }]
    };

    var SelectComponent = /** @class */ (function (_super) {
        __extends(SelectComponent, _super);
        function SelectComponent() {
            var _this = _super.apply(this, __spread(arguments)) || this;
            _this.searchEnabled = false;
            _this.divClass = 'btn-group w-100';
            _this.btnClass = 'btn btn-plain btn-select dropdown-toggle textEllipse error';
            _this.inputSearchClass = 'form-control';
            _this.listClass = 'dropdown-menu h-down';
            _this.clearIconClass = 'bi bi-x cursor-pointer';
            _this.caretClass = 'caret';
            _this.searchHostClass = 'search-host wrapper-xs';
            _this.compareKey = 'name'; // field to use for comparison from search field.
            _this.labelKey = 'name';
            _this.searchPlaceholder = 'common.select.search';
            // tslint:disable-next-line: variable-name
            _this._options = [];
            // value can be object or key in case of object list. Or a exact match in case of string list.
            _this.optionFormatter = function (options, listType, value, compareKey, valueKey) {
                var obj = null;
                if (value) {
                    if (listType === "object" /* object */) {
                        if (typeof value === 'string') {
                            var key_1 = valueKey || compareKey;
                            return (options || []).find(function (opt) { return opt[key_1] === value; });
                        }
                        else if (typeof value === 'object') {
                            return value;
                        }
                    }
                    else {
                        if (typeof value === 'object') {
                            return value;
                        }
                        else {
                            var key_2 = valueKey || compareKey;
                            return (options || []).find(function (opt) { return opt[key_2] === value; });
                        }
                    }
                }
                return obj;
            };
            _this.displayOptions = [];
            _this.disabled = false;
            return _this;
            // validate(control: AbstractControl) {
            //   return null;
            // }
        }
        Object.defineProperty(SelectComponent.prototype, "options", {
            get: function () {
                return this._options;
            },
            set: function (value) {
                var _this = this;
                rxjs.asyncScheduler.schedule(function () {
                    if (value && Array.isArray(value)) {
                        if (typeof value[0] === 'object') {
                            _this.listType = "object" /* object */;
                            _this._options = value;
                        }
                        else {
                            _this.listType = "string" /* string */;
                            _this._options = value.map(function (val) {
                                return { value: val, label: val };
                            });
                        }
                        _this.updateDisplayOptions(_this._options);
                        if (_this.value) {
                            // tslint:disable-next-line: max-line-length
                            _this.selectedOption = _this.selectedOption = _this.optionFormatter(_this.options, _this.listType, _this.value, _this.compareKey, _this.valueKey);
                        }
                    }
                }, 0);
            },
            enumerable: false,
            configurable: true
        });
        ;
        SelectComponent.prototype.valueFormatter = function (selectedOption, listType, valueKey) {
            return selectedOption ?
                listType === "string" /* string */ ? selectedOption.value :
                    (valueKey && typeof selectedOption === 'object') ? selectedOption[valueKey] : selectedOption : null;
        };
        Object.defineProperty(SelectComponent.prototype, "value", {
            get: function () {
                return this._val;
            },
            set: function (val) {
                if (this.onChange) {
                    this.onChange(val);
                }
                if (this.onTouch) {
                    this.onTouch(val);
                }
                this._val = val;
            },
            enumerable: false,
            configurable: true
        });
        SelectComponent.prototype.ngOnInit = function () {
            var _this = this;
            if (this.searchEnabled) {
                this.searchControl = new forms.FormControl('');
                this.searchControl.valueChanges.subscribe(function (value) {
                    _this.updateDisplayOptions(_this.options, value);
                });
            }
        };
        SelectComponent.prototype.clearSearch = function () {
            this.searchControl.patchValue('');
        };
        SelectComponent.prototype.registerOnChange = function (fn) {
            this.onChange = fn;
        };
        SelectComponent.prototype.registerOnTouched = function (fn) {
            this.onTouch = fn;
        };
        SelectComponent.prototype.setDisabledState = function (value) {
            this.disabled = value;
        };
        SelectComponent.prototype.writeValue = function (value) {
            this.selectedOption = this.optionFormatter(this.options, this.listType, value, this.compareKey, this.valueKey);
            this.value = this.valueFormatter(this.selectedOption || value, this.listType, this.valueKey);
        };
        SelectComponent.prototype.toggleDropdown = function () {
            if (this.searchEnabled) {
                this.clearSearchData();
            }
        };
        SelectComponent.prototype.clearSearchData = function () {
            var _this = this;
            if (this.searchEnabled) {
                this.searchControl.patchValue('');
                if (this.inputField) {
                    var scheduledFocus_1 = rxjs.asapScheduler.schedule(function () {
                        _this.inputField.nativeElement.focus();
                        scheduledFocus_1.unsubscribe();
                    });
                }
            }
        };
        SelectComponent.prototype.updateDisplayOptions = function (options, filterText) {
            var _this = this;
            if (filterText === void 0) { filterText = ''; }
            this.displayOptions = options.filter(function (opt) { return opt[_this.compareKey].toLowerCase().indexOf(filterText.toLowerCase()) >= 0; });
        };
        SelectComponent.prototype.setSelection = function (event, option) {
            event.stopPropagation();
            this.writeValue(option);
        };
        SelectComponent.prototype.onBlur = function () {
            this.ngControl.control.markAsTouched();
        };
        return SelectComponent;
    }(BaseFieldComponent));
    SelectComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-select',
                    template: "<div [ngClass]='containerClass'>\n  <label [ngClass]='labelClass'>\n    <span *ngIf='label'>{{ label | translate}}</span>\n  </label>\n  <div ngbDropdown [container]='container' [ngClass]='divClass' (openChange)=\"toggleDropdown()\">\n    <button [ngbTooltip]='ngControl.control?.errors | formControlError | translate' ngbDropdownToggle type='button'\n            [ngClass]='[((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n            (readonly ? readOnlyClass: \"\"), btnClass]' [disabled]='disabled' (blur)='onBlur()'>\n      {{ selectedOption | displayValue: {keys: labelKey} | translate}}\n      <span [ngClass]=\"caretClass\"></span>\n    </button>\n    <ul ngbDropdownMenu [ngClass]='listClass'>\n      <li *ngIf='searchEnabled' [ngClass]='searchHostClass'>\n        <input autocomplete=\"off\" #searchInput type=\"text\" [ngClass]=\"inputSearchClass\" [formControl]='searchControl' placeholder=\"{{searchPlaceholder | translate}}\" autofocus />\n        <i *ngIf=\"searchInput.value\" [ngClass]='clearIconClass' (click)=\"clearSearchData()\"></i>\n      </li>\n      <li *ngFor=\"let option of displayOptions\" [class.selected]='selectedOption && option[compareKey] === selectedOption[compareKey]'>\n        <a ngbDropdownItem (click)=\"setSelection($event,option)\">{{option | displayValue: {keys: labelKey} | translate}}</a>\n      </li>\n    </ul>\n  </div>\n</div>",
                    exportAs: 'cnsSelect',
                    styles: [""]
                },] }
    ];
    SelectComponent.propDecorators = {
        searchEnabled: [{ type: i0.Input }],
        divClass: [{ type: i0.Input }],
        btnClass: [{ type: i0.Input }],
        inputSearchClass: [{ type: i0.Input }],
        listClass: [{ type: i0.Input }],
        clearIconClass: [{ type: i0.Input }],
        caretClass: [{ type: i0.Input }],
        searchHostClass: [{ type: i0.Input }],
        compareKey: [{ type: i0.Input }],
        valueKey: [{ type: i0.Input }],
        labelKey: [{ type: i0.Input }],
        label: [{ type: i0.Input }],
        searchPlaceholder: [{ type: i0.Input }],
        options: [{ type: i0.Input }],
        optionFormatter: [{ type: i0.Input }],
        valueFormatter: [{ type: i0.Input }],
        inputField: [{ type: i0.ViewChild, args: ['searchInput', { static: false, read: i0.ElementRef },] }]
    };

    var CheckboxComponent = /** @class */ (function (_super) {
        __extends(CheckboxComponent, _super);
        function CheckboxComponent() {
            var _this = _super.apply(this, __spread(arguments)) || this;
            _this.checked = false;
            _this.containerClass = 'form-group checkbox';
            _this.fieldClass = 'i-checks i-checks-sm';
            _this.labelClass = '';
            _this.ngTrueValue = true;
            _this.ngFalseValue = false;
            return _this;
        }
        CheckboxComponent.prototype.emitChange = function (event) {
            var value = event.currentTarget.checked ? this.ngTrueValue : this.ngFalseValue;
            this.onChange(value);
            this.writeValue(value);
        };
        CheckboxComponent.prototype.writeValue = function (value) {
            var _this = this;
            this.subscriptions.push(rxjs.asyncScheduler.schedule(function () {
                _this.checked = (value === _this.ngTrueValue);
                _this.value = _this.checked ? _this.ngTrueValue : _this.ngFalseValue;
            }));
        };
        return CheckboxComponent;
    }(BaseFieldComponent));
    CheckboxComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-checkbox',
                    template: "<div [ngClass]=\"containerClass\">\n  <label [ngClass]='fieldClass'>\n    <input [id]=\"id || name || ngControl.name\" type=\"checkbox\" [checked]='checked' (change)='emitChange($event)' [disabled]='disabled'/><i></i>\n    <span>\n      <span>\n        <span [ngClass]='labelClass'>{{ label | translate}}</span>\n        <ng-content select='[container=middle]'></ng-content>\n        <span class=\"helpText\">{{ description | translate}}</span>\n      </span>\n      <ng-content></ng-content>\n    </span>\n  </label>\n</div>",
                    exportAs: 'cnsCheckbox',
                    styles: [""]
                },] }
    ];
    CheckboxComponent.propDecorators = {
        containerClass: [{ type: i0.Input }],
        fieldClass: [{ type: i0.Input }],
        labelClass: [{ type: i0.Input }],
        ngTrueValue: [{ type: i0.Input }],
        ngFalseValue: [{ type: i0.Input }]
    };

    var RadioGroupComponent = /** @class */ (function (_super) {
        __extends(RadioGroupComponent, _super);
        function RadioGroupComponent() {
            var _this = _super.apply(this, __spread(arguments)) || this;
            _this.labelClass = 'col-md-12 no-padder';
            _this.fieldLabelClass = 'i-checks i-checks-sm';
            _this.fieldClass = 'radio inline';
            return _this;
        }
        return RadioGroupComponent;
    }(BaseFieldComponent));
    RadioGroupComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-radio-group',
                    template: "<div [ngClass]='containerClass'>\n    <label [ngClass]='labelClass' *ngIf='label'>{{ label | translate}}</label>\n    <ng-container *ngFor='let option of options'>\n        <div [ngClass]='fieldClass'>\n            <label [ngClass]=\"fieldLabelClass\">\n                <input [name]='name || id || ngControl.name' type=\"radio\" [value]='option?.value' [formControl]='ngControl.control'>\n                <i></i>\n                <span>{{ option?.label | translate }}</span>\n            </label>\n        </div>\n    </ng-container>\n    <span [class]='helpTextClass'>{{description | translate}}</span>\n</div>",
                    exportAs: 'cnsRadioGroup',
                    styles: [""]
                },] }
    ];
    RadioGroupComponent.propDecorators = {
        options: [{ type: i0.Input }],
        labelClass: [{ type: i0.Input }],
        fieldLabelClass: [{ type: i0.Input }],
        fieldClass: [{ type: i0.Input }]
    };

    var PasswordComponent = /** @class */ (function (_super) {
        __extends(PasswordComponent, _super);
        function PasswordComponent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        PasswordComponent.prototype.focus = function () {
            this.inputField.nativeElement.focus();
        };
        return PasswordComponent;
    }(BaseFieldComponent));
    PasswordComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-password',
                    template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input #inputField [id]='id || name || ngControl.name'\n               [container]='container'\n               type=\"password\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n                                   inputClass]'\n               (input)='onChange($event.target.value)'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                    styles: [".label-container>span.label-help{float:right}"]
                },] }
    ];
    PasswordComponent.propDecorators = {
        inputField: [{ type: i0.ViewChild, args: ['inputField', { static: true },] }]
    };

    var InputPasswordComponent = /** @class */ (function (_super) {
        __extends(InputPasswordComponent, _super);
        function InputPasswordComponent() {
            var _this = _super.apply(this, __spread(arguments)) || this;
            _this.helpTextClass = 'helpText m-t-xs';
            _this.inputClass = 'form-control p-r-50';
            _this.hideClass = 'h-phrase';
            _this.showClass = 's-phrase';
            _this.hideIconClass = 'bi bi-eye-slash-fill';
            _this.showIconClass = 'bi bi-eye-fill';
            _this.showText = true;
            _this.inlineButtonBgClass = 'pos-abt t-phrase text-center r';
            _this.hideCharactersLabel = 'common.hide';
            _this.showCharactersLabel = 'common.show';
            _this.hideCharactersTitle = 'common.hideChars';
            _this.showCharactersTitle = 'common.showChars';
            return _this;
        }
        InputPasswordComponent.prototype.toggle = function (input) {
            input.type = input.type === "password" ? "text" : "password";
        };
        return InputPasswordComponent;
    }(BaseFieldComponent));
    InputPasswordComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-input-password',
                    template: "<div [ngClass]=\"containerClass\">\n  <label [ngClass]=\"labelClass\" *ngIf='label'>\n    <span> {{ label | translate:translateValues }}</span>\n  </label>\n  <ng-content></ng-content>\n  <div [ngClass]=\"fieldClass\">\n    <input #input type=\"password\" [formControl]=\"ngControl.control\"\n           [container]='container'\n           [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n           [class.error]='ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)'\n           [ngClass]=\"inputClass\" (input)='onChange($event.target.value)' [name]=\"name\">\n    <i *ngIf='!showText' class='inline-icon' [ngClass]=\"input.type === 'text' ? hideIconClass : showIconClass\" (click)='toggle(input)'></i>\n    <span *ngIf='showText' [ngClass]=\"inlineButtonBgClass\" title=\"{{(input.type === 'text' ? hideCharactersTitle : showCharactersTitle) | translate}}\"\n          (click)='toggle(input)'\n          [ngClass]=\"input.type === 'text' ? hideClass : showClass\">\n      {{(input.type === 'text' ? hideCharactersLabel : showCharactersLabel) | translate}}\n    </span>\n  </div>\n  <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n    <ng-content select='[helpTextContent]'></ng-content>\n    <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n  </div>\n</div>",
                    styles: [".inline-icon{cursor:pointer;position:absolute;right:15px;top:6px}"]
                },] }
    ];
    InputPasswordComponent.propDecorators = {
        helpTextClass: [{ type: i0.Input }],
        inputClass: [{ type: i0.Input }],
        hideClass: [{ type: i0.Input }],
        showClass: [{ type: i0.Input }],
        hideIconClass: [{ type: i0.Input }],
        showIconClass: [{ type: i0.Input }],
        showText: [{ type: i0.Input }],
        inlineButtonBgClass: [{ type: i0.Input }],
        hideCharactersLabel: [{ type: i0.Input }],
        showCharactersLabel: [{ type: i0.Input }],
        hideCharactersTitle: [{ type: i0.Input }],
        showCharactersTitle: [{ type: i0.Input }]
    };

    var NumberComponent = /** @class */ (function (_super) {
        __extends(NumberComponent, _super);
        function NumberComponent() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return NumberComponent;
    }(BaseFieldComponent));
    NumberComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-number',
                    template: "<div [ngClass]=\"containerClass\">\n    <div [ngClass]=\"labelContainerClass\">\n        <label [ngClass]=\"labelClass\" *ngIf='label'>\n            <span>{{ label | translate }} </span>\n        </label>\n        <span [ngClass]='labelHelpClass'>\n            <ng-content select=\"[labelHelpContent]\"></ng-content>\n        </span>\n    </div>\n    <div [ngClass]=\"fieldClass\">\n        <input [id]='id || name || ngControl.name'\n               [container]='container'\n               type=\"number\" [formControl]=\"ngControl.control\"\n               [ngbTooltip]='ngControl.control?.errors | formControlError | translate'\n               [ngClass]='[\n               ((ngControl.control?.errors && (ngControl.control?.dirty || ngControl.control?.touched)) ? errorClass: \"\"),\n                                   inputClass]'\n               placeholder='{{placeholder}}' [name]=\"name\">\n        <ng-content select=\"[inputFieldContent]\"></ng-content>\n    </div>\n    <div *ngIf='description || helpTextContent' [ngClass]='helpTextClass'>\n        <ng-content select='[helpTextContent]'></ng-content>\n        <span *ngIf='description' [ngClass]='descriptionClass'>{{ description | translate}}</span>\n    </div>\n</div>",
                    styles: [".label-container>span.label-help{float:right}"]
                },] }
    ];

    (function (FileInputErrors) {
        FileInputErrors[FileInputErrors["invalidExtension"] = 0] = "invalidExtension";
        FileInputErrors[FileInputErrors["invalidFileName"] = 1] = "invalidFileName";
    })(exports.FileInputErrors || (exports.FileInputErrors = {}));
    var FileInputComponent = /** @class */ (function () {
        function FileInputComponent() {
            this.id = 'fileInputField';
            this.extensions = [];
            this.buttonLabel = 'common.SelectFile';
            this.label = 'common.File';
            this.containerClass = 'input-group';
            this.labelClass = 'control-label';
            this.fileNameClass = 'form-control';
            this.fieldClass = 'col-md-12 p-0';
            this.btnWrapperClass = 'input-group-append';
            this.btnClass = 'input-group-text';
            this.error = new i0.EventEmitter();
            this.fileChange = new i0.EventEmitter();
        }
        FileInputComponent.prototype.onFileChange = function (event) {
            var files = event.target.files;
            if (files && files.length) {
                this.selectedFile = files[0];
                var parts = this.selectedFile.name.split('.');
                var fileExtension = parts[parts.length - 1];
                if (this.extensions.length && this.extensions.indexOf(fileExtension) === -1) {
                    this.emitError(exports.FileInputErrors.invalidExtension);
                }
                else if (this.fileNameRegex && !this.fileNameRegex.test(this.selectedFile.name)) {
                    this.emitError(exports.FileInputErrors.invalidFileName);
                }
                else {
                    this.fileChange.emit({
                        file: this.selectedFile
                    });
                }
            }
            else {
                this.resetSelectedFile();
            }
        };
        FileInputComponent.prototype.emitError = function (error) {
            this.error.emit(error);
            this.resetSelectedFile();
        };
        FileInputComponent.prototype.resetSelectedFile = function () {
            this.selectedFile = undefined;
            this.fileInput.nativeElement.value = '';
        };
        return FileInputComponent;
    }());
    FileInputComponent.decorators = [
        { type: i0.Component, args: [{
                    selector: 'cns-file-input',
                    template: "<div [ngClass]='containerClass'>\n    <label [ngClass]='labelClass'>{{ label | translate }}</label>\n    <div [ngClass]='fieldClass'>\n        <label [ngClass]=\"fileNameClass\" for=\"fileText\">{{selectedFile?.name}}</label>\n        <span [ngClass]=\"btnWrapperClass\" (click)='fileInput.click()'>\n            <span [ngClass]='btnClass'>{{buttonLabel | translate}}</span>\n            <input [id]='id' #fileInput type=\"file\" name=\"fileUpload\" [ngStyle]='{display:\"none\"}' (change)='onFileChange($event)' />\n        </span>\n    </div>\n</div>"
                },] }
    ];
    FileInputComponent.ctorParameters = function () { return []; };
    FileInputComponent.propDecorators = {
        fileChange: [{ type: i0.Output }],
        error: [{ type: i0.Output }],
        id: [{ type: i0.Input }],
        fileNameRegex: [{ type: i0.Input }],
        extensions: [{ type: i0.Input }],
        buttonLabel: [{ type: i0.Input }],
        label: [{ type: i0.Input }],
        containerClass: [{ type: i0.Input }],
        labelClass: [{ type: i0.Input }],
        fileNameClass: [{ type: i0.Input }],
        fieldClass: [{ type: i0.Input }],
        btnWrapperClass: [{ type: i0.Input }],
        btnClass: [{ type: i0.Input }],
        fileInput: [{ type: i0.ViewChild, args: ['fileInput', { static: true },] }]
    };

    var Components$1 = [
        TextareaComponent,
        TextComponent,
        SelectComponent,
        CheckboxComponent,
        RadioGroupComponent,
        PasswordComponent,
        InputPasswordComponent,
        NumberComponent,
        FileInputComponent,
        BaseFieldComponent
    ];
    var CnsFormFieldsModule = /** @class */ (function () {
        function CnsFormFieldsModule() {
        }
        return CnsFormFieldsModule;
    }());
    CnsFormFieldsModule.decorators = [
        { type: i0.NgModule, args: [{
                    declarations: __spread(Components$1),
                    imports: [
                        CnsUiLibSharedModule
                    ],
                    exports: __spread([
                        CnsUiLibSharedModule
                    ], Components$1)
                },] }
    ];

    var Modules = [
        CnsUiLibSharedModule,
        CnsFormFieldsModule
    ];
    var CnsUiLibModule = /** @class */ (function () {
        function CnsUiLibModule() {
        }
        return CnsUiLibModule;
    }());
    CnsUiLibModule.decorators = [
        { type: i0.NgModule, args: [{
                    imports: __spread(Modules),
                    exports: __spread(Modules),
                    declarations: []
                },] }
    ];

    /**
     * Generated bundle index. Do not edit.
     */

    exports.BaseFieldComponent = BaseFieldComponent;
    exports.CNSDisplayValuePipe = CNSDisplayValuePipe;
    exports.CNSFormControlErrorPipe = CNSFormControlErrorPipe;
    exports.CNSI18nService = CNSI18nService;
    exports.CNSRegexService = CNSRegexService;
    exports.CNSTranslateDirective = CNSTranslateDirective;
    exports.CNSTranslatePipe = CNSTranslatePipe;
    exports.CNSTranslateService = CNSTranslateService;
    exports.CheckboxComponent = CheckboxComponent;
    exports.CnsFormFieldsModule = CnsFormFieldsModule;
    exports.CnsUiLibModule = CnsUiLibModule;
    exports.CnsUiLibSharedModule = CnsUiLibSharedModule;
    exports.FileInputComponent = FileInputComponent;
    exports.InputPasswordComponent = InputPasswordComponent;
    exports.NumberComponent = NumberComponent;
    exports.PasswordComponent = PasswordComponent;
    exports.RadioGroupComponent = RadioGroupComponent;
    exports.SelectComponent = SelectComponent;
    exports.TextComponent = TextComponent;
    exports.TextareaComponent = TextareaComponent;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=cambium-cns-ui-lib.umd.js.map
