/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { BrowserModule, platformBrowser } from './browser';
export { Meta } from './browser/meta';
export { Title } from './browser/title';
export { disableDebugTools, enableDebugTools } from './browser/tools/tools';
export { BrowserTransferStateModule, makeStateKey, TransferState } from './browser/transfer_state';
export { By } from './dom/debug/by';
export { EVENT_MANAGER_PLUGINS, EventManager } from './dom/events/event_manager';
export { HAMMER_GESTURE_CONFIG, HAMMER_LOADER, HAMMER_PROVIDERS__POST_R3__ as ɵHAMMER_PROVIDERS__POST_R3__, HammerGestureConfig, HammerModule } from './dom/events/hammer_gestures';
export { DomSanitizer } from './security/dom_sanitization_service';
export * from './private_export';
export { VERSION } from './version';
// This must be exported so it doesn't get tree-shaken away prematurely
export { ELEMENT_PROBE_PROVIDERS__POST_R3__ as ɵELEMENT_PROBE_PROVIDERS__POST_R3__ } from './dom/debug/ng_probe';
//# sourceMappingURL=data:application/json;base64,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