import { MessageId, TargetMessage } from './utils';
/**
 * Load translations for `$localize`.
 *
 * The given `translations` are processed and added to a lookup based on their `MessageId`.
 * A new translation will overwrite a previous translation if it has the same `MessageId`.
 *
 * * If a message is generated by the Angular compiler from an `i18n` marker in a template, the
 *   `MessageId` is passed through to the `$localize` call as a custom `MessageId`. The `MessageId`
 *   will match what is extracted into translation files.
 *
 * * If the translation is from a call to `$localize` in application code, and no custom `MessageId`
 *   is provided, then the `MessageId` can be generated by passing the tagged string message-parts
 *   to the `parseMessage()` function (not currently public API).
 *
 * @publicApi
 *
 */
export declare function loadTranslations(translations: Record<MessageId, TargetMessage>): void;
/**
 * Remove all translations for `$localize`.
 *
 * @publicApi
 */
export declare function clearTranslations(): void;
/**
 * Translate the text of the given message, using the loaded translations.
 *
 * This function may reorder (or remove) substitutions as indicated in the matching translation.
 */
export declare function translate(messageParts: TemplateStringsArray, substitutions: readonly any[]): [
    TemplateStringsArray,
    readonly any[]
];
