/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { getDebugContext } from '../errors';
import { ERROR_DEBUG_CONTEXT, ERROR_LOGGER } from '../util/errors';
export function expressionChangedAfterItHasBeenCheckedError(context, oldValue, currValue, isFirstCheck) {
    let msg = `ExpressionChangedAfterItHasBeenCheckedError: Expression has changed after it was checked. Previous value: '${oldValue}'. Current value: '${currValue}'.`;
    if (isFirstCheck) {
        msg +=
            ` It seems like the view has been created after its parent and its children have been dirty checked.` +
                ` Has it been created in a change detection hook ?`;
    }
    return viewDebugError(msg, context);
}
export function viewWrappedDebugError(err, context) {
    if (!(err instanceof Error)) {
        // errors that are not Error instances don't have a stack,
        // so it is ok to wrap them into a new Error object...
        err = new Error(err.toString());
    }
    _addDebugContext(err, context);
    return err;
}
export function viewDebugError(msg, context) {
    const err = new Error(msg);
    _addDebugContext(err, context);
    return err;
}
function _addDebugContext(err, context) {
    err[ERROR_DEBUG_CONTEXT] = context;
    err[ERROR_LOGGER] = context.logError.bind(context);
}
export function isViewDebugError(err) {
    return !!getDebugContext(err);
}
export function viewDestroyedError(action) {
    return new Error(`ViewDestroyedError: Attempt to use a destroyed view: ${action}`);
}
//# sourceMappingURL=data:application/json;base64,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