/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { assertDefined, assertEqual } from '../util/assert';
import { TNodeTypeAsString } from './interfaces/node';
export function assertNodeType(tNode, type) {
    assertDefined(tNode, 'should be called with a TNode');
    assertEqual(tNode.type, type, `should be a ${typeName(type)}`);
}
export function assertNodeOfPossibleTypes(tNode, types, message) {
    assertDefined(tNode, 'should be called with a TNode');
    const found = types.some(type => tNode.type === type);
    assertEqual(found, true, message !== null && message !== void 0 ? message : `Should be one of ${types.map(typeName).join(', ')} but got ${typeName(tNode.type)}`);
}
export function assertNodeNotOfTypes(tNode, types, message) {
    assertDefined(tNode, 'should be called with a TNode');
    const found = types.some(type => tNode.type === type);
    assertEqual(found, false, message !== null && message !== void 0 ? message : `Should not be one of ${types.map(typeName).join(', ')} but got ${typeName(tNode.type)}`);
}
function typeName(type) {
    return TNodeTypeAsString[type] || '<unknown>';
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibm9kZV9hc3NlcnQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb3JlL3NyYy9yZW5kZXIzL25vZGVfYXNzZXJ0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQUVILE9BQU8sRUFBQyxhQUFhLEVBQUUsV0FBVyxFQUFDLE1BQU0sZ0JBQWdCLENBQUM7QUFFMUQsT0FBTyxFQUEyRixpQkFBaUIsRUFBa0IsTUFBTSxtQkFBbUIsQ0FBQztBQVkvSixNQUFNLFVBQVUsY0FBYyxDQUFDLEtBQVksRUFBRSxJQUFlO0lBQzFELGFBQWEsQ0FBQyxLQUFLLEVBQUUsK0JBQStCLENBQUMsQ0FBQztJQUN0RCxXQUFXLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUUsZUFBZSxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBQ2pFLENBQUM7QUFFRCxNQUFNLFVBQVUseUJBQXlCLENBQ3JDLEtBQWlCLEVBQUUsS0FBa0IsRUFBRSxPQUFnQjtJQUN6RCxhQUFhLENBQUMsS0FBSyxFQUFFLCtCQUErQixDQUFDLENBQUM7SUFDdEQsTUFBTSxLQUFLLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxJQUFJLEtBQUssSUFBSSxDQUFDLENBQUM7SUFDdEQsV0FBVyxDQUNQLEtBQUssRUFBRSxJQUFJLEVBQ1gsT0FBTyxhQUFQLE9BQU8sY0FBUCxPQUFPLEdBQ0gsb0JBQW9CLEtBQUssQ0FBQyxHQUFHLENBQUMsUUFBUSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxZQUFZLFFBQVEsQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0FBQ2hHLENBQUM7QUFFRCxNQUFNLFVBQVUsb0JBQW9CLENBQUMsS0FBWSxFQUFFLEtBQWtCLEVBQUUsT0FBZ0I7SUFDckYsYUFBYSxDQUFDLEtBQUssRUFBRSwrQkFBK0IsQ0FBQyxDQUFDO0lBQ3RELE1BQU0sS0FBSyxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsSUFBSSxLQUFLLElBQUksQ0FBQyxDQUFDO0lBQ3RELFdBQVcsQ0FDUCxLQUFLLEVBQUUsS0FBSyxFQUNaLE9BQU8sYUFBUCxPQUFPLGNBQVAsT0FBTyxHQUNILHdCQUF3QixLQUFLLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBWSxRQUFRLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQztBQUNwRyxDQUFDO0FBRUQsU0FBUyxRQUFRLENBQUMsSUFBZTtJQUMvQixPQUFPLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLFdBQVcsQ0FBQztBQUNoRCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7YXNzZXJ0RGVmaW5lZCwgYXNzZXJ0RXF1YWx9IGZyb20gJy4uL3V0aWwvYXNzZXJ0JztcblxuaW1wb3J0IHtUQ29udGFpbmVyTm9kZSwgVEVsZW1lbnRDb250YWluZXJOb2RlLCBURWxlbWVudE5vZGUsIFRJY3VDb250YWluZXJOb2RlLCBUTm9kZSwgVE5vZGVUeXBlLCBUTm9kZVR5cGVBc1N0cmluZywgVFByb2plY3Rpb25Ob2RlfSBmcm9tICcuL2ludGVyZmFjZXMvbm9kZSc7XG5cbmV4cG9ydCBmdW5jdGlvbiBhc3NlcnROb2RlVHlwZShcbiAgICB0Tm9kZTogVE5vZGUsIHR5cGU6IFROb2RlVHlwZS5Db250YWluZXIpOiBhc3NlcnRzIHROb2RlIGlzIFRDb250YWluZXJOb2RlO1xuZXhwb3J0IGZ1bmN0aW9uIGFzc2VydE5vZGVUeXBlKFxuICAgIHROb2RlOiBUTm9kZSwgdHlwZTogVE5vZGVUeXBlLkVsZW1lbnQpOiBhc3NlcnRzIHROb2RlIGlzIFRFbGVtZW50Tm9kZTtcbmV4cG9ydCBmdW5jdGlvbiBhc3NlcnROb2RlVHlwZShcbiAgICB0Tm9kZTogVE5vZGUsIHR5cGU6IFROb2RlVHlwZS5FbGVtZW50Q29udGFpbmVyKTogYXNzZXJ0cyB0Tm9kZSBpcyBURWxlbWVudENvbnRhaW5lck5vZGU7XG5leHBvcnQgZnVuY3Rpb24gYXNzZXJ0Tm9kZVR5cGUoXG4gICAgdE5vZGU6IFROb2RlLCB0eXBlOiBUTm9kZVR5cGUuSWN1Q29udGFpbmVyKTogYXNzZXJ0cyB0Tm9kZSBpcyBUSWN1Q29udGFpbmVyTm9kZTtcbmV4cG9ydCBmdW5jdGlvbiBhc3NlcnROb2RlVHlwZShcbiAgICB0Tm9kZTogVE5vZGUsIHR5cGU6IFROb2RlVHlwZS5Qcm9qZWN0aW9uKTogYXNzZXJ0cyB0Tm9kZSBpcyBUUHJvamVjdGlvbk5vZGU7XG5leHBvcnQgZnVuY3Rpb24gYXNzZXJ0Tm9kZVR5cGUodE5vZGU6IFROb2RlLCB0eXBlOiBUTm9kZVR5cGUpOiBhc3NlcnRzIHROb2RlIGlzIFROb2RlIHtcbiAgYXNzZXJ0RGVmaW5lZCh0Tm9kZSwgJ3Nob3VsZCBiZSBjYWxsZWQgd2l0aCBhIFROb2RlJyk7XG4gIGFzc2VydEVxdWFsKHROb2RlLnR5cGUsIHR5cGUsIGBzaG91bGQgYmUgYSAke3R5cGVOYW1lKHR5cGUpfWApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXNzZXJ0Tm9kZU9mUG9zc2libGVUeXBlcyhcbiAgICB0Tm9kZTogVE5vZGV8bnVsbCwgdHlwZXM6IFROb2RlVHlwZVtdLCBtZXNzYWdlPzogc3RyaW5nKTogdm9pZCB7XG4gIGFzc2VydERlZmluZWQodE5vZGUsICdzaG91bGQgYmUgY2FsbGVkIHdpdGggYSBUTm9kZScpO1xuICBjb25zdCBmb3VuZCA9IHR5cGVzLnNvbWUodHlwZSA9PiB0Tm9kZS50eXBlID09PSB0eXBlKTtcbiAgYXNzZXJ0RXF1YWwoXG4gICAgICBmb3VuZCwgdHJ1ZSxcbiAgICAgIG1lc3NhZ2UgPz9cbiAgICAgICAgICBgU2hvdWxkIGJlIG9uZSBvZiAke3R5cGVzLm1hcCh0eXBlTmFtZSkuam9pbignLCAnKX0gYnV0IGdvdCAke3R5cGVOYW1lKHROb2RlLnR5cGUpfWApO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXNzZXJ0Tm9kZU5vdE9mVHlwZXModE5vZGU6IFROb2RlLCB0eXBlczogVE5vZGVUeXBlW10sIG1lc3NhZ2U/OiBzdHJpbmcpOiB2b2lkIHtcbiAgYXNzZXJ0RGVmaW5lZCh0Tm9kZSwgJ3Nob3VsZCBiZSBjYWxsZWQgd2l0aCBhIFROb2RlJyk7XG4gIGNvbnN0IGZvdW5kID0gdHlwZXMuc29tZSh0eXBlID0+IHROb2RlLnR5cGUgPT09IHR5cGUpO1xuICBhc3NlcnRFcXVhbChcbiAgICAgIGZvdW5kLCBmYWxzZSxcbiAgICAgIG1lc3NhZ2UgPz9cbiAgICAgICAgICBgU2hvdWxkIG5vdCBiZSBvbmUgb2YgJHt0eXBlcy5tYXAodHlwZU5hbWUpLmpvaW4oJywgJyl9IGJ1dCBnb3QgJHt0eXBlTmFtZSh0Tm9kZS50eXBlKX1gKTtcbn1cblxuZnVuY3Rpb24gdHlwZU5hbWUodHlwZTogVE5vZGVUeXBlKTogc3RyaW5nIHtcbiAgcmV0dXJuIFROb2RlVHlwZUFzU3RyaW5nW3R5cGVdIHx8ICc8dW5rbm93bj4nO1xufVxuIl19