/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
// Below are constants for LView indices to help us look up LView members
// without having to remember the specific indices.
// Uglify will inline these when minifying so there shouldn't be a cost.
export const HOST = 0;
export const TVIEW = 1;
export const FLAGS = 2;
export const PARENT = 3;
export const NEXT = 4;
export const TRANSPLANTED_VIEWS_TO_REFRESH = 5;
export const T_HOST = 6;
export const CLEANUP = 7;
export const CONTEXT = 8;
export const INJECTOR = 9;
export const RENDERER_FACTORY = 10;
export const RENDERER = 11;
export const SANITIZER = 12;
export const CHILD_HEAD = 13;
export const CHILD_TAIL = 14;
// FIXME(misko): Investigate if the three declarations aren't all same thing.
export const DECLARATION_VIEW = 15;
export const DECLARATION_COMPONENT_VIEW = 16;
export const DECLARATION_LCONTAINER = 17;
export const PREORDER_HOOK_FLAGS = 18;
export const QUERIES = 19;
/** Size of LView's header. Necessary to adjust for it when setting slots.  */
export const HEADER_OFFSET = 20;
/**
 * Converts `TViewType` into human readable text.
 * Make sure this matches with `TViewType`
 */
export const TViewTypeAsString = [
    'Root',
    'Component',
    'Embedded',
];
// Note: This hack is necessary so we don't erroneously get a circular dependency
// failure based on types.
export const unusedValueExportToPlacateAjd = 1;
//# sourceMappingURL=data:application/json;base64,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