/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/transformers/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.EmitFlags = exports.isNgDiagnostic = exports.isTsDiagnostic = exports.SOURCE = exports.UNKNOWN_ERROR_CODE = exports.DEFAULT_ERROR_CODE = void 0;
    exports.DEFAULT_ERROR_CODE = 100;
    exports.UNKNOWN_ERROR_CODE = 500;
    exports.SOURCE = 'angular';
    function isTsDiagnostic(diagnostic) {
        return diagnostic != null && diagnostic.source !== 'angular';
    }
    exports.isTsDiagnostic = isTsDiagnostic;
    function isNgDiagnostic(diagnostic) {
        return diagnostic != null && diagnostic.source === 'angular';
    }
    exports.isNgDiagnostic = isNgDiagnostic;
    var EmitFlags;
    (function (EmitFlags) {
        EmitFlags[EmitFlags["DTS"] = 1] = "DTS";
        EmitFlags[EmitFlags["JS"] = 2] = "JS";
        EmitFlags[EmitFlags["Metadata"] = 4] = "Metadata";
        EmitFlags[EmitFlags["I18nBundle"] = 8] = "I18nBundle";
        EmitFlags[EmitFlags["Codegen"] = 16] = "Codegen";
        EmitFlags[EmitFlags["Default"] = 19] = "Default";
        EmitFlags[EmitFlags["All"] = 31] = "All";
    })(EmitFlags = exports.EmitFlags || (exports.EmitFlags = {}));
});
//# sourceMappingURL=data:application/json;base64,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