/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/typecheck/api/checker", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.OptimizeFor = void 0;
    /**
     * Describes the scope of the caller's interest in template type-checking results.
     */
    var OptimizeFor;
    (function (OptimizeFor) {
        /**
         * Indicates that a consumer of a `TemplateTypeChecker` is only interested in results for a given
         * file, and wants them as fast as possible.
         *
         * Calling `TemplateTypeChecker` methods successively for multiple files while specifying
         * `OptimizeFor.SingleFile` can result in significant unnecessary overhead overall.
         */
        OptimizeFor[OptimizeFor["SingleFile"] = 0] = "SingleFile";
        /**
         * Indicates that a consumer of a `TemplateTypeChecker` intends to query for results pertaining to
         * the entire user program, and so the type-checker should internally optimize for this case.
         *
         * Initial calls to retrieve type-checking information may take longer, but repeated calls to
         * gather information for the whole user program will be significantly faster with this mode of
         * optimization.
         */
        OptimizeFor[OptimizeFor["WholeProgram"] = 1] = "WholeProgram";
    })(OptimizeFor = exports.OptimizeFor || (exports.OptimizeFor = {}));
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hlY2tlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3BhY2thZ2VzL2NvbXBpbGVyLWNsaS9zcmMvbmd0c2MvdHlwZWNoZWNrL2FwaS9jaGVja2VyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRzs7Ozs7Ozs7Ozs7OztJQTJFSDs7T0FFRztJQUNILElBQVksV0FtQlg7SUFuQkQsV0FBWSxXQUFXO1FBQ3JCOzs7Ozs7V0FNRztRQUNILHlEQUFVLENBQUE7UUFFVjs7Ozs7OztXQU9HO1FBQ0gsNkRBQVksQ0FBQTtJQUNkLENBQUMsRUFuQlcsV0FBVyxHQUFYLG1CQUFXLEtBQVgsbUJBQVcsUUFtQnRCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7UGFyc2VFcnJvciwgVG1wbEFzdE5vZGV9IGZyb20gJ0Bhbmd1bGFyL2NvbXBpbGVyJztcbmltcG9ydCAqIGFzIHRzIGZyb20gJ3R5cGVzY3JpcHQnO1xuXG4vKipcbiAqIEludGVyZmFjZSB0byB0aGUgQW5ndWxhciBUZW1wbGF0ZSBUeXBlIENoZWNrZXIgdG8gZXh0cmFjdCBkaWFnbm9zdGljcyBhbmQgaW50ZWxsaWdlbmNlIGZyb20gdGhlXG4gKiBjb21waWxlcidzIHVuZGVyc3RhbmRpbmcgb2YgY29tcG9uZW50IHRlbXBsYXRlcy5cbiAqXG4gKiBUaGlzIGludGVyZmFjZSBpcyBhbmFsb2dvdXMgdG8gVHlwZVNjcmlwdCdzIG93biBgdHMuVHlwZUNoZWNrZXJgIEFQSS5cbiAqXG4gKiBJbiBnZW5lcmFsLCB0aGlzIGludGVyZmFjZSBzdXBwb3J0cyB0d28ga2luZHMgb2Ygb3BlcmF0aW9uczpcbiAqICAtIHVwZGF0aW5nIFR5cGUgQ2hlY2sgQmxvY2tzIChUQ0IpcyB0aGF0IGNhcHR1cmUgdGhlIHRlbXBsYXRlIGluIHRoZSBmb3JtIG9mIFR5cGVTY3JpcHQgY29kZVxuICogIC0gcXVlcnlpbmcgaW5mb3JtYXRpb24gYWJvdXQgYXZhaWxhYmxlIFRDQnMsIGluY2x1ZGluZyBkaWFnbm9zdGljc1xuICpcbiAqIE9uY2UgYSBUQ0IgaXMgYXZhaWxhYmxlLCBpbmZvcm1hdGlvbiBhYm91dCBpdCBjYW4gYmUgcXVlcmllZC4gSWYgbm8gVENCIGlzIGF2YWlsYWJsZSB0byBhbnN3ZXIgYVxuICogcXVlcnksIGRlcGVuZGluZyBvbiB0aGUgbWV0aG9kIGVpdGhlciBgbnVsbGAgd2lsbCBiZSByZXR1cm5lZCBvciBhbiBlcnJvciB3aWxsIGJlIHRocm93bi5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBUZW1wbGF0ZVR5cGVDaGVja2VyIHtcbiAgLyoqXG4gICAqIENsZWFyIGFsbCBvdmVycmlkZXMgYW5kIHJldHVybiB0aGUgdGVtcGxhdGUgdHlwZS1jaGVja2VyIHRvIHRoZSBvcmlnaW5hbCBpbnB1dCBwcm9ncmFtIHN0YXRlLlxuICAgKi9cbiAgcmVzZXRPdmVycmlkZXMoKTogdm9pZDtcblxuICAvKipcbiAgICogUmV0cmlldmUgdGhlIHRlbXBsYXRlIGluIHVzZSBmb3IgdGhlIGdpdmVuIGNvbXBvbmVudC5cbiAgICpcbiAgICogSWYgdGhlIHRlbXBsYXRlIGhhcyBiZWVuIG92ZXJyaWRkZW4gdmlhIGBvdmVycmlkZUNvbXBvbmVudFRlbXBsYXRlYCwgdGhpcyB3aWxsIHJldHJpZXZlIHRoZVxuICAgKiBvdmVycmlkZGVuIHRlbXBsYXRlIG5vZGVzLlxuICAgKi9cbiAgZ2V0VGVtcGxhdGUoY29tcG9uZW50OiB0cy5DbGFzc0RlY2xhcmF0aW9uKTogVG1wbEFzdE5vZGVbXXxudWxsO1xuXG4gIC8qKlxuICAgKiBQcm92aWRlIGEgbmV3IHRlbXBsYXRlIHN0cmluZyB0aGF0IHdpbGwgYmUgdXNlZCBpbiBwbGFjZSBvZiB0aGUgdXNlci1kZWZpbmVkIHRlbXBsYXRlIHdoZW5cbiAgICogY2hlY2tpbmcgb3Igb3BlcmF0aW5nIG9uIHRoZSBnaXZlbiBjb21wb25lbnQuXG4gICAqXG4gICAqIFRoZSBjb21waWxlciB3aWxsIHBhcnNlIHRoaXMgdGVtcGxhdGUgZm9yIGRpYWdub3N0aWNzLCBhbmQgd2lsbCByZXR1cm4gYW55IHBhcnNpbmcgZXJyb3JzIGlmIGl0XG4gICAqIGlzIG5vdCB2YWxpZC4gSWYgdGhlIHRlbXBsYXRlIGNhbm5vdCBiZSBwYXJzZWQgY29ycmVjdGx5LCBubyBvdmVycmlkZSB3aWxsIG9jY3VyLlxuICAgKi9cbiAgb3ZlcnJpZGVDb21wb25lbnRUZW1wbGF0ZShjb21wb25lbnQ6IHRzLkNsYXNzRGVjbGFyYXRpb24sIHRlbXBsYXRlOiBzdHJpbmcpOlxuICAgICAge25vZGVzOiBUbXBsQXN0Tm9kZVtdLCBlcnJvcnM/OiBQYXJzZUVycm9yW119O1xuXG4gIC8qKlxuICAgKiBHZXQgYWxsIGB0cy5EaWFnbm9zdGljYHMgY3VycmVudGx5IGF2YWlsYWJsZSBmb3IgdGhlIGdpdmVuIGB0cy5Tb3VyY2VGaWxlYC5cbiAgICpcbiAgICogVGhpcyBtZXRob2Qgd2lsbCBmYWlsICh0aHJvdykgaWYgdGhlcmUgYXJlIGNvbXBvbmVudHMgd2l0aGluIHRoZSBgdHMuU291cmNlRmlsZWAgdGhhdCBkbyBub3RcbiAgICogaGF2ZSBUQ0JzIGF2YWlsYWJsZS5cbiAgICpcbiAgICogR2VuZXJhdGluZyBhIHRlbXBsYXRlIHR5cGUtY2hlY2tpbmcgcHJvZ3JhbSBpcyBleHBlbnNpdmUsIGFuZCBpbiBzb21lIHdvcmtmbG93cyAoZS5nLiBjaGVja2luZ1xuICAgKiBhbiBlbnRpcmUgcHJvZ3JhbSBiZWZvcmUgZW1pdCksIGl0IHNob3VsZCBpZGVhbGx5IG9ubHkgYmUgZG9uZSBvbmNlLiBUaGUgYG9wdGltaXplRm9yYCBmbGFnXG4gICAqIGFsbG93cyB0aGUgY2FsbGVyIHRvIGhpbnQgdG8gYGdldERpYWdub3N0aWNzRm9yRmlsZWAgKHdoaWNoIGludGVybmFsbHkgd2lsbCBjcmVhdGUgYSB0ZW1wbGF0ZVxuICAgKiB0eXBlLWNoZWNraW5nIHByb2dyYW0gaWYgbmVlZGVkKSB3aGV0aGVyIHRoZSBjYWxsZXIgaXMgaW50ZXJlc3RlZCBpbiBqdXN0IHRoZSByZXN1bHRzIG9mIHRoZVxuICAgKiBzaW5nbGUgZmlsZSwgb3Igd2hldGhlciB0aGV5IHBsYW4gdG8gcXVlcnkgYWJvdXQgb3RoZXIgZmlsZXMgaW4gdGhlIHByb2dyYW0uIEJhc2VkIG9uIHRoaXNcbiAgICogZmxhZywgYGdldERpYWdub3N0aWNzRm9yRmlsZWAgd2lsbCBkZXRlcm1pbmUgaG93IG11Y2ggb2YgdGhlIHVzZXIncyBwcm9ncmFtIHRvIHByZXBhcmUgZm9yXG4gICAqIGNoZWNraW5nIGFzIHBhcnQgb2YgdGhlIHRlbXBsYXRlIHR5cGUtY2hlY2tpbmcgcHJvZ3JhbSBpdCBjcmVhdGVzLlxuICAgKi9cbiAgZ2V0RGlhZ25vc3RpY3NGb3JGaWxlKHNmOiB0cy5Tb3VyY2VGaWxlLCBvcHRpbWl6ZUZvcjogT3B0aW1pemVGb3IpOiB0cy5EaWFnbm9zdGljW107XG5cbiAgLyoqXG4gICAqIEdldCBhbGwgYHRzLkRpYWdub3N0aWNgcyBjdXJyZW50bHkgYXZhaWxhYmxlIHRoYXQgcGVydGFpbiB0byB0aGUgZ2l2ZW4gY29tcG9uZW50LlxuICAgKlxuICAgKiBUaGlzIG1ldGhvZCBhbHdheXMgcnVucyBpbiBgT3B0aW1pemVGb3IuU2luZ2xlRmlsZWAgbW9kZS5cbiAgICovXG4gIGdldERpYWdub3N0aWNzRm9yQ29tcG9uZW50KGNvbXBvbmVudDogdHMuQ2xhc3NEZWNsYXJhdGlvbik6IHRzLkRpYWdub3N0aWNbXTtcblxuICAvKipcbiAgICogUmV0cmlldmUgdGhlIHRvcC1sZXZlbCBub2RlIHJlcHJlc2VudGluZyB0aGUgVENCIGZvciB0aGUgZ2l2ZW4gY29tcG9uZW50LlxuICAgKlxuICAgKiBUaGlzIGNhbiByZXR1cm4gYG51bGxgIGlmIHRoZXJlIGlzIG5vIFRDQiBhdmFpbGFibGUgZm9yIHRoZSBjb21wb25lbnQuXG4gICAqXG4gICAqIFRoaXMgbWV0aG9kIGFsd2F5cyBydW5zIGluIGBPcHRpbWl6ZUZvci5TaW5nbGVGaWxlYCBtb2RlLlxuICAgKi9cbiAgZ2V0VHlwZUNoZWNrQmxvY2soY29tcG9uZW50OiB0cy5DbGFzc0RlY2xhcmF0aW9uKTogdHMuTm9kZXxudWxsO1xufVxuXG4vKipcbiAqIERlc2NyaWJlcyB0aGUgc2NvcGUgb2YgdGhlIGNhbGxlcidzIGludGVyZXN0IGluIHRlbXBsYXRlIHR5cGUtY2hlY2tpbmcgcmVzdWx0cy5cbiAqL1xuZXhwb3J0IGVudW0gT3B0aW1pemVGb3Ige1xuICAvKipcbiAgICogSW5kaWNhdGVzIHRoYXQgYSBjb25zdW1lciBvZiBhIGBUZW1wbGF0ZVR5cGVDaGVja2VyYCBpcyBvbmx5IGludGVyZXN0ZWQgaW4gcmVzdWx0cyBmb3IgYSBnaXZlblxuICAgKiBmaWxlLCBhbmQgd2FudHMgdGhlbSBhcyBmYXN0IGFzIHBvc3NpYmxlLlxuICAgKlxuICAgKiBDYWxsaW5nIGBUZW1wbGF0ZVR5cGVDaGVja2VyYCBtZXRob2RzIHN1Y2Nlc3NpdmVseSBmb3IgbXVsdGlwbGUgZmlsZXMgd2hpbGUgc3BlY2lmeWluZ1xuICAgKiBgT3B0aW1pemVGb3IuU2luZ2xlRmlsZWAgY2FuIHJlc3VsdCBpbiBzaWduaWZpY2FudCB1bm5lY2Vzc2FyeSBvdmVyaGVhZCBvdmVyYWxsLlxuICAgKi9cbiAgU2luZ2xlRmlsZSxcblxuICAvKipcbiAgICogSW5kaWNhdGVzIHRoYXQgYSBjb25zdW1lciBvZiBhIGBUZW1wbGF0ZVR5cGVDaGVja2VyYCBpbnRlbmRzIHRvIHF1ZXJ5IGZvciByZXN1bHRzIHBlcnRhaW5pbmcgdG9cbiAgICogdGhlIGVudGlyZSB1c2VyIHByb2dyYW0sIGFuZCBzbyB0aGUgdHlwZS1jaGVja2VyIHNob3VsZCBpbnRlcm5hbGx5IG9wdGltaXplIGZvciB0aGlzIGNhc2UuXG4gICAqXG4gICAqIEluaXRpYWwgY2FsbHMgdG8gcmV0cmlldmUgdHlwZS1jaGVja2luZyBpbmZvcm1hdGlvbiBtYXkgdGFrZSBsb25nZXIsIGJ1dCByZXBlYXRlZCBjYWxscyB0b1xuICAgKiBnYXRoZXIgaW5mb3JtYXRpb24gZm9yIHRoZSB3aG9sZSB1c2VyIHByb2dyYW0gd2lsbCBiZSBzaWduaWZpY2FudGx5IGZhc3RlciB3aXRoIHRoaXMgbW9kZSBvZlxuICAgKiBvcHRpbWl6YXRpb24uXG4gICAqL1xuICBXaG9sZVByb2dyYW0sXG59XG4iXX0=