/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/typecheck/api/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.UpdateMode = void 0;
    var UpdateMode;
    (function (UpdateMode) {
        /**
         * A complete update creates a completely new overlay of type-checking code on top of the user's
         * original program, which doesn't include type-checking code from previous calls to
         * `updateFiles`.
         */
        UpdateMode[UpdateMode["Complete"] = 0] = "Complete";
        /**
         * An incremental update changes the contents of some files in the type-checking program without
         * reverting any prior changes.
         */
        UpdateMode[UpdateMode["Incremental"] = 1] = "Incremental";
    })(UpdateMode = exports.UpdateMode || (exports.UpdateMode = {}));
});
//# sourceMappingURL=data:application/json;base64,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