/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/reflection/src/host", ["require", "exports", "typescript"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isConcreteDeclaration = exports.KnownDeclaration = exports.ClassMemberKind = exports.isDecoratorIdentifier = exports.Decorator = void 0;
    var ts = require("typescript");
    exports.Decorator = {
        nodeForError: function (decorator) {
            if (decorator.node !== null) {
                return decorator.node;
            }
            else {
                // TODO(alxhub): we can't rely on narrowing until TS 3.6 is in g3.
                return decorator.synthesizedFor;
            }
        },
    };
    function isDecoratorIdentifier(exp) {
        return ts.isIdentifier(exp) ||
            ts.isPropertyAccessExpression(exp) && ts.isIdentifier(exp.expression) &&
                ts.isIdentifier(exp.name);
    }
    exports.isDecoratorIdentifier = isDecoratorIdentifier;
    /**
     * An enumeration of possible kinds of class members.
     */
    var ClassMemberKind;
    (function (ClassMemberKind) {
        ClassMemberKind[ClassMemberKind["Constructor"] = 0] = "Constructor";
        ClassMemberKind[ClassMemberKind["Getter"] = 1] = "Getter";
        ClassMemberKind[ClassMemberKind["Setter"] = 2] = "Setter";
        ClassMemberKind[ClassMemberKind["Property"] = 3] = "Property";
        ClassMemberKind[ClassMemberKind["Method"] = 4] = "Method";
    })(ClassMemberKind = exports.ClassMemberKind || (exports.ClassMemberKind = {}));
    /**
     * Possible declarations of known values, such as built-in objects/functions or TypeScript helpers.
     */
    var KnownDeclaration;
    (function (KnownDeclaration) {
        /**
         * Indicates the JavaScript global `Object` class.
         */
        KnownDeclaration[KnownDeclaration["JsGlobalObject"] = 0] = "JsGlobalObject";
        /**
         * Indicates the `__assign` TypeScript helper function.
         */
        KnownDeclaration[KnownDeclaration["TsHelperAssign"] = 1] = "TsHelperAssign";
        /**
         * Indicates the `__spread` TypeScript helper function.
         */
        KnownDeclaration[KnownDeclaration["TsHelperSpread"] = 2] = "TsHelperSpread";
        /**
         * Indicates the `__spreadArrays` TypeScript helper function.
         */
        KnownDeclaration[KnownDeclaration["TsHelperSpreadArrays"] = 3] = "TsHelperSpreadArrays";
    })(KnownDeclaration = exports.KnownDeclaration || (exports.KnownDeclaration = {}));
    /**
     * Returns true if the `decl` is a `ConcreteDeclaration` (ie. that its `node` property is a
     * `ts.Declaration`).
     */
    function isConcreteDeclaration(decl) {
        return decl.kind === 0 /* Concrete */;
    }
    exports.isConcreteDeclaration = isConcreteDeclaration;
});
//# sourceMappingURL=data:application/json;base64,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