(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/ngcc/src/ngcc_options", ["require", "exports", "os", "@angular/compiler-cli/src/ngtsc/file_system", "@angular/compiler-cli/src/ngtsc/logging", "@angular/compiler-cli/src/perform_compile", "@angular/compiler-cli/ngcc/src/packages/entry_point", "@angular/compiler-cli/ngcc/src/path_mappings", "@angular/compiler-cli/ngcc/src/writing/in_place_file_writer", "@angular/compiler-cli/ngcc/src/writing/new_entry_point_file_writer"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getMaxNumberOfWorkers = exports.clearTsConfigCache = exports.getSharedSetup = void 0;
    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var os = require("os");
    var file_system_1 = require("@angular/compiler-cli/src/ngtsc/file_system");
    var logging_1 = require("@angular/compiler-cli/src/ngtsc/logging");
    var perform_compile_1 = require("@angular/compiler-cli/src/perform_compile");
    var entry_point_1 = require("@angular/compiler-cli/ngcc/src/packages/entry_point");
    var path_mappings_1 = require("@angular/compiler-cli/ngcc/src/path_mappings");
    var in_place_file_writer_1 = require("@angular/compiler-cli/ngcc/src/writing/in_place_file_writer");
    var new_entry_point_file_writer_1 = require("@angular/compiler-cli/ngcc/src/writing/new_entry_point_file_writer");
    /**
     * Instantiate common utilities that are always used and fix up options with defaults, as necessary.
     *
     * NOTE: Avoid eagerly instantiating anything that might not be used when running sync/async.
     */
    function getSharedSetup(options) {
        var fileSystem = file_system_1.getFileSystem();
        var absBasePath = file_system_1.absoluteFrom(options.basePath);
        var projectPath = fileSystem.dirname(absBasePath);
        var tsConfig = options.tsConfigPath !== null ? getTsConfig(options.tsConfigPath || projectPath) : null;
        var basePath = options.basePath, targetEntryPointPath = options.targetEntryPointPath, _a = options.propertiesToConsider, propertiesToConsider = _a === void 0 ? entry_point_1.SUPPORTED_FORMAT_PROPERTIES : _a, _b = options.compileAllFormats, compileAllFormats = _b === void 0 ? true : _b, _c = options.createNewEntryPointFormats, createNewEntryPointFormats = _c === void 0 ? false : _c, _d = options.logger, logger = _d === void 0 ? new logging_1.ConsoleLogger(logging_1.LogLevel.info) : _d, _e = options.pathMappings, pathMappings = _e === void 0 ? path_mappings_1.getPathMappingsFromTsConfig(tsConfig, projectPath) : _e, _f = options.async, async = _f === void 0 ? false : _f, _g = options.errorOnFailedEntryPoint, errorOnFailedEntryPoint = _g === void 0 ? false : _g, _h = options.enableI18nLegacyMessageIdFormat, enableI18nLegacyMessageIdFormat = _h === void 0 ? true : _h, _j = options.invalidateEntryPointManifest, invalidateEntryPointManifest = _j === void 0 ? false : _j, tsConfigPath = options.tsConfigPath;
        if (!!targetEntryPointPath) {
            // targetEntryPointPath forces us to error if an entry-point fails.
            errorOnFailedEntryPoint = true;
        }
        checkForSolutionStyleTsConfig(fileSystem, logger, projectPath, options.tsConfigPath, tsConfig);
        return {
            basePath: basePath,
            targetEntryPointPath: targetEntryPointPath,
            propertiesToConsider: propertiesToConsider,
            compileAllFormats: compileAllFormats,
            createNewEntryPointFormats: createNewEntryPointFormats,
            logger: logger,
            pathMappings: pathMappings,
            async: async,
            errorOnFailedEntryPoint: errorOnFailedEntryPoint,
            enableI18nLegacyMessageIdFormat: enableI18nLegacyMessageIdFormat,
            invalidateEntryPointManifest: invalidateEntryPointManifest,
            tsConfigPath: tsConfigPath,
            fileSystem: fileSystem,
            absBasePath: absBasePath,
            projectPath: projectPath,
            tsConfig: tsConfig,
            getFileWriter: function (pkgJsonUpdater) { return createNewEntryPointFormats ?
                new new_entry_point_file_writer_1.NewEntryPointFileWriter(fileSystem, logger, errorOnFailedEntryPoint, pkgJsonUpdater) :
                new in_place_file_writer_1.InPlaceFileWriter(fileSystem, logger, errorOnFailedEntryPoint); },
        };
    }
    exports.getSharedSetup = getSharedSetup;
    var tsConfigCache = null;
    var tsConfigPathCache = null;
    /**
     * Get the parsed configuration object for the given `tsConfigPath`.
     *
     * This function will cache the previous parsed configuration object to avoid unnecessary processing
     * of the tsconfig.json in the case that it is requested repeatedly.
     *
     * This makes the assumption, which is true as of writing, that the contents of tsconfig.json and
     * its dependencies will not change during the life of the process running ngcc.
     */
    function getTsConfig(tsConfigPath) {
        if (tsConfigPath !== tsConfigPathCache) {
            tsConfigPathCache = tsConfigPath;
            tsConfigCache = perform_compile_1.readConfiguration(tsConfigPath);
        }
        return tsConfigCache;
    }
    function clearTsConfigCache() {
        tsConfigPathCache = null;
        tsConfigCache = null;
    }
    exports.clearTsConfigCache = clearTsConfigCache;
    function checkForSolutionStyleTsConfig(fileSystem, logger, projectPath, tsConfigPath, tsConfig) {
        if (tsConfigPath !== null && !tsConfigPath && tsConfig !== null &&
            tsConfig.rootNames.length === 0 && tsConfig.projectReferences !== undefined &&
            tsConfig.projectReferences.length > 0) {
            logger.warn("The inferred tsconfig file \"" + tsConfig.project + "\" appears to be \"solution-style\" " +
                "since it contains no root files but does contain project references.\n" +
                "This is probably not wanted, since ngcc is unable to infer settings like \"paths\" mappings from such a file.\n" +
                "Perhaps you should have explicitly specified one of the referenced projects using the --tsconfig option. For example:\n\n" +
                tsConfig.projectReferences.map(function (ref) { return "  ngcc ... --tsconfig \"" + ref.originalPath + "\"\n"; })
                    .join('') +
                "\nFind out more about solution-style tsconfig at https://devblogs.microsoft.com/typescript/announcing-typescript-3-9/#solution-style-tsconfig.\n" +
                "If you did intend to use this file, then you can hide this warning by providing it explicitly:\n\n" +
                ("  ngcc ... --tsconfig \"" + fileSystem.relative(projectPath, tsConfig.project) + "\""));
        }
    }
    /**
     * Determines the maximum number of workers to use for parallel execution. This can be set using the
     * NGCC_MAX_WORKERS environment variable, or is computed based on the number of available CPUs. One
     * CPU core is always reserved for the master process, so we take the number of CPUs minus one, with
     * a maximum of 4 workers. We don't scale the number of workers beyond 4 by default, as it takes
     * considerably more memory and CPU cycles while not offering a substantial improvement in time.
     */
    function getMaxNumberOfWorkers() {
        var maxWorkers = process.env.NGCC_MAX_WORKERS;
        if (maxWorkers === undefined) {
            // Use up to 4 CPU cores for workers, always reserving one for master.
            return Math.max(1, Math.min(4, os.cpus().length - 1));
        }
        var numericMaxWorkers = +maxWorkers.trim();
        if (!Number.isInteger(numericMaxWorkers)) {
            throw new Error('NGCC_MAX_WORKERS should be an integer.');
        }
        else if (numericMaxWorkers < 1) {
            throw new Error('NGCC_MAX_WORKERS should be at least 1.');
        }
        return numericMaxWorkers;
    }
    exports.getMaxNumberOfWorkers = getMaxNumberOfWorkers;
});
//# sourceMappingURL=data:application/json;base64,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