/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/ngcc/src/main", ["require", "exports", "tslib", "@angular/compiler-cli/src/ngtsc/file_system", "@angular/compiler-cli/ngcc/src/dependencies/commonjs_dependency_host", "@angular/compiler-cli/ngcc/src/dependencies/dependency_resolver", "@angular/compiler-cli/ngcc/src/dependencies/dts_dependency_host", "@angular/compiler-cli/ngcc/src/dependencies/esm_dependency_host", "@angular/compiler-cli/ngcc/src/dependencies/module_resolver", "@angular/compiler-cli/ngcc/src/dependencies/umd_dependency_host", "@angular/compiler-cli/ngcc/src/entry_point_finder/directory_walker_entry_point_finder", "@angular/compiler-cli/ngcc/src/entry_point_finder/entry_point_collector", "@angular/compiler-cli/ngcc/src/entry_point_finder/program_based_entry_point_finder", "@angular/compiler-cli/ngcc/src/entry_point_finder/targeted_entry_point_finder", "@angular/compiler-cli/ngcc/src/execution/analyze_entry_points", "@angular/compiler-cli/ngcc/src/execution/cluster/executor", "@angular/compiler-cli/ngcc/src/execution/create_compile_function", "@angular/compiler-cli/ngcc/src/execution/single_process_executor", "@angular/compiler-cli/ngcc/src/execution/tasks/completion", "@angular/compiler-cli/ngcc/src/locking/async_locker", "@angular/compiler-cli/ngcc/src/locking/lock_file_with_child_process/index", "@angular/compiler-cli/ngcc/src/locking/sync_locker", "@angular/compiler-cli/ngcc/src/ngcc_options", "@angular/compiler-cli/ngcc/src/packages/configuration", "@angular/compiler-cli/ngcc/src/packages/entry_point", "@angular/compiler-cli/ngcc/src/packages/entry_point_manifest", "@angular/compiler-cli/ngcc/src/writing/package_json_updater"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.mainNgcc = void 0;
    var tslib_1 = require("tslib");
    /// <reference types="node" />
    var file_system_1 = require("@angular/compiler-cli/src/ngtsc/file_system");
    var commonjs_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/commonjs_dependency_host");
    var dependency_resolver_1 = require("@angular/compiler-cli/ngcc/src/dependencies/dependency_resolver");
    var dts_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/dts_dependency_host");
    var esm_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/esm_dependency_host");
    var module_resolver_1 = require("@angular/compiler-cli/ngcc/src/dependencies/module_resolver");
    var umd_dependency_host_1 = require("@angular/compiler-cli/ngcc/src/dependencies/umd_dependency_host");
    var directory_walker_entry_point_finder_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/directory_walker_entry_point_finder");
    var entry_point_collector_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/entry_point_collector");
    var program_based_entry_point_finder_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/program_based_entry_point_finder");
    var targeted_entry_point_finder_1 = require("@angular/compiler-cli/ngcc/src/entry_point_finder/targeted_entry_point_finder");
    var analyze_entry_points_1 = require("@angular/compiler-cli/ngcc/src/execution/analyze_entry_points");
    var executor_1 = require("@angular/compiler-cli/ngcc/src/execution/cluster/executor");
    var create_compile_function_1 = require("@angular/compiler-cli/ngcc/src/execution/create_compile_function");
    var single_process_executor_1 = require("@angular/compiler-cli/ngcc/src/execution/single_process_executor");
    var completion_1 = require("@angular/compiler-cli/ngcc/src/execution/tasks/completion");
    var async_locker_1 = require("@angular/compiler-cli/ngcc/src/locking/async_locker");
    var lock_file_with_child_process_1 = require("@angular/compiler-cli/ngcc/src/locking/lock_file_with_child_process/index");
    var sync_locker_1 = require("@angular/compiler-cli/ngcc/src/locking/sync_locker");
    var ngcc_options_1 = require("@angular/compiler-cli/ngcc/src/ngcc_options");
    var configuration_1 = require("@angular/compiler-cli/ngcc/src/packages/configuration");
    var entry_point_1 = require("@angular/compiler-cli/ngcc/src/packages/entry_point");
    var entry_point_manifest_1 = require("@angular/compiler-cli/ngcc/src/packages/entry_point_manifest");
    var package_json_updater_1 = require("@angular/compiler-cli/ngcc/src/writing/package_json_updater");
    function mainNgcc(options) {
        var _a = ngcc_options_1.getSharedSetup(options), basePath = _a.basePath, targetEntryPointPath = _a.targetEntryPointPath, propertiesToConsider = _a.propertiesToConsider, compileAllFormats = _a.compileAllFormats, logger = _a.logger, pathMappings = _a.pathMappings, async = _a.async, errorOnFailedEntryPoint = _a.errorOnFailedEntryPoint, enableI18nLegacyMessageIdFormat = _a.enableI18nLegacyMessageIdFormat, invalidateEntryPointManifest = _a.invalidateEntryPointManifest, fileSystem = _a.fileSystem, absBasePath = _a.absBasePath, projectPath = _a.projectPath, tsConfig = _a.tsConfig, getFileWriter = _a.getFileWriter;
        var config = new configuration_1.NgccConfiguration(fileSystem, projectPath);
        var dependencyResolver = getDependencyResolver(fileSystem, logger, config, pathMappings);
        var entryPointManifest = invalidateEntryPointManifest ?
            new entry_point_manifest_1.InvalidatingEntryPointManifest(fileSystem, config, logger) :
            new entry_point_manifest_1.EntryPointManifest(fileSystem, config, logger);
        // Bail out early if the work is already done.
        var supportedPropertiesToConsider = ensureSupportedProperties(propertiesToConsider);
        var absoluteTargetEntryPointPath = targetEntryPointPath !== undefined ? file_system_1.resolve(basePath, targetEntryPointPath) : null;
        var finder = getEntryPointFinder(fileSystem, logger, dependencyResolver, config, entryPointManifest, absBasePath, absoluteTargetEntryPointPath, pathMappings, options.findEntryPointsFromTsConfigProgram ? tsConfig : null, projectPath);
        if (finder instanceof targeted_entry_point_finder_1.TargetedEntryPointFinder &&
            !finder.targetNeedsProcessingOrCleaning(supportedPropertiesToConsider, compileAllFormats)) {
            logger.debug('The target entry-point has already been processed');
            return;
        }
        // Determine the number of workers to use and whether ngcc should run in parallel.
        var workerCount = async ? ngcc_options_1.getMaxNumberOfWorkers() : 1;
        var inParallel = workerCount > 1;
        var analyzeEntryPoints = analyze_entry_points_1.getAnalyzeEntryPointsFn(logger, finder, fileSystem, supportedPropertiesToConsider, compileAllFormats, propertiesToConsider, inParallel);
        // Create an updater that will actually write to disk.
        var pkgJsonUpdater = new package_json_updater_1.DirectPackageJsonUpdater(fileSystem);
        var fileWriter = getFileWriter(pkgJsonUpdater);
        // The function for creating the `compile()` function.
        var createCompileFn = create_compile_function_1.getCreateCompileFn(fileSystem, logger, fileWriter, enableI18nLegacyMessageIdFormat, tsConfig, pathMappings);
        // The executor for actually planning and getting the work done.
        var createTaskCompletedCallback = getCreateTaskCompletedCallback(pkgJsonUpdater, errorOnFailedEntryPoint, logger, fileSystem);
        var executor = getExecutor(async, workerCount, logger, fileWriter, pkgJsonUpdater, fileSystem, config, createTaskCompletedCallback);
        return executor.execute(analyzeEntryPoints, createCompileFn);
    }
    exports.mainNgcc = mainNgcc;
    function ensureSupportedProperties(properties) {
        var e_1, _a;
        // Short-circuit the case where `properties` has fallen back to the default value:
        // `SUPPORTED_FORMAT_PROPERTIES`
        if (properties === entry_point_1.SUPPORTED_FORMAT_PROPERTIES)
            return entry_point_1.SUPPORTED_FORMAT_PROPERTIES;
        var supportedProperties = [];
        try {
            for (var _b = tslib_1.__values(properties), _c = _b.next(); !_c.done; _c = _b.next()) {
                var prop = _c.value;
                if (entry_point_1.SUPPORTED_FORMAT_PROPERTIES.indexOf(prop) !== -1) {
                    supportedProperties.push(prop);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        if (supportedProperties.length === 0) {
            throw new Error("No supported format property to consider among [" + properties.join(', ') + "]. " +
                ("Supported properties: " + entry_point_1.SUPPORTED_FORMAT_PROPERTIES.join(', ')));
        }
        return supportedProperties;
    }
    function getCreateTaskCompletedCallback(pkgJsonUpdater, errorOnFailedEntryPoint, logger, fileSystem) {
        return function (taskQueue) {
            var _a;
            return completion_1.composeTaskCompletedCallbacks((_a = {},
                _a[0 /* Processed */] = completion_1.createMarkAsProcessedHandler(pkgJsonUpdater),
                _a[1 /* Failed */] = errorOnFailedEntryPoint ? completion_1.createThrowErrorHandler(fileSystem) :
                    completion_1.createLogErrorHandler(logger, fileSystem, taskQueue),
                _a));
        };
    }
    function getExecutor(async, workerCount, logger, fileWriter, pkgJsonUpdater, fileSystem, config, createTaskCompletedCallback) {
        var lockFile = new lock_file_with_child_process_1.LockFileWithChildProcess(fileSystem, logger);
        if (async) {
            // Execute asynchronously (either serially or in parallel)
            var _a = config.getLockingConfig(), retryAttempts = _a.retryAttempts, retryDelay = _a.retryDelay;
            var locker = new async_locker_1.AsyncLocker(lockFile, logger, retryDelay, retryAttempts);
            if (workerCount > 1) {
                // Execute in parallel.
                return new executor_1.ClusterExecutor(workerCount, fileSystem, logger, fileWriter, pkgJsonUpdater, locker, createTaskCompletedCallback);
            }
            else {
                // Execute serially, on a single thread (async).
                return new single_process_executor_1.SingleProcessExecutorAsync(logger, locker, createTaskCompletedCallback);
            }
        }
        else {
            // Execute serially, on a single thread (sync).
            return new single_process_executor_1.SingleProcessExecutorSync(logger, new sync_locker_1.SyncLocker(lockFile), createTaskCompletedCallback);
        }
    }
    function getDependencyResolver(fileSystem, logger, config, pathMappings) {
        var moduleResolver = new module_resolver_1.ModuleResolver(fileSystem, pathMappings);
        var esmDependencyHost = new esm_dependency_host_1.EsmDependencyHost(fileSystem, moduleResolver);
        var umdDependencyHost = new umd_dependency_host_1.UmdDependencyHost(fileSystem, moduleResolver);
        var commonJsDependencyHost = new commonjs_dependency_host_1.CommonJsDependencyHost(fileSystem, moduleResolver);
        var dtsDependencyHost = new dts_dependency_host_1.DtsDependencyHost(fileSystem, pathMappings);
        return new dependency_resolver_1.DependencyResolver(fileSystem, logger, config, {
            esm5: esmDependencyHost,
            esm2015: esmDependencyHost,
            umd: umdDependencyHost,
            commonjs: commonJsDependencyHost
        }, dtsDependencyHost);
    }
    function getEntryPointFinder(fs, logger, resolver, config, entryPointManifest, basePath, absoluteTargetEntryPointPath, pathMappings, tsConfig, projectPath) {
        if (absoluteTargetEntryPointPath !== null) {
            return new targeted_entry_point_finder_1.TargetedEntryPointFinder(fs, config, logger, resolver, basePath, pathMappings, absoluteTargetEntryPointPath);
        }
        else {
            var entryPointCollector = new entry_point_collector_1.EntryPointCollector(fs, config, logger, resolver);
            if (tsConfig !== null) {
                return new program_based_entry_point_finder_1.ProgramBasedEntryPointFinder(fs, config, logger, resolver, entryPointCollector, entryPointManifest, basePath, tsConfig, projectPath);
            }
            else {
                return new directory_walker_entry_point_finder_1.DirectoryWalkerEntryPointFinder(logger, resolver, entryPointCollector, entryPointManifest, basePath, pathMappings);
            }
        }
    }
});
//# sourceMappingURL=data:application/json;base64,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