(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/ngcc/src/analysis/ngcc_trait_compiler", ["require", "exports", "tslib", "@angular/compiler-cli/src/ngtsc/perf", "@angular/compiler-cli/src/ngtsc/transform", "@angular/compiler-cli/ngcc/src/utils"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.NgccTraitCompiler = void 0;
    var tslib_1 = require("tslib");
    var perf_1 = require("@angular/compiler-cli/src/ngtsc/perf");
    var transform_1 = require("@angular/compiler-cli/src/ngtsc/transform");
    var utils_1 = require("@angular/compiler-cli/ngcc/src/utils");
    /**
     * Specializes the `TraitCompiler` for ngcc purposes. Mainly, this includes an alternative way of
     * scanning for classes to compile using the reflection host's `findClassSymbols`, together with
     * support to inject synthetic decorators into the compilation for ad-hoc migrations that ngcc
     * performs.
     */
    var NgccTraitCompiler = /** @class */ (function (_super) {
        tslib_1.__extends(NgccTraitCompiler, _super);
        function NgccTraitCompiler(handlers, ngccReflector) {
            var _this = _super.call(this, handlers, ngccReflector, perf_1.NOOP_PERF_RECORDER, new NoIncrementalBuild(), 
            /* compileNonExportedClasses */ true, new transform_1.DtsTransformRegistry()) || this;
            _this.ngccReflector = ngccReflector;
            return _this;
        }
        Object.defineProperty(NgccTraitCompiler.prototype, "analyzedFiles", {
            get: function () {
                return Array.from(this.fileToClasses.keys());
            },
            enumerable: false,
            configurable: true
        });
        /**
         * Analyzes the source file in search for classes to process. For any class that is found in the
         * file, a `ClassRecord` is created and the source file is included in the `analyzedFiles` array.
         */
        NgccTraitCompiler.prototype.analyzeFile = function (sf) {
            var e_1, _a;
            var ngccClassSymbols = this.ngccReflector.findClassSymbols(sf);
            try {
                for (var ngccClassSymbols_1 = tslib_1.__values(ngccClassSymbols), ngccClassSymbols_1_1 = ngccClassSymbols_1.next(); !ngccClassSymbols_1_1.done; ngccClassSymbols_1_1 = ngccClassSymbols_1.next()) {
                    var classSymbol = ngccClassSymbols_1_1.value;
                    this.analyzeClass(classSymbol.declaration.valueDeclaration, null);
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (ngccClassSymbols_1_1 && !ngccClassSymbols_1_1.done && (_a = ngccClassSymbols_1.return)) _a.call(ngccClassSymbols_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return undefined;
        };
        /**
         * Associate a new synthesized decorator, which did not appear in the original source, with a
         * given class.
         * @param clazz the class to receive the new decorator.
         * @param decorator the decorator to inject.
         * @param flags optional bitwise flag to influence the compilation of the decorator.
         */
        NgccTraitCompiler.prototype.injectSyntheticDecorator = function (clazz, decorator, flags) {
            var e_2, _a;
            var migratedTraits = this.detectTraits(clazz, [decorator]);
            if (migratedTraits === null) {
                return [];
            }
            try {
                for (var migratedTraits_1 = tslib_1.__values(migratedTraits), migratedTraits_1_1 = migratedTraits_1.next(); !migratedTraits_1_1.done; migratedTraits_1_1 = migratedTraits_1.next()) {
                    var trait = migratedTraits_1_1.value;
                    this.analyzeTrait(clazz, trait, flags);
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (migratedTraits_1_1 && !migratedTraits_1_1.done && (_a = migratedTraits_1.return)) _a.call(migratedTraits_1);
                }
                finally { if (e_2) throw e_2.error; }
            }
            return migratedTraits;
        };
        /**
         * Returns all decorators that have been recognized for the provided class, including any
         * synthetically injected decorators.
         * @param clazz the declaration for which the decorators are returned.
         */
        NgccTraitCompiler.prototype.getAllDecorators = function (clazz) {
            var record = this.recordFor(clazz);
            if (record === null) {
                return null;
            }
            return record.traits.map(function (trait) { return trait.detected.decorator; }).filter(utils_1.isDefined);
        };
        return NgccTraitCompiler;
    }(transform_1.TraitCompiler));
    exports.NgccTraitCompiler = NgccTraitCompiler;
    var NoIncrementalBuild = /** @class */ (function () {
        function NoIncrementalBuild() {
        }
        NoIncrementalBuild.prototype.priorWorkFor = function (sf) {
            return null;
        };
        NoIncrementalBuild.prototype.priorTypeCheckingResultsFor = function () {
            return null;
        };
        NoIncrementalBuild.prototype.recordSuccessfulTypeCheck = function () { };
        return NoIncrementalBuild;
    }());
});
//# sourceMappingURL=data:application/json;base64,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