/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export { HttpBackend, HttpHandler } from './src/backend';
export { HttpClient } from './src/client';
export { HttpHeaders } from './src/headers';
export { HTTP_INTERCEPTORS } from './src/interceptor';
export { JsonpClientBackend, JsonpInterceptor } from './src/jsonp';
export { HttpClientJsonpModule, HttpClientModule, HttpClientXsrfModule, HttpInterceptingHandler as ɵHttpInterceptingHandler } from './src/module';
export { HttpParams, HttpUrlEncodingCodec } from './src/params';
export { HttpRequest } from './src/request';
export { HttpErrorResponse, HttpEventType, HttpHeaderResponse, HttpResponse, HttpResponseBase } from './src/response';
export { HttpXhrBackend, XhrFactory } from './src/xhr';
export { HttpXsrfTokenExtractor } from './src/xsrf';
//# sourceMappingURL=data:application/json;base64,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