"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultComponentOptions = void 0;
/**
 * Returns the default options for the `@schematics/angular:component` schematic which would
 * have been specified at project initialization (ng new or ng init).
 *
 * This is necessary because the Angular CLI only exposes the default values for the "--style",
 * "--inlineStyle", "--skipTests" and "--inlineTemplate" options to the "component" schematic.
 */
function getDefaultComponentOptions(project) {
    // Note: Not all options which are available when running "ng new" will be stored in the
    // workspace config. List of options which will be available in the configuration:
    // angular/angular-cli/blob/master/packages/schematics/angular/application/index.ts#L109-L131
    let skipTests = getDefaultComponentOption(project, ['skipTests'], null);
    // In case "skipTests" is not set explicitly, also look for the "spec" option. The "spec"
    // option has been deprecated but can be still used in older Angular CLI projects.
    // See: https://github.com/angular/angular-cli/commit/a12a4e02a4689b5bdbc6e740c0d9865afb55671a
    if (skipTests === null) {
        skipTests = !getDefaultComponentOption(project, ['spec'], true);
    }
    return {
        style: getDefaultComponentOption(project, ['style', 'styleext'], 'css'),
        inlineStyle: getDefaultComponentOption(project, ['inlineStyle'], false),
        inlineTemplate: getDefaultComponentOption(project, ['inlineTemplate'], false),
        skipTests: skipTests,
    };
}
exports.getDefaultComponentOptions = getDefaultComponentOptions;
/**
 * Gets the default value for the specified option. The default options will be determined
 * by looking at the stored schematic options for `@schematics/angular:component` in the
 * CLI workspace configuration.
 */
function getDefaultComponentOption(project, optionNames, fallbackValue) {
    for (let optionName of optionNames) {
        if (project.schematics &&
            project.schematics['@schematics/angular:component'] &&
            project.schematics['@schematics/angular:component'][optionName] != null) {
            return project.schematics['@schematics/angular:component'][optionName];
        }
    }
    return fallbackValue;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2NoZW1hdGljLW9wdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi9zcmMvY2RrL3NjaGVtYXRpY3MvdXRpbHMvc2NoZW1hdGljLW9wdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7R0FNRzs7O0FBS0g7Ozs7OztHQU1HO0FBQ0gsU0FBZ0IsMEJBQTBCLENBQUMsT0FBeUI7SUFDbEUsd0ZBQXdGO0lBQ3hGLGtGQUFrRjtJQUNsRiw2RkFBNkY7SUFDN0YsSUFBSSxTQUFTLEdBQUcseUJBQXlCLENBQWUsT0FBTyxFQUFFLENBQUMsV0FBVyxDQUFDLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFFdEYseUZBQXlGO0lBQ3pGLGtGQUFrRjtJQUNsRiw4RkFBOEY7SUFDOUYsSUFBSSxTQUFTLEtBQUssSUFBSSxFQUFFO1FBQ3RCLFNBQVMsR0FBRyxDQUFDLHlCQUF5QixDQUFDLE9BQU8sRUFBRSxDQUFDLE1BQU0sQ0FBQyxFQUFFLElBQUksQ0FBQyxDQUFDO0tBQ2pFO0lBRUQsT0FBTztRQUNMLEtBQUssRUFBRSx5QkFBeUIsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxPQUFPLEVBQUUsVUFBVSxDQUFDLEVBQUUsS0FBSyxDQUFDO1FBQ3ZFLFdBQVcsRUFBRSx5QkFBeUIsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxhQUFhLENBQUMsRUFBRSxLQUFLLENBQUM7UUFDdkUsY0FBYyxFQUFFLHlCQUF5QixDQUFDLE9BQU8sRUFBRSxDQUFDLGdCQUFnQixDQUFDLEVBQUUsS0FBSyxDQUFDO1FBQzdFLFNBQVMsRUFBRSxTQUFTO0tBQ3JCLENBQUM7QUFDSixDQUFDO0FBbkJELGdFQW1CQztBQUVEOzs7O0dBSUc7QUFDSCxTQUFTLHlCQUF5QixDQUFJLE9BQXlCLEVBQUUsV0FBcUIsRUFDaEQsYUFBZ0I7SUFDcEQsS0FBSyxJQUFJLFVBQVUsSUFBSSxXQUFXLEVBQUU7UUFDbEMsSUFBSSxPQUFPLENBQUMsVUFBVTtZQUNsQixPQUFPLENBQUMsVUFBVSxDQUFDLCtCQUErQixDQUFDO1lBQ25ELE9BQU8sQ0FBQyxVQUFVLENBQUMsK0JBQStCLENBQUMsQ0FBQyxVQUFVLENBQUMsSUFBSSxJQUFJLEVBQUU7WUFFM0UsT0FBTyxPQUFPLENBQUMsVUFBVSxDQUFDLCtCQUErQixDQUFDLENBQUMsVUFBVSxDQUFDLENBQUM7U0FDeEU7S0FDRjtJQUVELE9BQU8sYUFBYSxDQUFDO0FBQ3ZCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgR29vZ2xlIExMQyBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuaW1wb3J0IHtXb3Jrc3BhY2VQcm9qZWN0fSBmcm9tICdAYW5ndWxhci1kZXZraXQvY29yZS9zcmMvZXhwZXJpbWVudGFsL3dvcmtzcGFjZSc7XG5cblxuLyoqXG4gKiBSZXR1cm5zIHRoZSBkZWZhdWx0IG9wdGlvbnMgZm9yIHRoZSBgQHNjaGVtYXRpY3MvYW5ndWxhcjpjb21wb25lbnRgIHNjaGVtYXRpYyB3aGljaCB3b3VsZFxuICogaGF2ZSBiZWVuIHNwZWNpZmllZCBhdCBwcm9qZWN0IGluaXRpYWxpemF0aW9uIChuZyBuZXcgb3IgbmcgaW5pdCkuXG4gKlxuICogVGhpcyBpcyBuZWNlc3NhcnkgYmVjYXVzZSB0aGUgQW5ndWxhciBDTEkgb25seSBleHBvc2VzIHRoZSBkZWZhdWx0IHZhbHVlcyBmb3IgdGhlIFwiLS1zdHlsZVwiLFxuICogXCItLWlubGluZVN0eWxlXCIsIFwiLS1za2lwVGVzdHNcIiBhbmQgXCItLWlubGluZVRlbXBsYXRlXCIgb3B0aW9ucyB0byB0aGUgXCJjb21wb25lbnRcIiBzY2hlbWF0aWMuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBnZXREZWZhdWx0Q29tcG9uZW50T3B0aW9ucyhwcm9qZWN0OiBXb3Jrc3BhY2VQcm9qZWN0KSB7XG4gIC8vIE5vdGU6IE5vdCBhbGwgb3B0aW9ucyB3aGljaCBhcmUgYXZhaWxhYmxlIHdoZW4gcnVubmluZyBcIm5nIG5ld1wiIHdpbGwgYmUgc3RvcmVkIGluIHRoZVxuICAvLyB3b3Jrc3BhY2UgY29uZmlnLiBMaXN0IG9mIG9wdGlvbnMgd2hpY2ggd2lsbCBiZSBhdmFpbGFibGUgaW4gdGhlIGNvbmZpZ3VyYXRpb246XG4gIC8vIGFuZ3VsYXIvYW5ndWxhci1jbGkvYmxvYi9tYXN0ZXIvcGFja2FnZXMvc2NoZW1hdGljcy9hbmd1bGFyL2FwcGxpY2F0aW9uL2luZGV4LnRzI0wxMDktTDEzMVxuICBsZXQgc2tpcFRlc3RzID0gZ2V0RGVmYXVsdENvbXBvbmVudE9wdGlvbjxib29sZWFufG51bGw+KHByb2plY3QsIFsnc2tpcFRlc3RzJ10sIG51bGwpO1xuXG4gIC8vIEluIGNhc2UgXCJza2lwVGVzdHNcIiBpcyBub3Qgc2V0IGV4cGxpY2l0bHksIGFsc28gbG9vayBmb3IgdGhlIFwic3BlY1wiIG9wdGlvbi4gVGhlIFwic3BlY1wiXG4gIC8vIG9wdGlvbiBoYXMgYmVlbiBkZXByZWNhdGVkIGJ1dCBjYW4gYmUgc3RpbGwgdXNlZCBpbiBvbGRlciBBbmd1bGFyIENMSSBwcm9qZWN0cy5cbiAgLy8gU2VlOiBodHRwczovL2dpdGh1Yi5jb20vYW5ndWxhci9hbmd1bGFyLWNsaS9jb21taXQvYTEyYTRlMDJhNDY4OWI1YmRiYzZlNzQwYzBkOTg2NWFmYjU1NjcxYVxuICBpZiAoc2tpcFRlc3RzID09PSBudWxsKSB7XG4gICAgc2tpcFRlc3RzID0gIWdldERlZmF1bHRDb21wb25lbnRPcHRpb24ocHJvamVjdCwgWydzcGVjJ10sIHRydWUpO1xuICB9XG5cbiAgcmV0dXJuIHtcbiAgICBzdHlsZTogZ2V0RGVmYXVsdENvbXBvbmVudE9wdGlvbihwcm9qZWN0LCBbJ3N0eWxlJywgJ3N0eWxlZXh0J10sICdjc3MnKSxcbiAgICBpbmxpbmVTdHlsZTogZ2V0RGVmYXVsdENvbXBvbmVudE9wdGlvbihwcm9qZWN0LCBbJ2lubGluZVN0eWxlJ10sIGZhbHNlKSxcbiAgICBpbmxpbmVUZW1wbGF0ZTogZ2V0RGVmYXVsdENvbXBvbmVudE9wdGlvbihwcm9qZWN0LCBbJ2lubGluZVRlbXBsYXRlJ10sIGZhbHNlKSxcbiAgICBza2lwVGVzdHM6IHNraXBUZXN0cyxcbiAgfTtcbn1cblxuLyoqXG4gKiBHZXRzIHRoZSBkZWZhdWx0IHZhbHVlIGZvciB0aGUgc3BlY2lmaWVkIG9wdGlvbi4gVGhlIGRlZmF1bHQgb3B0aW9ucyB3aWxsIGJlIGRldGVybWluZWRcbiAqIGJ5IGxvb2tpbmcgYXQgdGhlIHN0b3JlZCBzY2hlbWF0aWMgb3B0aW9ucyBmb3IgYEBzY2hlbWF0aWNzL2FuZ3VsYXI6Y29tcG9uZW50YCBpbiB0aGVcbiAqIENMSSB3b3Jrc3BhY2UgY29uZmlndXJhdGlvbi5cbiAqL1xuZnVuY3Rpb24gZ2V0RGVmYXVsdENvbXBvbmVudE9wdGlvbjxUPihwcm9qZWN0OiBXb3Jrc3BhY2VQcm9qZWN0LCBvcHRpb25OYW1lczogc3RyaW5nW10sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZhbGxiYWNrVmFsdWU6IFQpOiBUIHtcbiAgZm9yIChsZXQgb3B0aW9uTmFtZSBvZiBvcHRpb25OYW1lcykge1xuICAgIGlmIChwcm9qZWN0LnNjaGVtYXRpY3MgJiZcbiAgICAgICAgcHJvamVjdC5zY2hlbWF0aWNzWydAc2NoZW1hdGljcy9hbmd1bGFyOmNvbXBvbmVudCddICYmXG4gICAgICAgIHByb2plY3Quc2NoZW1hdGljc1snQHNjaGVtYXRpY3MvYW5ndWxhcjpjb21wb25lbnQnXVtvcHRpb25OYW1lXSAhPSBudWxsKSB7XG5cbiAgICAgIHJldHVybiBwcm9qZWN0LnNjaGVtYXRpY3NbJ0BzY2hlbWF0aWNzL2FuZ3VsYXI6Y29tcG9uZW50J11bb3B0aW9uTmFtZV07XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIGZhbGxiYWNrVmFsdWU7XG59XG4iXX0=