"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTargetsByBuilderName = exports.getProjectTargetOptions = exports.defaultTargetBuilders = void 0;
const schematics_1 = require("@angular-devkit/schematics");
/** Object that maps a CLI target to its default builder name. */
exports.defaultTargetBuilders = {
    build: '@angular-devkit/build-angular:browser',
    test: '@angular-devkit/build-angular:karma',
};
/** Resolves the architect options for the build target of the given project. */
function getProjectTargetOptions(project, buildTarget) {
    if (project.targets && project.targets[buildTarget] && project.targets[buildTarget].options) {
        return project.targets[buildTarget].options;
    }
    // TODO(devversion): consider removing this architect check if the CLI completely switched
    // over to `targets`, and the `architect` support has been removed.
    // See: https://github.com/angular/angular-cli/commit/307160806cb48c95ecb8982854f452303801ac9f
    if (project.architect && project.architect[buildTarget] &&
        project.architect[buildTarget].options) {
        return project.architect[buildTarget].options;
    }
    throw new schematics_1.SchematicsException(`Cannot determine project target configuration for: ${buildTarget}.`);
}
exports.getProjectTargetOptions = getProjectTargetOptions;
/** Gets all targets from the given project that match the specified builder name. */
function getTargetsByBuilderName(project, builderName) {
    const targets = project.targets || project.architect || {};
    return Object.keys(targets)
        .filter(name => targets[name].builder === builderName)
        .map(name => targets[name]);
}
exports.getTargetsByBuilderName = getTargetsByBuilderName;
//# sourceMappingURL=data:application/json;base64,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