"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProjectIndexFiles = void 0;
const project_targets_1 = require("./project-targets");
/** Gets the path of the index file in the given project. */
function getProjectIndexFiles(project) {
    // Use a set to remove duplicate index files referenced in multiple build targets
    // of a project.
    return [...new Set(project_targets_1.getTargetsByBuilderName(project, project_targets_1.defaultTargetBuilders.build)
            .filter(t => t.options.index)
            .map(t => t.options.index))];
}
exports.getProjectIndexFiles = getProjectIndexFiles;
//# sourceMappingURL=data:application/json;base64,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